/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.ncpdp;

import com.mirth.connect.donkey.model.message.MessageSerializer;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.converters.XMLPrettyPrinter;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.datatypes.ncpdp.NCPDPDeserializationProperties;
import com.mirth.connect.plugins.datatypes.ncpdp.NCPDPReader;
import com.mirth.connect.plugins.datatypes.ncpdp.NCPDPReference;
import com.mirth.connect.plugins.datatypes.ncpdp.NCPDPSerializationProperties;
import com.mirth.connect.plugins.datatypes.ncpdp.NCPDPXMLHandler;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.StringUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class NCPDPSerializer
implements IMessageSerializer {
    private NCPDPSerializationProperties serializationProperties;
    private NCPDPDeserializationProperties deserializationProperties;
    private Logger logger = LogManager.getLogger(this.getClass());
    private String serializationSegmentDelimiter = null;
    private String serializationGroupDelimiter = null;
    private String serializationFieldDelimiter = null;
    private String deserializationSegmentDelimiter = null;
    private String deserializationGroupDelimiter = null;
    private String deserializationFieldDelimiter = null;
    private static Pattern prettyPattern = Pattern.compile(">\\s+<");

    public NCPDPSerializer(SerializerProperties properties) {
        this.serializationProperties = (NCPDPSerializationProperties)properties.getSerializationProperties();
        this.deserializationProperties = (NCPDPDeserializationProperties)properties.getDeserializationProperties();
        if (this.serializationProperties != null) {
            this.serializationSegmentDelimiter = StringUtil.unescape((String)this.serializationProperties.getSegmentDelimiter());
            this.serializationGroupDelimiter = StringUtil.unescape((String)this.serializationProperties.getGroupDelimiter());
            this.serializationFieldDelimiter = StringUtil.unescape((String)this.serializationProperties.getFieldDelimiter());
        }
        if (this.deserializationProperties != null) {
            this.deserializationSegmentDelimiter = StringUtil.unescape((String)this.deserializationProperties.getSegmentDelimiter());
            this.deserializationGroupDelimiter = StringUtil.unescape((String)this.deserializationProperties.getGroupDelimiter());
            this.deserializationFieldDelimiter = StringUtil.unescape((String)this.deserializationProperties.getFieldDelimiter());
        }
    }

    public String getDeserializationSegmentDelimiter() {
        return this.deserializationSegmentDelimiter;
    }

    public String getDeserializationGroupDelimiter() {
        return this.deserializationGroupDelimiter;
    }

    public String getDeserializationFieldDelimiter() {
        return this.deserializationFieldDelimiter;
    }

    public boolean isSerializationRequired(boolean toXml) {
        boolean serializationRequired = false;
        if (!toXml && this.deserializationProperties.isUseStrictValidation()) {
            serializationRequired = true;
        }
        return serializationRequired;
    }

    public String transformWithoutSerializing(String message, MessageSerializer outboundSerializer) throws MessageSerializerException {
        try {
            boolean transformed = false;
            NCPDPSerializer serializer = (NCPDPSerializer)outboundSerializer;
            String outputSegmentDelimiter = serializer.getDeserializationSegmentDelimiter();
            String outputGroupDelimiter = serializer.getDeserializationGroupDelimiter();
            String outputFieldDelimiter = serializer.getDeserializationFieldDelimiter();
            if (!this.serializationSegmentDelimiter.equals(outputSegmentDelimiter)) {
                message = StringUtils.replace((String)message, (String)this.serializationSegmentDelimiter, (String)outputSegmentDelimiter);
                transformed = true;
            }
            if (!this.serializationGroupDelimiter.equals(outputGroupDelimiter)) {
                message = StringUtils.replace((String)message, (String)this.serializationGroupDelimiter, (String)outputGroupDelimiter);
                transformed = true;
            }
            if (!this.serializationFieldDelimiter.equals(outputFieldDelimiter)) {
                message = StringUtils.replace((String)message, (String)this.serializationFieldDelimiter, (String)outputFieldDelimiter);
                transformed = true;
            }
            if (transformed) {
                return message;
            }
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error transforming NCPDP", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error transforming NCPDP", (Throwable)e));
        }
        return null;
    }

    public String fromXML(String source) throws MessageSerializerException {
        String version = "D0";
        if (source.indexOf("D0") == -1) {
            version = "51";
        } else if (source.indexOf("51") == -1) {
            version = "D0";
        } else if (source.indexOf("51") < source.indexOf("D0")) {
            version = "51";
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            NCPDPXMLHandler handler = new NCPDPXMLHandler(this.deserializationSegmentDelimiter, this.deserializationGroupDelimiter, this.deserializationFieldDelimiter, version);
            reader.setContentHandler(handler);
            if (this.deserializationProperties.isUseStrictValidation()) {
                reader.setFeature("http://xml.org/sax/features/validation", true);
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "ncpdp" + version + ".xsd");
                reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", "/ncpdp" + version + ".xsd");
            }
            String rawXmlSource = prettyPattern.matcher(source).replaceAll("><");
            String tansformedSource = source.contains("<TransactionHeaderRequest>") ? this.validateTransformHeader(rawXmlSource) : rawXmlSource;
            reader.parse(new InputSource(new StringReader(tansformedSource)));
            return handler.getOutput().toString();
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting XML to NCPDP message.", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting XML to NCPDP", (Throwable)e));
        }
    }

    public String validateTransformHeader(String sourceXml) {
        Map headerFieldsLengthMap = new LinkedHashMap<String, Integer>();
        headerFieldsLengthMap.put("BinNumber", 6);
        headerFieldsLengthMap.put("VersionReleaseNumber", 2);
        headerFieldsLengthMap.put("TransactionCode", 2);
        headerFieldsLengthMap.put("ProcessorControlNumber", 10);
        headerFieldsLengthMap.put("TransactionCount", 1);
        headerFieldsLengthMap.put("ServiceProviderIdQualifier", 2);
        headerFieldsLengthMap.put("ServiceProviderId", 15);
        headerFieldsLengthMap.put("DateOfService", 8);
        headerFieldsLengthMap.put("SoftwareVendorCertificationId", 10);
        headerFieldsLengthMap = Collections.unmodifiableMap(headerFieldsLengthMap);
        String transformedXml = sourceXml;
        for (Map.Entry entry : headerFieldsLengthMap.entrySet()) {
            String fieldValue;
            String paddingString = "";
            String tagValue = (String)entry.getKey();
            int fieldLength = (Integer)entry.getValue();
            paddingString = StringUtils.leftPad((String)paddingString, (int)fieldLength);
            if (transformedXml.contains("<" + tagValue + "/>")) {
                transformedXml = transformedXml.replace("<" + tagValue + "/>", "<" + tagValue + ">" + paddingString + "</" + tagValue + ">");
            }
            if (transformedXml.contains("<" + tagValue + "></" + tagValue + ">")) {
                transformedXml = transformedXml.replace("<" + tagValue + "></" + tagValue + ">", "<" + tagValue + ">" + paddingString + "</" + tagValue + ">");
                continue;
            }
            if (!transformedXml.contains("<" + tagValue + ">") || (fieldValue = StringUtils.substringBetween((String)transformedXml, (String)("<" + tagValue + ">"), (String)"</")).length() >= fieldLength) continue;
            String replacementString = paddingString.substring(0, fieldLength - fieldValue.length()) + "</" + tagValue + ">";
            transformedXml = transformedXml.replace("</" + tagValue + ">", replacementString);
        }
        return transformedXml;
    }

    public String toXML(String source) throws MessageSerializerException {
        try {
            NCPDPReader ncpdpReader = new NCPDPReader(this.serializationSegmentDelimiter, this.serializationGroupDelimiter, this.serializationFieldDelimiter);
            StringWriter stringWriter = new StringWriter();
            XMLPrettyPrinter serializer = new XMLPrettyPrinter((Writer)stringWriter);
            ncpdpReader.setContentHandler((ContentHandler)serializer);
            ncpdpReader.parse(new InputSource(new StringReader(source)));
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new MessageSerializerException("Error converting NCPDP message to XML.", (Throwable)e, ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)"Error converting NCPDP to XML", (Throwable)e));
        }
    }

    public Map<String, Object> getMetaDataFromMessage(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.populateMetaData(message, map);
        if (!map.containsKey("mirth_version")) {
            map.put("mirth_version", "5.1");
        }
        return map;
    }

    public void populateMetaData(String message, Map<String, Object> map) {
        try {
            int segmentDelimiterIndex = message.indexOf(this.serializationSegmentDelimiter);
            if (segmentDelimiterIndex == -1) {
                return;
            }
            int versionPos = 6;
            int typePos = 8;
            int sourcePos = 23;
            if (segmentDelimiterIndex <= 40) {
                versionPos = 0;
                typePos = 2;
                sourcePos = 8;
            }
            if (versionPos + 2 <= message.length()) {
                map.put("mirth_version", message.substring(versionPos, versionPos + 2));
            }
            if (typePos + 2 <= message.length()) {
                map.put("message_type", NCPDPReference.getInstance().getTransactionName(message.substring(typePos, typePos + 2)));
            }
            if (sourcePos + 15 <= message.length()) {
                map.put("message_source", message.substring(sourcePos, sourcePos + 15));
            }
        }
        catch (Exception e) {
            this.logger.error("Error populating NCPDP metadata.", (Throwable)e);
        }
    }

    public String toJSON(String message) throws MessageSerializerException {
        return null;
    }

    public String fromJSON(String message) throws MessageSerializerException {
        return null;
    }
}

