/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.ncpdp;

import com.mirth.connect.plugins.datatypes.ncpdp.NCPDPReference;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class NCPDPXMLHandler
extends DefaultHandler {
    private String segmentDelimeter;
    private String groupDelimeter;
    private String fieldDelimeter;
    private String version;
    private Location currentLocation = Location.DOCUMENT;
    private boolean sawHeader = false;
    private boolean inTransactionHeader = false;
    private boolean inGroup = false;
    private StringBuilder output = new StringBuilder();
    private NCPDPReference reference = NCPDPReference.getInstance();

    public NCPDPXMLHandler(String segmentDelimeter, String groupDelimeter, String fieldDelimeter, String version) {
        this.segmentDelimeter = segmentDelimeter;
        this.groupDelimeter = groupDelimeter;
        this.fieldDelimeter = fieldDelimeter;
        this.version = version;
    }

    @Override
    public void startDocument() {
        this.currentLocation = Location.DOCUMENT;
        this.inGroup = false;
        this.inTransactionHeader = false;
    }

    @Override
    public void endDocument() {
        this.currentLocation = Location.DOCUMENT;
        this.inGroup = false;
        this.inTransactionHeader = false;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        block14: {
            block15: {
                block17: {
                    block16: {
                        block13: {
                            if (this.sawHeader) break block13;
                            this.sawHeader = true;
                            break block14;
                        }
                        if (!this.inTransactionHeader && name.startsWith("TransactionHeader")) {
                            this.inTransactionHeader = true;
                        }
                        if (!this.currentLocation.equals((Object)Location.DOCUMENT)) break block15;
                        if (!name.equals("TRANSACTIONS")) break block16;
                        this.currentLocation = Location.DOCUMENT;
                        break block14;
                    }
                    if (!name.equals("TRANSACTION")) break block17;
                    this.output.append(this.groupDelimeter);
                    this.currentLocation = Location.GROUP;
                    break block14;
                }
                this.currentLocation = Location.SEGMENT;
                if (this.inTransactionHeader) break block14;
                this.output.append(this.segmentDelimeter);
                this.output.append(this.fieldDelimeter);
                this.output.append(this.reference.getSegmentIdByName(name, this.version));
                if (atts != null && atts.getLength() > 0) {
                    for (int i = 0; i < atts.getLength(); ++i) {
                        this.output.append(this.fieldDelimeter);
                        String localName = atts.getLocalName(i);
                        String value = atts.getValue(i);
                        this.output.append(this.reference.getCodeByName(localName, this.version));
                        this.output.append(value);
                    }
                }
                break block14;
            }
            if (this.currentLocation.equals((Object)Location.GROUP)) {
                this.output.append(this.segmentDelimeter);
                this.output.append(this.fieldDelimeter);
                this.output.append(this.reference.getSegmentIdByName(name, this.version));
                if (atts != null && atts.getLength() > 0) {
                    for (int i = 0; i < atts.getLength(); ++i) {
                        this.output.append(this.fieldDelimeter);
                        String localName = atts.getLocalName(i);
                        String value = atts.getValue(i);
                        this.output.append(this.reference.getCodeByName(localName, this.version));
                        this.output.append(value);
                    }
                }
                this.inGroup = true;
                this.currentLocation = Location.SEGMENT;
            } else if (this.currentLocation.equals((Object)Location.SEGMENT)) {
                this.currentLocation = Location.FIELD;
                if (!this.inTransactionHeader) {
                    this.output.append(this.fieldDelimeter);
                    if (this.isCounterOrCountField(name)) {
                        this.output.append(this.reference.getCodeByName(name, this.version));
                        this.output.append(atts.getValue(0));
                        this.currentLocation = Location.SEGMENT;
                    } else {
                        this.output.append(this.reference.getCodeByName(name, this.version));
                        if (atts != null && atts.getLength() > 0) {
                            for (int i = 0; i < atts.getLength(); ++i) {
                                this.output.append(this.fieldDelimeter);
                                String localName = atts.getLocalName(i);
                                String value = atts.getValue(i);
                                this.output.append(this.reference.getCodeByName(localName, this.version));
                                this.output.append(value);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.currentLocation.equals((Object)Location.SEGMENT)) {
            this.currentLocation = this.isCounterOrCountField(name) ? Location.SEGMENT : (this.inGroup ? Location.GROUP : Location.DOCUMENT);
            this.inTransactionHeader = false;
        } else if (this.currentLocation.equals((Object)Location.GROUP)) {
            this.currentLocation = Location.DOCUMENT;
            this.inGroup = false;
        } else if (this.currentLocation.equals((Object)Location.FIELD)) {
            this.currentLocation = Location.SEGMENT;
        } else if (this.currentLocation.equals((Object)Location.DOCUMENT)) {
            // empty if block
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.output.append(ch, start, length);
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    private boolean isCounterOrCountField(String fieldDescription) {
        return fieldDescription.endsWith("Counter") || fieldDescription.endsWith("Count");
    }

    private static enum Location {
        DOCUMENT,
        SEGMENT,
        GROUP,
        FIELD,
        REPETITION;

    }
}

