/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.globalmapviewer;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.ViewContentDialog;
import com.mirth.connect.client.ui.components.MirthTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class GlobalMapPanel
extends JPanel {
    private static final int SERVER_ID_COLUMN = 0;
    private static final int CHANNEL_COLUMN = 1;
    private static final int KEY_COLUMN = 2;
    private static final int VALUE_COLUMN = 3;
    private String selectedServer;
    private String selectedMap;
    private String selectedVar;
    private JXTable mapTable;
    private JScrollPane mapScrollPane;

    public GlobalMapPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setLayout((LayoutManager)new MigLayout("fill, insets 0"));
        this.mapTable = new MirthTable();
        this.mapTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.mapTable.getTableHeader().setReorderingAllowed(false);
        this.mapTable.setSortable(false);
        this.mapTable.setEditable(false);
        this.mapTable.setFocusable(false);
        this.mapTable.setSelectionMode(0);
        this.mapTable.setModel((TableModel)new RefreshTableModel((Object[][])new String[0][], (Object[])new String[]{"Server Id", "Channel", "Key", "Value"}));
        this.mapTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int row = GlobalMapPanel.this.mapTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
                if (row == -1) {
                    return;
                }
                if (evt.getClickCount() >= 2) {
                    new ViewContentDialog((String)GlobalMapPanel.this.mapTable.getModel().getValueAt(GlobalMapPanel.this.mapTable.convertRowIndexToModel(row), 3));
                }
            }
        });
        this.mapTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (GlobalMapPanel.this.mapTable.getSelectedRow() != -1) {
                    GlobalMapPanel.this.selectedServer = (String)GlobalMapPanel.this.mapTable.getValueAt(GlobalMapPanel.this.mapTable.getSelectedRow(), 0);
                    GlobalMapPanel.this.selectedMap = (String)GlobalMapPanel.this.mapTable.getValueAt(GlobalMapPanel.this.mapTable.getSelectedRow(), 1);
                    GlobalMapPanel.this.selectedVar = (String)GlobalMapPanel.this.mapTable.getValueAt(GlobalMapPanel.this.mapTable.getSelectedRow(), 2);
                } else {
                    GlobalMapPanel.this.selectedServer = null;
                    GlobalMapPanel.this.selectedMap = null;
                    GlobalMapPanel.this.selectedVar = null;
                }
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.mapTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.mapScrollPane = new JScrollPane();
        this.mapScrollPane.setViewportView((Component)this.mapTable);
        this.add((Component)this.mapScrollPane, "grow");
    }

    public synchronized void updateTable(Vector<Object> data, int selectedRow) {
        RefreshTableModel model = (RefreshTableModel)this.mapTable.getModel();
        model.refreshDataVector(data);
        if (selectedRow > 0 && selectedRow <= this.mapTable.getRowCount()) {
            this.mapTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
        }
    }

    public String getSelectedServer() {
        return this.selectedServer;
    }

    public String getSelectedMap() {
        return this.selectedMap;
    }

    public String getSelectedVar() {
        return this.selectedVar;
    }
}

