/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.xsltstep;

import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.FilterTransformerIterable;
import com.mirth.connect.model.IteratorProperties;
import com.mirth.connect.model.Step;
import com.mirth.connect.util.JavaScriptSharedUtil;
import com.mirth.connect.util.ScriptBuilderException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="step")
public class XsltStep
extends Step
implements FilterTransformerIterable<Step> {
    public static final String PLUGIN_POINT = "XSLT Step";
    private String sourceXml;
    private String resultVariable;
    private String template;
    private boolean useCustomFactory;
    private String customFactory;

    public XsltStep() {
        this.sourceXml = "";
        this.resultVariable = "";
        this.template = "";
        this.useCustomFactory = false;
        this.customFactory = "";
    }

    public XsltStep(XsltStep props) {
        super((Step)props);
        this.sourceXml = props.getSourceXml();
        this.resultVariable = props.getResultVariable();
        this.template = props.getTemplate();
        this.useCustomFactory = props.isUseCustomFactory();
        this.customFactory = props.getCustomFactory();
    }

    public String getScript(boolean loadFiles) {
        StringBuilder script = new StringBuilder();
        script.append(this.getTransformationScript());
        script.append("channelMap.put('" + this.resultVariable + "', resultVar.toString());\n");
        return script.toString();
    }

    private String getTransformationScript() {
        StringBuilder script = new StringBuilder();
        if (this.useCustomFactory && StringUtils.isNotEmpty((CharSequence)this.customFactory)) {
            script.append("tFactory = Packages.javax.xml.transform.TransformerFactory.newInstance(\"" + this.customFactory + "\", null);\n");
        } else {
            script.append("tFactory = Packages.javax.xml.transform.TransformerFactory.newInstance();\n");
        }
        script.append("xsltTemplate = new Packages.java.io.StringReader(" + this.template + ");\n");
        script.append("transformer = tFactory.newTransformer(new Packages.javax.xml.transform.stream.StreamSource(xsltTemplate));\n");
        script.append("sourceVar = new Packages.java.io.StringReader(" + this.sourceXml + ");\n");
        script.append("resultVar = new Packages.java.io.StringWriter();\n");
        script.append("transformer.transform(new Packages.javax.xml.transform.stream.StreamSource(sourceVar), new Packages.javax.xml.transform.stream.StreamResult(resultVar));\n");
        return script.toString();
    }

    public String getPreScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        script.append("var _").append(JavaScriptSharedUtil.convertIdentifier((String)this.resultVariable)).append(" = Lists.list();");
        return script.toString();
    }

    public String getIterationScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        script.append(this.getTransformationScript());
        script.append('_').append(JavaScriptSharedUtil.convertIdentifier((String)this.resultVariable)).append(".add(resultVar.toString());\n");
        return script.toString();
    }

    public String getPostScript(boolean loadFiles, LinkedList<IteratorProperties<Step>> ancestors) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        script.append("channelMap.put('").append(this.resultVariable).append("', _").append(JavaScriptSharedUtil.convertIdentifier((String)this.resultVariable)).append(".toArray());\n");
        return script.toString();
    }

    public String getSourceXml() {
        return this.sourceXml;
    }

    public void setSourceXml(String sourceXml) {
        this.sourceXml = sourceXml;
    }

    public String getResultVariable() {
        return this.resultVariable;
    }

    public void setResultVariable(String resultVariable) {
        this.resultVariable = resultVariable;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean isUseCustomFactory() {
        return this.useCustomFactory;
    }

    public void setUseCustomFactory(boolean useCustomFactory) {
        this.useCustomFactory = useCustomFactory;
    }

    public String getCustomFactory() {
        return this.customFactory;
    }

    public void setCustomFactory(String customFactory) {
        this.customFactory = customFactory;
    }

    public String getType() {
        return PLUGIN_POINT;
    }

    public Step clone() {
        return new XsltStep(this);
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("templateLines", PurgeUtil.countLines((String)this.template));
        purgedProperties.put("useCustomFactory", this.useCustomFactory);
        return purgedProperties;
    }
}

