/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.vm;

import com.mirth.connect.connectors.vm.VmDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.plugins.DataTypeServerPlugin;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.util.GlobalChannelVariableStore;
import com.mirth.connect.server.util.GlobalChannelVariableStoreFactory;
import com.mirth.connect.server.util.GlobalVariableStore;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VmDispatcher
extends DestinationConnector {
    private static final String SOURCE_CHANNEL_ID = "sourceChannelId";
    private static final String SOURCE_CHANNEL_IDS = "sourceChannelIds";
    private static final String SOURCE_MESSAGE_ID = "sourceMessageId";
    private static final String SOURCE_MESSAGE_IDS = "sourceMessageIds";
    private VmDispatcherProperties connectorProperties;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ConfigurationController.getInstance();
    private GlobalVariableStore globalMap;
    private GlobalChannelVariableStore globalChannelMap;
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (VmDispatcherProperties)this.getConnectorProperties();
        this.globalMap = GlobalVariableStore.getInstance();
        this.globalChannelMap = GlobalChannelVariableStoreFactory.getInstance().get(this.getChannelId());
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
    }

    public void onStop() throws ConnectorTaskException {
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.DISCONNECTED));
    }

    public void onHalt() throws ConnectorTaskException {
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.DISCONNECTED));
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        VmDispatcherProperties vmDispatcherProperties = (VmDispatcherProperties)connectorProperties;
        vmDispatcherProperties.setChannelId(this.replacer.replaceValues(vmDispatcherProperties.getChannelId(), connectorMessage));
        vmDispatcherProperties.setChannelTemplate(this.replacer.replaceValues(vmDispatcherProperties.getChannelTemplate(), connectorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage message) {
        VmDispatcherProperties vmDispatcherProperties = (VmDispatcherProperties)connectorProperties;
        String targetChannelId = vmDispatcherProperties.getChannelId();
        String currentChannelId = this.getChannelId();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(currentChannelId, Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.SENDING, "Target Channel: " + targetChannelId));
        String responseData = null;
        String responseError = null;
        Object responseStatusMessage = null;
        Status responseStatus = Status.QUEUED;
        boolean validateResponse = false;
        try {
            if (!targetChannelId.equals("none")) {
                boolean isBinary = ((DataTypeServerPlugin)ExtensionController.getInstance().getDataTypePlugins().get(this.getOutboundDataType().getType())).isBinary();
                byte[] data = this.getAttachmentHandlerProvider().reAttachMessage(vmDispatcherProperties.getChannelTemplate(), message, "UTF-8", isBinary, vmDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
                RawMessage rawMessage = isBinary ? new RawMessage(data) : new RawMessage(StringUtils.newString((byte[])data, (String)"UTF-8"));
                Map rawSourceMap = rawMessage.getSourceMap();
                Map sourceMap = message.getSourceMap();
                List<String> sourceChannelIds = this.getSourceChannelIds(sourceMap);
                List<Long> sourceMessageIds = this.getSourceMessageIds(sourceMap);
                if (sourceChannelIds != null) {
                    sourceChannelIds.add(currentChannelId);
                    rawSourceMap.put(SOURCE_CHANNEL_IDS, sourceChannelIds);
                }
                if (sourceMessageIds != null) {
                    sourceMessageIds.add(message.getMessageId());
                    rawSourceMap.put(SOURCE_MESSAGE_IDS, sourceMessageIds);
                }
                rawSourceMap.put(SOURCE_CHANNEL_ID, currentChannelId);
                rawSourceMap.put(SOURCE_MESSAGE_ID, message.getMessageId());
                List keys = vmDispatcherProperties.getMapVariables();
                if (CollectionUtils.isNotEmpty((Collection)keys)) {
                    for (String key : keys) {
                        Object value = this.getMapValue(message, key);
                        if (value == null) continue;
                        rawSourceMap.put(key, value);
                    }
                }
                data = null;
                DispatchResult dispatchResult = ControllerFactory.getFactory().createEngineController().dispatchRawMessage(targetChannelId, rawMessage, false, true);
                if (dispatchResult != null && dispatchResult.getSelectedResponse() != null) {
                    responseData = dispatchResult.getSelectedResponse().getMessage();
                }
                validateResponse = vmDispatcherProperties.getDestinationConnectorProperties().isValidateResponse();
            }
            responseStatus = Status.SENT;
            responseStatusMessage = "Message routed successfully to channel id: " + targetChannelId;
        }
        catch (Throwable e) {
            this.eventController.dispatchEvent((Event)new ErrorEvent(currentChannelId, Integer.valueOf(this.getMetaDataId()), Long.valueOf(message.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error routing message to channel id: " + targetChannelId, e));
            responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)("Error routing message to channel id: " + targetChannelId), (Throwable)e);
            responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)("Error routing message to channel id: " + targetChannelId), (Throwable)e);
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(currentChannelId, Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
        return new Response(responseStatus, responseData, (String)responseStatusMessage, responseError, validateResponse);
    }

    private List<String> getSourceChannelIds(Map<String, Object> map) {
        Object object = map.get(SOURCE_CHANNEL_ID);
        ArrayList<String> sourceChannelIds = null;
        if (object != null && object instanceof String) {
            String sourceChannelId = (String)object;
            sourceChannelIds = new ArrayList<String>();
            Object listObject = map.get(SOURCE_CHANNEL_IDS);
            if (listObject == null) {
                sourceChannelIds.add(sourceChannelId);
            } else {
                try {
                    sourceChannelIds.addAll((List)listObject);
                }
                catch (ClassCastException e) {
                    sourceChannelIds.add(sourceChannelId);
                }
            }
        }
        return sourceChannelIds;
    }

    private List<Long> getSourceMessageIds(Map<String, Object> map) {
        Object object = map.get(SOURCE_MESSAGE_ID);
        ArrayList<Long> sourceMessageIds = null;
        if (object != null && object instanceof Long) {
            Long sourceMessageId = (Long)object;
            sourceMessageIds = new ArrayList<Long>();
            Object listObject = map.get(SOURCE_MESSAGE_IDS);
            if (listObject == null) {
                sourceMessageIds.add(sourceMessageId);
            } else {
                try {
                    sourceMessageIds.addAll((List)listObject);
                }
                catch (ClassCastException e) {
                    sourceMessageIds.add(sourceMessageId);
                }
            }
        }
        return sourceMessageIds;
    }

    private Object getMapValue(ConnectorMessage connectorMessage, String key) {
        Object value = null;
        try {
            value = connectorMessage.getResponseMap().containsKey(key) ? (Object)connectorMessage.getResponseMap().get(key) : (connectorMessage.getConnectorMap().containsKey(key) ? (Object)connectorMessage.getConnectorMap().get(key) : (connectorMessage.getChannelMap().containsKey(key) ? (Object)connectorMessage.getChannelMap().get(key) : (connectorMessage.getSourceMap().containsKey(key) ? (Object)connectorMessage.getSourceMap().get(key) : (this.globalChannelMap.containsKey(key) ? this.globalChannelMap.get(key) : (this.globalMap.containsKey(key) ? this.globalMap.get(key) : this.configurationController.getConfigurationMap().get(key))))));
        }
        catch (Exception e) {
            this.logger.warn("Unable to retrieve metadata value for " + key + ".", (Throwable)e);
        }
        return value;
    }
}

