/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ER7Reader
extends SAXParser {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private boolean handleRepetitions = false;
    private boolean handleSubcomponents = false;
    private String segmentDelimiter;
    private static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();
    private static final String DEFAULT_FIELD_SEPARATOR = "|";
    private static final String DEFAULT_COMPONENT_SEPARATOR = "^";
    private static final String DEFAULT_REPETITION_SEPARATOR = "~";
    private static final String DEFAULT_ESCAPE_CHARACTER = "";
    private static final String DEFAULT_SUBCOMPONENT_TERMINATOR = "";
    public static final String MESSAGE_ROOT_ID = "HL7Message";

    public ER7Reader(boolean handleRepetitions, boolean handleSubcomponents, String segmentDelimiter) {
        this.handleRepetitions = handleRepetitions;
        this.handleSubcomponents = handleSubcomponents;
        this.segmentDelimiter = segmentDelimiter;
    }

    private String getMessageFromSource(InputSource source) throws IOException {
        int c;
        BufferedReader reader = new BufferedReader(source.getCharacterStream());
        StringBuilder builder = new StringBuilder();
        while ((c = reader.read()) != -1) {
            builder.append((char)c);
        }
        return builder.toString().trim();
    }

    public void parse(InputSource source) throws SAXException, IOException {
        String message = this.getMessageFromSource(source);
        ContentHandler contentHandler = this.getContentHandler();
        contentHandler.startDocument();
        if (message == null || message.length() < 6) {
            throw new SAXException("Unable to parse message. It is NULL or too short. " + message);
        }
        String fieldSeparator = DEFAULT_FIELD_SEPARATOR;
        String componentSeparator = DEFAULT_COMPONENT_SEPARATOR;
        String repetitionSeparator = DEFAULT_REPETITION_SEPARATOR;
        String escapeCharacter = "";
        String subcomponentSeparator = "";
        String firstSegment = message.substring(0, 3);
        if (firstSegment.equalsIgnoreCase("MSH") || firstSegment.equalsIgnoreCase("FHS") || firstSegment.equalsIgnoreCase("BHS")) {
            fieldSeparator = new String(new char[]{message.charAt(3)});
            int nextDelimiter = message.indexOf(message.charAt(3), 4);
            if (nextDelimiter == -1) {
                nextDelimiter = message.length();
            }
            if (nextDelimiter > 4) {
                componentSeparator = new String(new char[]{message.charAt(4)});
            }
            if (nextDelimiter > 5) {
                repetitionSeparator = new String(new char[]{message.charAt(5)});
            }
            if (nextDelimiter > 6) {
                escapeCharacter = new String(new char[]{message.charAt(6)});
            }
            if (nextDelimiter > 7) {
                subcomponentSeparator = new String(new char[]{message.charAt(7)});
            }
        }
        if (message.length() >= 8 && "^~&|".equals(message.substring(4, 8))) {
            escapeCharacter = "\\";
            subcomponentSeparator = "&";
            repetitionSeparator = DEFAULT_REPETITION_SEPARATOR;
            componentSeparator = DEFAULT_COMPONENT_SEPARATOR;
        }
        String[] segments = StringUtils.split((String)message, (String)this.segmentDelimiter);
        String documentHead = this.handleSegments("", contentHandler, fieldSeparator, componentSeparator, subcomponentSeparator, repetitionSeparator, escapeCharacter, segments);
        contentHandler.endElement("", documentHead, "");
        contentHandler.endDocument();
    }

    private String handleSegments(String documentHead, ContentHandler contentHandler, String fieldSeparator, String componentSeparator, String subcomponentSeparator, String repetitionSeparator, String escapeCharacter, String[] segments) throws SAXException {
        for (int segmentIndex = 0; segmentIndex < segments.length; ++segmentIndex) {
            String segmentId;
            String segment = segments[segmentIndex];
            this.logger.trace("handling segment: " + segment);
            StringTokenizer fieldTokenizer = new StringTokenizer(segment, fieldSeparator, true);
            if (fieldTokenizer.hasMoreTokens()) {
                segmentId = fieldTokenizer.nextToken().trim();
                if (segmentIndex == 0) {
                    documentHead = MESSAGE_ROOT_ID;
                    contentHandler.startElement("", documentHead, "", null);
                }
            } else {
                throw new SAXException("Could not find fields in segment: " + segment);
            }
            contentHandler.startElement("", segmentId, "", null);
            this.handleFieldOrRepetitions(contentHandler, fieldSeparator, componentSeparator, subcomponentSeparator, repetitionSeparator, escapeCharacter, segmentId, fieldTokenizer);
            contentHandler.endElement("", segmentId, "");
        }
        return documentHead;
    }

    private void handleFieldOrRepetitions(ContentHandler contentHandler, String fieldSeparator, String componentSeparator, String subcomponentSeparator, String repetitionSeparator, String escapeCharacter, String segmentId, StringTokenizer fieldTokenizer) throws SAXException {
        int fieldId = 0;
        boolean atLastField = false;
        while (fieldTokenizer.hasMoreTokens()) {
            boolean enteredHeader = false;
            String field = fieldTokenizer.nextToken();
            if (field.equals(fieldSeparator)) {
                if (atLastField) {
                    contentHandler.startElement("", segmentId + "." + fieldId, "", null);
                    contentHandler.endElement("", segmentId + "." + fieldId, "");
                }
                ++fieldId;
                atLastField = true;
                continue;
            }
            this.logger.trace("handling field or repetition: " + field);
            atLastField = false;
            if (segmentId.equals("MSH") || segmentId.equals("FHS") || segmentId.equals("BHS")) {
                enteredHeader = true;
            }
            if (enteredHeader && fieldId == 1) {
                contentHandler.startElement("", segmentId + "." + fieldId, "", null);
                contentHandler.characters(fieldSeparator.toCharArray(), 0, 1);
                contentHandler.endElement("", segmentId + "." + fieldId, null);
                contentHandler.startElement("", segmentId + "." + ++fieldId, "", null);
                char[] specialCharacters = !subcomponentSeparator.isEmpty() ? new char[]{componentSeparator.charAt(0), repetitionSeparator.charAt(0), escapeCharacter.charAt(0), subcomponentSeparator.charAt(0)} : (!escapeCharacter.isEmpty() ? new char[]{componentSeparator.charAt(0), repetitionSeparator.charAt(0), escapeCharacter.charAt(0)} : new char[]{componentSeparator.charAt(0), repetitionSeparator.charAt(0)});
                contentHandler.characters(specialCharacters, 0, specialCharacters.length);
                contentHandler.endElement("", segmentId + "." + fieldId, null);
                continue;
            }
            if (enteredHeader && fieldId == 2) continue;
            if (this.handleRepetitions) {
                this.handleFieldRepetitions(contentHandler, componentSeparator, repetitionSeparator, subcomponentSeparator, segmentId, fieldId, field);
                continue;
            }
            this.handleField(contentHandler, componentSeparator, subcomponentSeparator, segmentId, fieldId, field);
        }
        if (atLastField) {
            contentHandler.startElement("", segmentId + "." + fieldId, "", null);
            contentHandler.endElement("", segmentId + "." + fieldId, "");
        }
    }

    private void handleFieldRepetitions(ContentHandler contentHandler, String componentSeparator, String repetitionSeparator, String subcomponentSeparator, String segmentId, int fieldId, String field) throws SAXException {
        StringTokenizer fieldRepetitionTokenizer = new StringTokenizer(field, repetitionSeparator, true);
        boolean atLastRepetition = true;
        while (fieldRepetitionTokenizer.hasMoreTokens()) {
            field = fieldRepetitionTokenizer.nextToken();
            if (field.equals(repetitionSeparator)) {
                if (atLastRepetition) {
                    contentHandler.startElement("", segmentId + "." + fieldId, "", null);
                    contentHandler.characters(EMPTY_CHAR_ARRAY, 0, 0);
                    contentHandler.endElement("", segmentId + "." + fieldId, "");
                }
                atLastRepetition = true;
                continue;
            }
            this.logger.trace("handling repetition: " + field);
            atLastRepetition = false;
            this.handleField(contentHandler, componentSeparator, subcomponentSeparator, segmentId, fieldId, field);
        }
        if (atLastRepetition) {
            contentHandler.startElement("", segmentId + "." + fieldId, "", null);
            contentHandler.characters(EMPTY_CHAR_ARRAY, 0, 0);
            contentHandler.endElement("", segmentId + "." + fieldId, "");
        }
    }

    private void handleField(ContentHandler contentHandler, String componentSeparator, String subcomponentSeparator, String segmentId, int fieldId, String field) throws SAXException {
        if (field.indexOf(componentSeparator) > -1 || this.handleSubcomponents && field.indexOf(subcomponentSeparator) > -1) {
            contentHandler.startElement("", segmentId + "." + fieldId, "", null);
            StringTokenizer componentTokenizer = new StringTokenizer(field, componentSeparator, true);
            this.handleComponents(contentHandler, componentSeparator, subcomponentSeparator, segmentId, fieldId, 1, componentTokenizer);
            contentHandler.endElement("", segmentId + "." + fieldId, null);
        } else {
            this.logger.trace("handling field: " + field);
            contentHandler.startElement("", segmentId + "." + fieldId, "", null);
            contentHandler.startElement("", segmentId + "." + fieldId + ".1", "", null);
            contentHandler.characters(field.toCharArray(), 0, field.length());
            contentHandler.endElement("", segmentId + "." + fieldId + ".1", null);
            contentHandler.endElement("", segmentId + "." + fieldId, null);
        }
    }

    private void handleComponents(ContentHandler contentHandler, String componentSeparator, String subcomponentSeparator, String segmentId, int fieldId, int componentId, StringTokenizer componentTokenizer) throws SAXException {
        boolean atLastComponent = true;
        while (componentTokenizer.hasMoreTokens()) {
            String component = componentTokenizer.nextToken();
            if (component.equals(componentSeparator)) {
                if (atLastComponent) {
                    contentHandler.startElement("", segmentId + "." + fieldId + "." + componentId, "", null);
                    contentHandler.characters(EMPTY_CHAR_ARRAY, 0, 0);
                    contentHandler.endElement("", segmentId + "." + fieldId + "." + componentId, "");
                }
                ++componentId;
                atLastComponent = true;
                continue;
            }
            atLastComponent = false;
            this.handleComponent(contentHandler, subcomponentSeparator, segmentId, fieldId, componentId, component);
        }
        if (atLastComponent) {
            contentHandler.startElement("", segmentId + "." + fieldId + "." + componentId, "", null);
            contentHandler.characters(EMPTY_CHAR_ARRAY, 0, 0);
            contentHandler.endElement("", segmentId + "." + fieldId + "." + componentId, "");
        }
    }

    private void handleComponent(ContentHandler contentHandler, String subcomponentSeparator, String segmentId, int fieldId, int componentId, String component) throws SAXException {
        if (this.handleSubcomponents && !subcomponentSeparator.isEmpty() && component.indexOf(subcomponentSeparator) > -1) {
            contentHandler.startElement("", segmentId + "." + fieldId + "." + componentId, "", null);
            StringTokenizer subcomponentTokenizer = new StringTokenizer(component, subcomponentSeparator, true);
            this.handleSubcomponents(contentHandler, subcomponentSeparator, segmentId, fieldId, componentId, 1, subcomponentTokenizer);
            contentHandler.endElement("", segmentId + "." + fieldId + "." + componentId, null);
        } else {
            this.logger.trace("handling component: " + component);
            contentHandler.startElement("", segmentId + "." + fieldId + "." + componentId, "", null);
            contentHandler.characters(component.toCharArray(), 0, component.length());
            contentHandler.endElement("", segmentId + "." + fieldId + "." + componentId, "");
        }
    }

    private void handleSubcomponents(ContentHandler contentHandler, String subcomponentSeparator, String segmentId, int fieldId, int componentId, int subcomponentId, StringTokenizer subcomponentTokenizer) throws SAXException {
        boolean atLastSubcomponent = true;
        while (subcomponentTokenizer.hasMoreTokens()) {
            String subcomponent = subcomponentTokenizer.nextToken();
            if (subcomponent.equals(subcomponentSeparator)) {
                if (atLastSubcomponent) {
                    contentHandler.startElement("", segmentId + "." + fieldId + "." + componentId + "." + subcomponentId, "", null);
                    contentHandler.characters(EMPTY_CHAR_ARRAY, 0, 0);
                    contentHandler.endElement("", segmentId + "." + fieldId + "." + componentId + "." + subcomponentId, "");
                }
                ++subcomponentId;
                atLastSubcomponent = true;
                continue;
            }
            this.logger.trace("handling subcomponent: " + subcomponentId);
            atLastSubcomponent = false;
            contentHandler.startElement("", segmentId + "." + fieldId + "." + componentId + "." + subcomponentId, "", null);
            contentHandler.characters(subcomponent.toCharArray(), 0, subcomponent.length());
            contentHandler.endElement("", segmentId + "." + fieldId + "." + componentId + "." + subcomponentId, "");
        }
        if (atLastSubcomponent) {
            contentHandler.startElement("", segmentId + "." + fieldId + "." + componentId + "." + subcomponentId, "", null);
            contentHandler.characters(EMPTY_CHAR_ARRAY, 0, 0);
            contentHandler.endElement("", segmentId + "." + fieldId + "." + componentId + "." + subcomponentId, "");
        }
    }
}

