/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.message.ResponseValidator;
import com.mirth.connect.model.datatype.ResponseValidationProperties;
import com.mirth.connect.model.datatype.SerializationProperties;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2ResponseValidationProperties;
import com.mirth.connect.plugins.datatypes.hl7v2.HL7v2SerializationProperties;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.ErrorMessageBuilder;
import com.mirth.connect.util.StringUtil;
import java.io.CharArrayReader;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class HL7v2ResponseValidator
implements ResponseValidator {
    private HL7v2SerializationProperties serializationProperties;
    private HL7v2ResponseValidationProperties responseValidationProperties;
    private String serializationSegmentDelimiter;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private static int MESSAGE_CONTROL_ID_FIELD = 10;

    public HL7v2ResponseValidator(SerializationProperties serializationProperties, ResponseValidationProperties responseValidationProperties) {
        this.serializationProperties = (HL7v2SerializationProperties)serializationProperties;
        this.responseValidationProperties = (HL7v2ResponseValidationProperties)responseValidationProperties;
        this.serializationSegmentDelimiter = StringUtil.unescape((String)this.serializationProperties.getSegmentDelimiter());
    }

    public Response validate(Response response, ConnectorMessage connectorMessage) {
        HL7v2ResponseValidationProperties responseValidationProperties = this.getReplacedResponseValidationProperties(connectorMessage);
        String[] successfulACKCodes = StringUtils.split((String)responseValidationProperties.getSuccessfulACKCode(), (char)',');
        String[] errorACKCodes = StringUtils.split((String)responseValidationProperties.getErrorACKCode(), (char)',');
        String[] rejectedACKCodes = StringUtils.split((String)responseValidationProperties.getRejectedACKCode(), (char)',');
        boolean validateMessageControlId = responseValidationProperties.isValidateMessageControlId();
        String responseData = response.getMessage();
        if (StringUtils.isNotBlank((CharSequence)responseData)) {
            try {
                if (responseData.trim().startsWith("<")) {
                    boolean error;
                    DocumentBuilderFactory dbf = HL7v2ResponseValidator.getSecureDocumentBuilderFactory();
                    Document doc = dbf.newDocumentBuilder().parse(new InputSource(new CharArrayReader(responseData.toCharArray())));
                    String ackCode = XPathFactory.newInstance().newXPath().compile("//MSA.1/text()").evaluate(doc).trim();
                    boolean rejected = Arrays.asList(rejectedACKCodes).contains(ackCode);
                    boolean bl = error = rejected || Arrays.asList(errorACKCodes).contains(ackCode);
                    if (error || rejected) {
                        String msa3 = StringUtils.trim((String)XPathFactory.newInstance().newXPath().compile("//MSA.3/text()").evaluate(doc));
                        String err1 = StringUtils.trim((String)XPathFactory.newInstance().newXPath().compile("//ERR.1/text()").evaluate(doc));
                        this.handleNACK(response, rejected, msa3, err1);
                    } else if (Arrays.asList(successfulACKCodes).contains(ackCode)) {
                        if (validateMessageControlId) {
                            String originalControlID;
                            String msa2 = StringUtils.trim((String)XPathFactory.newInstance().newXPath().compile("//MSA.2/text()").evaluate(doc));
                            if (!StringUtils.equals((CharSequence)msa2, (CharSequence)(originalControlID = this.getOriginalControlId(connectorMessage)))) {
                                this.handleInvalidControlId(response, originalControlID, msa2);
                            } else {
                                response.setStatus(Status.SENT);
                            }
                        } else {
                            response.setStatus(Status.SENT);
                        }
                    }
                } else {
                    if (this.serializationProperties.isConvertLineBreaks()) {
                        responseData = StringUtil.convertLineBreaks((String)responseData, (String)this.serializationSegmentDelimiter);
                    }
                    int index = -1;
                    boolean valid = true;
                    index = responseData.indexOf(this.serializationSegmentDelimiter + "MSA");
                    if (index >= 0) {
                        if ((index += this.serializationSegmentDelimiter.length() + 4) < responseData.length()) {
                            boolean rejected = this.startsWithAny(responseData, rejectedACKCodes, index);
                            boolean error = rejected || this.startsWithAny(responseData, errorACKCodes, index);
                            char fieldSeparator = responseData.charAt(index - 1);
                            if (error || rejected) {
                                String tempSegment;
                                String msa3 = null;
                                String err1 = null;
                                if ((index = responseData.indexOf(fieldSeparator, index)) >= 0 && (index = responseData.indexOf(fieldSeparator, index + 1)) >= 0) {
                                    tempSegment = StringUtils.substring((String)responseData, (int)(index + 1));
                                    msa3 = (index = StringUtils.indexOfAny((CharSequence)tempSegment, (String)(fieldSeparator + this.serializationSegmentDelimiter))) >= 0 ? StringUtils.substring((String)tempSegment, (int)0, (int)index) : StringUtils.substring((String)tempSegment, (int)0);
                                }
                                if ((index = responseData.indexOf(this.serializationSegmentDelimiter + "ERR")) >= 0) {
                                    index += this.serializationSegmentDelimiter.length() + 4;
                                    tempSegment = StringUtils.substring((String)responseData, (int)index);
                                    err1 = (index = StringUtils.indexOfAny((CharSequence)tempSegment, (String)(fieldSeparator + this.serializationSegmentDelimiter))) >= 0 ? StringUtils.substring((String)tempSegment, (int)0, (int)index) : StringUtils.substring((String)tempSegment, (int)0);
                                }
                                this.handleNACK(response, rejected, msa3, err1);
                            } else if (this.startsWithAny(responseData, successfulACKCodes, index)) {
                                if (validateMessageControlId) {
                                    String originalControlID;
                                    String msa2 = "";
                                    if ((index = responseData.indexOf(fieldSeparator, index)) >= 0) {
                                        String tempSegment = StringUtils.substring((String)responseData, (int)(index + 1));
                                        msa2 = (index = StringUtils.indexOfAny((CharSequence)tempSegment, (String)(fieldSeparator + this.serializationSegmentDelimiter))) >= 0 ? StringUtils.substring((String)tempSegment, (int)0, (int)index) : StringUtils.substring((String)tempSegment, (int)0);
                                    }
                                    if (!StringUtils.equals((CharSequence)msa2, (CharSequence)(originalControlID = this.getOriginalControlId(connectorMessage)))) {
                                        this.handleInvalidControlId(response, originalControlID, msa2);
                                    } else {
                                        response.setStatus(Status.SENT);
                                    }
                                } else {
                                    response.setStatus(Status.SENT);
                                }
                            } else {
                                valid = false;
                            }
                        } else {
                            valid = false;
                        }
                    } else {
                        valid = false;
                    }
                    if (!valid) {
                        response.setStatus(Status.QUEUED);
                        response.setStatusMessage("Invalid HL7 v2.x acknowledgement received.");
                        response.setError(response.getStatusMessage());
                    }
                }
            }
            catch (Exception e) {
                response.setStatus(Status.QUEUED);
                response.setStatusMessage("Error validating response: " + e.getMessage());
                response.setError(ErrorMessageBuilder.buildErrorMessage((String)this.getClass().getSimpleName(), (String)response.getStatusMessage(), (Throwable)e));
            }
        } else {
            response.setStatus(Status.QUEUED);
            response.setStatusMessage("Empty or blank response received.");
            response.setError(response.getStatusMessage());
        }
        return response;
    }

    private boolean startsWithAny(String str, String[] prefixes, int toffset) {
        for (String prefix : prefixes) {
            if (!str.startsWith(prefix, toffset)) continue;
            return true;
        }
        return false;
    }

    private String getOriginalControlId(ConnectorMessage connectorMessage) throws Exception {
        String controlId = "";
        String originalMessage = "";
        if (this.responseValidationProperties.getOriginalMessageControlId().equals((Object)HL7v2ResponseValidationProperties.OriginalMessageControlId.Destination_Encoded)) {
            originalMessage = connectorMessage.getEncoded().getContent();
        } else if (this.responseValidationProperties.getOriginalMessageControlId().equals((Object)HL7v2ResponseValidationProperties.OriginalMessageControlId.Map_Variable)) {
            String originalIdMapVariable = this.responseValidationProperties.getOriginalIdMapVariable();
            if (StringUtils.isEmpty((CharSequence)originalIdMapVariable)) {
                throw new Exception("Map variable for original control Id not set.");
            }
            Object value = null;
            value = connectorMessage.getConnectorMap().containsKey(originalIdMapVariable) ? (Object)connectorMessage.getConnectorMap().get(originalIdMapVariable) : (Object)connectorMessage.getChannelMap().get(originalIdMapVariable);
            if (value == null) {
                throw new Exception("Map variable for original control Id not set.");
            }
            controlId = value.toString();
            return controlId;
        }
        if (originalMessage.startsWith("<")) {
            DocumentBuilderFactory dbf = HL7v2ResponseValidator.getSecureDocumentBuilderFactory();
            Document doc = dbf.newDocumentBuilder().parse(new InputSource(new CharArrayReader(originalMessage.toCharArray())));
            controlId = XPathFactory.newInstance().newXPath().compile("//MSH.10.1/text()").evaluate(doc).trim();
        } else {
            int index = originalMessage.indexOf("MSH");
            if (index >= 0) {
                char fieldSeparator = originalMessage.charAt((index += 4) - 1);
                int segmentDelimeterIndex = originalMessage.indexOf(this.serializationSegmentDelimiter, index);
                for (int iteration = 2; iteration < MESSAGE_CONTROL_ID_FIELD; ++iteration) {
                    index = originalMessage.indexOf(fieldSeparator, index + 1);
                    if ((segmentDelimeterIndex < 0 || segmentDelimeterIndex >= index) && index != -1) continue;
                    return "";
                }
                String tempSegment = StringUtils.substring((String)originalMessage, (int)(index + 1));
                controlId = (index = StringUtils.indexOfAny((CharSequence)tempSegment, (String)(fieldSeparator + this.serializationSegmentDelimiter))) >= 0 ? StringUtils.substring((String)tempSegment, (int)0, (int)index) : StringUtils.substring((String)tempSegment, (int)0);
            }
        }
        return controlId;
    }

    private HL7v2ResponseValidationProperties getReplacedResponseValidationProperties(ConnectorMessage connectorMessage) {
        HL7v2ResponseValidationProperties props = new HL7v2ResponseValidationProperties(this.responseValidationProperties);
        props.setSuccessfulACKCode(this.replacer.replaceValues(props.getSuccessfulACKCode(), connectorMessage));
        props.setErrorACKCode(this.replacer.replaceValues(props.getErrorACKCode(), connectorMessage));
        props.setRejectedACKCode(this.replacer.replaceValues(props.getRejectedACKCode(), connectorMessage));
        return props;
    }

    private void handleNACK(Response response, boolean rejected, String msa3, String err1) {
        response.setStatus(Status.ERROR);
        StringBuilder nackMessage = new StringBuilder("NACK sent from receiver. (");
        nackMessage.append(rejected ? "Rejected)" : "Error)");
        if (StringUtils.isNotEmpty((CharSequence)msa3)) {
            nackMessage.append('\n');
            nackMessage.append(msa3);
        }
        if (StringUtils.isNotEmpty((CharSequence)err1)) {
            nackMessage.append('\n');
            nackMessage.append(err1);
        }
        response.setStatusMessage(nackMessage.toString());
        nackMessage.append("\n\n");
        nackMessage.append(response.getMessage());
        response.setError(nackMessage.toString());
    }

    private void handleInvalidControlId(Response response, String originalControlID, String msa2) {
        response.setStatus(Status.ERROR);
        String statusMessage = "Message control Ids do not match.";
        response.setStatusMessage(statusMessage);
        response.setError(statusMessage + "\nExpected: " + originalControlID + "\nActual: " + msa2);
    }

    private static DocumentBuilderFactory getSecureDocumentBuilderFactory() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return dbf;
    }
}

