/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.hl7v2;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.model.datatype.DataTypePropertyDescriptor;
import com.mirth.connect.model.datatype.PropertyEditorType;
import com.mirth.connect.model.datatype.SerializationProperties;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class HL7v2SerializationProperties
extends SerializationProperties {
    private boolean handleRepetitions = true;
    private boolean handleSubcomponents = true;
    private boolean useStrictParser = false;
    private boolean useStrictValidation = false;
    private boolean stripNamespaces = false;
    private String segmentDelimiter = "\\r";
    private boolean convertLineBreaks = true;

    public Map<String, DataTypePropertyDescriptor> getPropertyDescriptors() {
        LinkedHashMap<String, DataTypePropertyDescriptor> properties = new LinkedHashMap<String, DataTypePropertyDescriptor>();
        properties.put("handleRepetitions", new DataTypePropertyDescriptor((Object)this.handleRepetitions, "Parse Field Repetitions", "Parse field repetitions (applies to Non-Strict Parser only).", PropertyEditorType.BOOLEAN));
        properties.put("handleSubcomponents", new DataTypePropertyDescriptor((Object)this.handleSubcomponents, "Parse Subcomponents", "Parse subcomponents (applies to Non-Strict Parser only).", PropertyEditorType.BOOLEAN));
        properties.put("useStrictParser", new DataTypePropertyDescriptor((Object)this.useStrictParser, "Use Strict Parser", "Parse messages based upon strict HL7 specifications.", PropertyEditorType.BOOLEAN));
        properties.put("useStrictValidation", new DataTypePropertyDescriptor((Object)this.useStrictValidation, "Validate in Strict Parser", "Validate messages using HL7 specifications (applies to Strict Parser only).", PropertyEditorType.BOOLEAN));
        properties.put("stripNamespaces", new DataTypePropertyDescriptor((Object)this.stripNamespaces, "Strip Namespaces", "Strips namespace definitions from the transformed XML message (applies to Strict Parser only).", PropertyEditorType.BOOLEAN));
        properties.put("segmentDelimiter", new DataTypePropertyDescriptor((Object)this.segmentDelimiter, "Segment Delimiter", "This is the input delimiter character(s) expected to occur after each segment.", PropertyEditorType.STRING));
        properties.put("convertLineBreaks", new DataTypePropertyDescriptor((Object)this.convertLineBreaks, "Convert Line Breaks", "Convert all styles of line breaks (CRLF, CR, LF) in the raw message to the segment delimiter. ", PropertyEditorType.BOOLEAN));
        return properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties != null) {
            if (properties.get("handleRepetitions") != null) {
                this.handleRepetitions = (Boolean)properties.get("handleRepetitions");
            }
            if (properties.get("handleSubcomponents") != null) {
                this.handleSubcomponents = (Boolean)properties.get("handleSubcomponents");
            }
            if (properties.get("useStrictParser") != null) {
                this.useStrictParser = (Boolean)properties.get("useStrictParser");
            }
            if (properties.get("useStrictValidation") != null) {
                this.useStrictValidation = (Boolean)properties.get("useStrictValidation");
            }
            if (properties.get("stripNamespaces") != null) {
                this.stripNamespaces = (Boolean)properties.get("stripNamespaces");
            }
            if (properties.get("segmentDelimiter") != null) {
                this.segmentDelimiter = (String)properties.get("segmentDelimiter");
            }
            if (properties.get("convertLineBreaks") != null) {
                this.convertLineBreaks = (Boolean)properties.get("convertLineBreaks");
            }
        }
    }

    public boolean isHandleRepetitions() {
        return this.handleRepetitions;
    }

    public void setHandleRepetitions(boolean handleRepetitions) {
        this.handleRepetitions = handleRepetitions;
    }

    public boolean isHandleSubcomponents() {
        return this.handleSubcomponents;
    }

    public void setHandleSubcomponents(boolean handleSubcomponents) {
        this.handleSubcomponents = handleSubcomponents;
    }

    public boolean isUseStrictParser() {
        return this.useStrictParser;
    }

    public void setUseStrictParser(boolean useStrictParser) {
        this.useStrictParser = useStrictParser;
    }

    public boolean isUseStrictValidation() {
        return this.useStrictValidation;
    }

    public void setUseStrictValidation(boolean useStrictValidation) {
        this.useStrictValidation = useStrictValidation;
    }

    public boolean isStripNamespaces() {
        return this.stripNamespaces;
    }

    public void setStripNamespaces(boolean stripNamespaces) {
        this.stripNamespaces = stripNamespaces;
    }

    public String getSegmentDelimiter() {
        return this.segmentDelimiter;
    }

    public void setSegmentDelimiter(String segmentDelimiter) {
        this.segmentDelimiter = segmentDelimiter;
    }

    public boolean isConvertLineBreaks() {
        return this.convertLineBreaks;
    }

    public void setConvertLineBreaks(boolean convertLineBreaks) {
        this.convertLineBreaks = convertLineBreaks;
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("handleRepetitions", this.handleRepetitions);
        purgedProperties.put("handleSubcomponents", this.handleSubcomponents);
        purgedProperties.put("useStrictParser", this.useStrictParser);
        purgedProperties.put("stripNamespaces", this.stripNamespaces);
        purgedProperties.put("convertLineBreaks", this.convertLineBreaks);
        return purgedProperties;
    }
}

