/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.beans.VisualContainerBean;
import com.install4j.api.context.ControlButtonType;
import com.install4j.api.context.WizardIndex;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.api.styles.Style;
import com.install4j.runtime.beans.styles.StyleContextImpl;
import com.install4j.runtime.beans.styles.StyleManagerImpl;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.IndexPanel;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import com.install4j.runtime.wizard.WizardBase;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ScreenEnvelope
extends WizardScreen
implements ActionCallback {
    private WizardScreenExecutor wizard;
    private Screen screen;
    private String styleId;
    private Style style;
    private JPanel contentComponent;
    private ScreenBeanConfig config;
    private FormPanel formPanel;
    private EnumMap<ControlButtonType, Boolean> controlButtonEnabledStates = new EnumMap(ControlButtonType.class);
    private Map<FormComponent, Boolean> formComponentToEnabledStatus = new HashMap<FormComponent, Boolean>();
    private boolean actionsRunning;
    private IndexPanel indexPanel;

    public ScreenEnvelope(WizardScreenExecutor wizard, Screen screen, String styleId, ScreenBeanConfig config) {
        super(wizard);
        this.wizard = wizard;
        this.screen = screen;
        this.styleId = styleId;
        this.config = config;
        this.init();
    }

    protected ScreenEnvelope(Screen screen, String styleId) {
        super((WizardBase)null);
        this.screen = screen;
        this.styleId = styleId;
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    protected void init() {
        for (ControlButtonType controlButtonType : ControlButtonType.values()) {
            this.controlButtonEnabledStates.put(controlButtonType, true);
        }
        this.initStyle();
        this.initFormPanel();
        this.initScreen();
        if (!this.screen.isCreateLazily()) {
            this.initContentComponent();
        }
    }

    private void initStyle() {
        Style style = this.style = this.styleId != null ? this.getStyleManager().cloneStyleById(this.styleId) : this.getStyleManager().getStyleById(this.styleId);
        if (this.style == null) {
            throw new IllegalStateException("No style with ID " + this.styleId + " could be found");
        }
    }

    protected void initFormPanel() {
        if (this.screen instanceof FormPanelContainer) {
            this.formPanel = this.createFormPanel();
            ((FormPanelContainer)((Object)this.screen)).setFormPanel(this.formPanel, this.formPanel.getFormEnvironment());
        }
    }

    protected FormPanel createFormPanel() {
        return new FormPanel(this.config.getFormComponentConfigs(), this.wizard.getContext(), this.screen, this, null);
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void formComponentEnabledChanged(FormComponent formComponent, boolean enabled) {
        if (this.actionsRunning) {
            this.formComponentToEnabledStatus.put(formComponent, enabled);
        }
    }

    @Override
    public void actionsStarted() {
        ArrayList<FormComponent> disabledComponents = new ArrayList<FormComponent>();
        if (this.formPanel != null) {
            FormComponent[] formComponents;
            for (FormComponent formComponent : formComponents = this.formPanel.getFormEnvironment().getFormComponents()) {
                if (!formComponent.hasUserInput()) continue;
                this.formComponentToEnabledStatus.put(formComponent, formComponent.isEnabled());
                disabledComponents.add(formComponent);
            }
        }
        SwingUtilities.invokeLater(() -> {
            this.style.setControlButtonEnabled(ControlButtonType.NEXT, false);
            this.style.setControlButtonEnabled(ControlButtonType.PREVIOUS, false);
            for (FormComponent disabledComponent : disabledComponents) {
                disabledComponent.setEnabled(false);
            }
            this.actionsRunning = true;
        });
    }

    @Override
    public void actionsFinished() {
        SwingUtilities.invokeLater(() -> {
            this.actionsRunning = false;
            for (ControlButtonType controlButtonType : ControlButtonType.values()) {
                this.style.setControlButtonEnabled(controlButtonType, this.controlButtonEnabledStates.get((Object)controlButtonType));
            }
            if (this.formPanel != null) {
                for (Map.Entry entry : this.formComponentToEnabledStatus.entrySet()) {
                    ((FormComponent)entry.getKey()).setEnabled((Boolean)entry.getValue());
                }
                this.formComponentToEnabledStatus.clear();
            }
        });
    }

    @Override
    public void activate() {
        this.initializeLazilyLoaded();
        this.applyConfiguredWizardIndex();
        ContextImpl context = this.wizard.getContext();
        context.runBooleanScript(this.config.getPreActivationClassName(), this.screen, this.createScriptParameters());
        this.fillScreen();
        this.screen.willActivate();
        this.activateWizardIndex();
        if (this.formPanel != null) {
            this.formPanel.willActivate();
        }
        StyleManagerImpl styleManager = this.getStyleManager();
        styleManager.willActivate(this.style);
        super.activate();
        this.setControlButtonVisible(ControlButtonType.PREVIOUS, this.screen.isPreviousVisible());
        this.setControlButtonVisible(ControlButtonType.NEXT, this.screen.isNextVisible() || this.isFinishScreen());
        this.setControlButtonVisible(ControlButtonType.CANCEL, this.isCancelVisible());
        if (this.isFinishScreen()) {
            this.setControlButtonText(ControlButtonType.NEXT, Messages.getString(".ButtonFinish"));
        }
        styleManager.activated(this.style);
        this.screen.activated();
        if (this.formPanel != null) {
            this.formPanel.activated();
        }
        this.style.activated();
        context.runBooleanScript(this.config.getPostActivationClassName(), this.screen, this.createScriptParameters());
    }

    public void initializeLazilyLoaded() {
        if (this.contentComponent == null) {
            this.initContentComponent();
        }
    }

    private void applyConfiguredWizardIndex() {
        int wizardIndexChangeType = this.config.getWizardIndexChangeType();
        switch (wizardIndexChangeType) {
            case 4: {
                this.wizard.setWizardIndex(null);
                break;
            }
            case 3: {
                this.wizard.setWizardIndexKey(this.config.getWizardIndexKey());
                break;
            }
            case 2: {
                this.wizard.setWizardIndex(this.config.getWizardIndex());
            }
        }
    }

    public void activateWizardIndex() {
        String wizardIndexKey = this.wizard.getWizardIndexKey();
        WizardIndex wizardIndex = this.wizard.getWizardIndex();
        this.setIndexPanel(wizardIndex == null || wizardIndexKey == null ? null : new IndexPanel(wizardIndex, wizardIndexKey));
        this.wizard.cacheWizardIndexAndKey(this.screen);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.screen.deactivated();
        if (this.formPanel != null) {
            this.formPanel.deactivated();
        }
        this.style.deactivated();
    }

    public void setControlButtonEnabled(ControlButtonType controlButtonType, boolean enabled) {
        this.style.setControlButtonEnabled(controlButtonType, enabled);
        this.controlButtonEnabledStates.put(controlButtonType, enabled);
    }

    public void setControlButtonVisible(ControlButtonType controlButtonType, boolean visible) {
        this.style.setControlButtonVisible(controlButtonType, visible);
    }

    public void pressControlButton(ControlButtonType controlButtonType) {
        switch (controlButtonType) {
            case NEXT: {
                this.doNext();
                break;
            }
            case PREVIOUS: {
                this.doPrevious();
                break;
            }
            case CANCEL: {
                this.doCancel();
                break;
            }
            default: {
                throw new IllegalArgumentException(controlButtonType.name());
            }
        }
    }

    public void focusControlButton(ControlButtonType controlButtonType) {
        this.style.focusControlButton(controlButtonType);
    }

    public void setControlButtonText(ControlButtonType controlButtonType, String text) {
        this.style.setControlButtonText(controlButtonType, text);
    }

    void doCancel() {
        if (this.screen.cancel()) {
            this.cancelWizard();
        }
    }

    void doNext() {
        if (this.screen.next() && this.checkFormCompleted()) {
            ControllerCommand storedCommand;
            boolean validated;
            this.wizard.getCommandSink().startStoreCommand();
            try {
                validated = this.wizard.getContext().runBooleanScript(this.config.getValidationClassName(), this.screen, this.createScriptParameters());
            }
            finally {
                storedCommand = this.wizard.getCommandSink().finishStoreCommand();
            }
            if (storedCommand != null) {
                this.wizard.getCommandSink().returnToController(storedCommand);
            } else if (validated) {
                if (this.isFinishScreen()) {
                    this.screen.deactivated();
                    this.wizard.getCommandSink().returnToController(new FinishCommand(this));
                } else {
                    this.wizard.getCommandSink().returnToController(new GoForwardCommand(1, true, true, (ActionCallback)this));
                }
            }
        }
    }

    private Object[] createScriptParameters() {
        Object[] scriptParameters = this.formPanel != null ? new Object[]{this.formPanel.getFormEnvironment()} : null;
        return scriptParameters;
    }

    void doPrevious() {
        if (this.screen.previous()) {
            if (this.formPanel != null) {
                this.formPanel.previous();
            }
            this.wizard.getCommandSink().returnToController(new GoBackCommand(1, true));
        }
    }

    protected void cancelWizard() {
        this.wizard.cancel();
    }

    private boolean checkFormCompleted() {
        return this.formPanel == null || this.formPanel.checkCompleted();
    }

    public boolean isFinishScreen() {
        return this.config == null || this.config.isFinishScreen();
    }

    public boolean isCancelVisible() {
        return this.screen.isCancelVisible() && !this.isFinishScreen();
    }

    @Override
    protected boolean supportsPrevious() {
        return !this.screen.isHidden() && !this.screen.isHiddenForPrevious();
    }

    @Override
    protected boolean supportsNext() {
        return !this.screen.isHidden() && !this.screen.isHiddenForNext();
    }

    @Override
    protected void setupComponent() {
        super.setupComponent();
        if (this.config != null) {
            this.setName(this.config.getDisplayedId());
        }
    }

    private void initContentComponent() {
        if (this.contentComponent == null) {
            this.contentComponent = new JPanel(new GridBagLayout());
            this.contentComponent.add((Component)this.screen.createComponent(), this.getConstraints(this.screen));
            GUIHelper.makeTransparent(this.contentComponent);
        }
    }

    private GridBagConstraints getConstraints(VisualContainerBean visualContainerBean) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = this.screen.getAnchor().getValue();
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.fill = visualContainerBean.isFillHorizontal() && visualContainerBean.isFillVertical() ? 1 : (visualContainerBean.isFillHorizontal() ? 2 : (visualContainerBean.isFillVertical() ? 3 : 0));
        return gc;
    }

    private void setStyleContext() {
        Container parent = this.contentComponent.getParent();
        if (parent != null) {
            parent.remove(this.contentComponent);
        }
        this.style.setStyleContext(new StyleContextImpl(this.contentComponent, this.screen.getTitle(), this.screen.getSubTitle()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillScreen() {
        this.initializeLazilyLoaded();
        StyleManagerImpl styleManager = this.getStyleManager();
        styleManager.setTopLevelStyle(this.style);
        try {
            this.setStyleContext();
            JComponent styleComponent = this.style.createComponent();
            this.removeAll();
            JPanel stylePanel = new JPanel(new GridBagLayout());
            stylePanel.setOpaque(false);
            stylePanel.add((Component)styleComponent, this.getConstraints(this.style));
            this.add((Component)stylePanel, "Center");
        }
        finally {
            styleManager.setTopLevelStyle(null);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.formPanel != null && SwingUtilities.getWindowAncestor(this.formPanel) == null) {
            SwingUtilities.updateComponentTreeUI(this.formPanel);
        }
        if (this.contentComponent != null) {
            SwingUtilities.updateComponentTreeUI(this.contentComponent);
        }
    }

    public boolean isCancelButtonEnabled() {
        return this.controlButtonEnabledStates.get((Object)ControlButtonType.CANCEL);
    }

    public void disarmButtons() {
        this.disarmButtons(this);
    }

    private void disarmButtons(JComponent container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                ButtonModel model = button.getModel();
                model.setArmed(false);
                model.setPressed(false);
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            this.disarmButtons((JComponent)component);
        }
    }

    private void setIndexPanel(IndexPanel indexPanel) {
        int componentCount = this.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof IndexPanel)) continue;
            this.remove(component);
            break;
        }
        if (this.indexPanel != null) {
            this.remove(indexPanel);
        }
        if (indexPanel != null) {
            this.add((Component)indexPanel, "Before");
            this.indexPanel = indexPanel;
            this.revalidate();
        }
    }

    public StyleManagerImpl getStyleManager() {
        return StyleManagerImpl.getInstance();
    }
}

