/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.globalmapviewer;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.plugins.globalmapviewer.GlobalMapController;
import com.mirth.connect.plugins.globalmapviewer.GlobalMapServletInterface;
import com.mirth.connect.server.api.CheckAuthorizedChannelId;
import com.mirth.connect.server.api.MirthServlet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

public class GlobalMapServlet
extends MirthServlet
implements GlobalMapServletInterface {
    private static final GlobalMapController globalMapController = GlobalMapController.getInstance();

    public GlobalMapServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, "Global Maps");
    }

    public Map<String, Map<String, Map<String, String>>> getAllMaps(Set<String> channelIds, boolean includeGlobalMap) throws ClientException {
        try {
            return globalMapController.getAllMaps(channelIds, includeGlobalMap);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public Map<String, Map<String, Map<String, String>>> getAllMapsPost(Set<String> channelIds, boolean includeGlobalMap) throws ClientException {
        return this.getAllMaps(channelIds, includeGlobalMap);
    }

    public Map<String, String> getGlobalMap() throws ClientException {
        try {
            return globalMapController.getGlobalMap();
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public Map<String, String> getGlobalChannelMap(String channelId) throws ClientException {
        try {
            return globalMapController.getGlobalChannelMap(channelId);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }
}

