/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.javascriptrule;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.editors.EditorPanel;
import com.mirth.connect.model.Rule;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.plugins.javascriptrule.JavaScriptRule;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import net.miginfocom.swing.MigLayout;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptPanel
extends EditorPanel<Rule> {
    private MirthRTextScrollPane scriptTextArea;

    public JavaScriptPanel() {
        this.initComponents();
        this.initLayout();
    }

    public Rule getDefaults() {
        return new JavaScriptRule();
    }

    public Rule getProperties() {
        JavaScriptRule props = new JavaScriptRule();
        props.setScript(this.scriptTextArea.getText().trim());
        return props;
    }

    public void setProperties(Rule properties) {
        JavaScriptRule props = (JavaScriptRule)properties;
        this.scriptTextArea.setText(props.getScript());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkProperties(Rule properties, boolean highlight) {
        JavaScriptRule props = (JavaScriptRule)properties;
        try {
            Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
            context.compileString("function rhinoWrapper() {" + props.getScript() + "\n}", PlatformUI.MIRTH_FRAME.mirthClient.getGuid(), 1, null);
        }
        catch (EvaluatorException e) {
            String string = "Error on line " + e.lineNumber() + ": " + e.getMessage() + ".";
            return string;
        }
        catch (Exception e) {
            String string = "Unknown error occurred during validation.";
            return string;
        }
        finally {
            Context.exit();
        }
        return null;
    }

    public void resetInvalidProperties() {
    }

    public void setNameActionListener(ActionListener actionListener) {
    }

    public void setContextType(ContextType contextType) {
        this.scriptTextArea.setContextType(contextType);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.scriptTextArea = new MirthRTextScrollPane(null, true);
        this.scriptTextArea.setBorder(BorderFactory.createEtchedBorder());
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        this.add((Component)this.scriptTextArea, "grow, push");
    }
}

