/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KRenderedImageCodecLib;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class J2KImageReaderCodecLib
extends ImageReader {
    private ImageInputStream iis = null;
    private boolean gotHeader = false;
    private int width;
    private int height;
    private J2KMetadata imageMetadata = null;
    J2KRenderedImageCodecLib image;

    public void processImageUpdateWrapper(BufferedImage theImage, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        this.processImageUpdate(theImage, minX, minY, width, height, periodX, periodY, bands);
    }

    public void processImageProgressWrapper(float percentageDone) {
        this.processImageProgress(percentageDone);
    }

    public J2KImageReaderCodecLib(ImageReaderSpi originator) {
        super(originator);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.ignoreMetadata = ignoreMetadata;
        this.iis = (ImageInputStream)input;
        this.imageMetadata = null;
    }

    public ImageReadParam getDefaultReadParam() {
        return new J2KImageReadParam();
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        if (this.image != null) {
            ArrayList<ImageTypeSpecifier> list = new ArrayList<ImageTypeSpecifier>();
            list.add(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
            return list.iterator();
        }
        return null;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.width;
    }

    public int getTileGridXOffset(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.image.getTileGridXOffset();
    }

    public int getTileGridYOffset(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.image.getTileGridYOffset();
    }

    public int getTileWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.image.getTileWidth();
    }

    public int getTileHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.image.getTileHeight();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        if (this.ignoreMetadata) {
            return null;
        }
        if (this.imageMetadata == null) {
            if (this.image == null) {
                this.image = new J2KRenderedImageCodecLib(this.iis, this, null);
            }
            this.imageMetadata = this.image.readImageMetadata();
        }
        return this.imageMetadata;
    }

    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return true;
    }

    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        this.checkReadParam(param);
        this.clearAbortRequest();
        this.processImageStarted(0);
        this.image = new J2KRenderedImageCodecLib(this.iis, this, (J2KImageReadParam)param);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.image;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        WritableRaster raster;
        this.checkIndex(imageIndex);
        this.clearAbortRequest();
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        this.checkReadParam(param);
        this.processImageStarted(imageIndex);
        BufferedImage bi = param.getDestination();
        this.image = new J2KRenderedImageCodecLib(this.iis, this, (J2KImageReadParam)param);
        Point offset = param.getDestinationOffset();
        if (bi == null) {
            ColorModel colorModel = this.image.getColorModel();
            SampleModel sampleModel = this.image.getSampleModel();
            ImageTypeSpecifier type = param.getDestinationType();
            if (type != null) {
                colorModel = type.getColorModel();
            }
            raster = Raster.createWritableRaster(sampleModel.createCompatibleSampleModel(this.image.getMinX() + this.image.getWidth(), this.image.getMinY() + this.image.getHeight()), new Point(0, 0));
            bi = new BufferedImage(colorModel, raster, colorModel != null ? colorModel.isAlphaPremultiplied() : false, new Hashtable());
        } else {
            raster = bi.getWritableTile(0, 0);
        }
        this.image.setDestImage(bi);
        this.image.readAsRaster(raster);
        this.image.clearDestImage();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bi;
    }

    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        BufferedImage bi = this.read(imageIndex, param);
        return bi.getWritableTile(0, 0);
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.height;
    }

    public void readHeader() throws IOException {
        if (this.gotHeader) {
            return;
        }
        if (this.image == null) {
            this.image = new J2KRenderedImageCodecLib(this.iis, this, null);
        }
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IllegalArgumentException(I18N.getString("J2KImageReader4"));
        }
    }

    private void checkReadParam(ImageReadParam param) {
        if (!(param instanceof J2KImageReadParam)) {
            throw new IllegalArgumentException(I18N.getString("J2KImageReader5"));
        }
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }
}

