/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFJPEGDecompressor
extends TIFFDecompressor {
    protected ImageReader JPEGReader;
    protected ImageReadParam JPEGParam;
    protected byte[] tables = null;

    public void beginDecoding() {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName("jpeg");
        if (!iter.hasNext()) {
            throw new IllegalStateException("No JPEG readers found!");
        }
        this.JPEGReader = iter.next();
        if (!this.JPEGReader.getClass().getName().startsWith("com.sun.imageio")) {
            while (iter.hasNext()) {
                ImageReader nextReader = iter.next();
                if (!nextReader.getClass().getName().startsWith("com.sun.imageio")) continue;
                this.JPEGReader = nextReader;
            }
        }
        this.JPEGParam = this.JPEGReader.getDefaultReadParam();
        TIFFImageMetadata tmetadata = (TIFFImageMetadata)this.metadata;
        TIFFField f = tmetadata.getTIFFField(347);
        if (f != null) {
            this.tables = f.getAsBytes();
        }
    }

    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        byte[] buf;
        int bufOffset = 0;
        if (this.tables != null) {
            bufOffset = this.tables.length;
            buf = new byte[bufOffset + this.byteCount];
            System.arraycopy(this.tables, 0, buf, 0, this.tables.length);
        } else {
            buf = new byte[this.byteCount];
        }
        this.stream.seek(this.offset);
        this.stream.readFully(buf, bufOffset, this.byteCount);
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        MemoryCacheImageInputStream is = new MemoryCacheImageInputStream(bais);
        this.JPEGReader.setInput(is, true, true);
        this.JPEGParam.setDestination(this.rawImage);
        this.JPEGReader.read(0, this.JPEGParam);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.JPEGReader.dispose();
    }
}

