/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.transmission.TransmissionModeProperties;
import com.mirth.connect.model.transmission.framemode.FrameModeProperties;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class TcpDispatcherProperties
extends ConnectorProperties
implements DestinationConnectorPropertiesInterface {
    private DestinationConnectorProperties destinationConnectorProperties;
    public static final String PROTOCOL = "TCP";
    public static final String NAME = "TCP Sender";
    private TransmissionModeProperties transmissionModeProperties;
    private boolean serverMode;
    private String remoteAddress;
    private String remotePort;
    private boolean overrideLocalBinding;
    private String localAddress;
    private String localPort;
    private String sendTimeout;
    private String bufferSize;
    private String maxConnections;
    private boolean keepConnectionOpen;
    private boolean checkRemoteHost;
    private String responseTimeout;
    private boolean ignoreResponse;
    private boolean queueOnResponseTimeout;
    private boolean dataTypeBinary;
    private String charsetEncoding;
    private String template;

    public TcpDispatcherProperties() {
        this.destinationConnectorProperties = new DestinationConnectorProperties(true);
        FrameModeProperties frameModeProperties = new FrameModeProperties("MLLP");
        frameModeProperties.setStartOfMessageBytes("0B");
        frameModeProperties.setEndOfMessageBytes("1C0D");
        this.transmissionModeProperties = frameModeProperties;
        this.serverMode = false;
        this.remoteAddress = "127.0.0.1";
        this.remotePort = "6660";
        this.overrideLocalBinding = false;
        this.localAddress = "0.0.0.0";
        this.localPort = "0";
        this.sendTimeout = "5000";
        this.bufferSize = "65536";
        this.maxConnections = "10";
        this.keepConnectionOpen = false;
        this.checkRemoteHost = false;
        this.responseTimeout = "5000";
        this.ignoreResponse = false;
        this.queueOnResponseTimeout = true;
        this.dataTypeBinary = false;
        this.charsetEncoding = "DEFAULT_ENCODING";
        this.template = "${message.encodedData}";
    }

    public TcpDispatcherProperties(TcpDispatcherProperties props) {
        super((ConnectorProperties)props);
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
        this.transmissionModeProperties = props.getTransmissionModeProperties();
        this.serverMode = props.isServerMode();
        this.remoteAddress = props.getRemoteAddress();
        this.remotePort = props.getRemotePort();
        this.overrideLocalBinding = props.isOverrideLocalBinding();
        this.localAddress = props.getLocalAddress();
        this.localPort = props.getLocalPort();
        this.sendTimeout = props.getSendTimeout();
        this.bufferSize = props.getBufferSize();
        this.keepConnectionOpen = props.isKeepConnectionOpen();
        this.checkRemoteHost = props.isCheckRemoteHost();
        this.responseTimeout = props.getResponseTimeout();
        this.ignoreResponse = props.isIgnoreResponse();
        this.queueOnResponseTimeout = props.isQueueOnResponseTimeout();
        this.dataTypeBinary = props.isDataTypeBinary();
        this.charsetEncoding = props.getCharsetEncoding();
        this.template = props.getTemplate();
    }

    public TransmissionModeProperties getTransmissionModeProperties() {
        return this.transmissionModeProperties;
    }

    public void setTransmissionModeProperties(TransmissionModeProperties transmissionModeProperties) {
        this.transmissionModeProperties = transmissionModeProperties;
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public void setServerMode(boolean serverMode) {
        this.serverMode = serverMode;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(String remotePort) {
        this.remotePort = remotePort;
    }

    public boolean isOverrideLocalBinding() {
        return this.overrideLocalBinding;
    }

    public void setOverrideLocalBinding(boolean overrideLocalBinding) {
        this.overrideLocalBinding = overrideLocalBinding;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(String localPort) {
        this.localPort = localPort;
    }

    public String getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(String sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(String maxConnections) {
        this.maxConnections = maxConnections;
    }

    public boolean isKeepConnectionOpen() {
        return this.keepConnectionOpen;
    }

    public void setKeepConnectionOpen(boolean keepConnectionOpen) {
        this.keepConnectionOpen = keepConnectionOpen;
    }

    public boolean isCheckRemoteHost() {
        return this.checkRemoteHost;
    }

    public void setCheckRemoteHost(boolean checkRemoteHost) {
        this.checkRemoteHost = checkRemoteHost;
    }

    public String getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(String responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public boolean isIgnoreResponse() {
        return this.ignoreResponse;
    }

    public void setIgnoreResponse(boolean ignoreResponse) {
        this.ignoreResponse = ignoreResponse;
    }

    public boolean isQueueOnResponseTimeout() {
        return this.queueOnResponseTimeout;
    }

    public void setQueueOnResponseTimeout(boolean queueOnResponseTimeout) {
        this.queueOnResponseTimeout = queueOnResponseTimeout;
    }

    public boolean isDataTypeBinary() {
        return this.dataTypeBinary;
    }

    public void setDataTypeBinary(boolean dataTypeBinary) {
        this.dataTypeBinary = dataTypeBinary;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charsetEncoding = charsetEncoding;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public String getName() {
        return NAME;
    }

    public String toFormattedString() {
        StringBuilder builder = new StringBuilder();
        String newLine = "\n";
        builder.append("REMOTE ADDRESS: ");
        builder.append(this.remoteAddress + ":" + this.remotePort);
        builder.append(newLine);
        if (this.overrideLocalBinding) {
            builder.append("LOCAL ADDRESS: ");
            builder.append(this.localAddress + ":" + this.localPort);
            builder.append(newLine);
        }
        builder.append(newLine);
        builder.append("[CONTENT]");
        builder.append(newLine);
        builder.append(this.template);
        return builder.toString();
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public void setDestinationConnectorProperties(DestinationConnectorProperties destinationConnectorProperties) {
        this.destinationConnectorProperties = destinationConnectorProperties;
    }

    public ConnectorProperties clone() {
        return new TcpDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return true;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
        super.migrate3_1_0(element);
        element.addChildElementIfNotExists("checkRemoteHost", "true");
        DonkeyElement processHL7ACKElement = element.removeChild("processHL7ACK");
        DonkeyElement destinationPropertiesElement = element.getChildElement("destinationConnectorProperties");
        if (processHL7ACKElement != null && destinationPropertiesElement != null) {
            destinationPropertiesElement.addChildElement("validateResponse", processHL7ACKElement.getTextContent());
        }
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        Map purgedProperties = super.getPurgedProperties();
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        purgedProperties.put("transmissionModeProperties", this.transmissionModeProperties.getPurgedProperties());
        purgedProperties.put("serverMode", this.serverMode);
        purgedProperties.put("overrideLocalBinding", this.overrideLocalBinding);
        purgedProperties.put("sendTimeout", PurgeUtil.getNumericValue((String)this.sendTimeout));
        purgedProperties.put("bufferSize", PurgeUtil.getNumericValue((String)this.bufferSize));
        purgedProperties.put("maxConnections", PurgeUtil.getNumericValue((String)this.maxConnections));
        purgedProperties.put("keepConnectionOpen", this.keepConnectionOpen);
        purgedProperties.put("checkRemoteHost", this.checkRemoteHost);
        purgedProperties.put("responseTimeout", PurgeUtil.getNumericValue((String)this.responseTimeout));
        purgedProperties.put("ignoreResponse", this.ignoreResponse);
        purgedProperties.put("queueOnResponseTimeout", this.queueOnResponseTimeout);
        purgedProperties.put("charsetEncoding", this.charsetEncoding);
        purgedProperties.put("templateLines", PurgeUtil.countLines((String)this.template));
        return purgedProperties;
    }
}

