/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.directoryresource;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.ResourcePropertiesPanel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthTextPane;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.plugins.directoryresource.DirectoryResourceProperties;
import com.mirth.connect.plugins.directoryresource.DirectoryResourceServletInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class DirectoryResourcePropertiesPanel
extends ResourcePropertiesPanel {
    private JLabel directoryLabel;
    private JTextField directoryField;
    private JCheckBox includeSubdirectoriesCheckBox;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScrollPane;
    private JTextPane descriptionTextPane;
    private JLabel libraryLabel;
    private MirthTable libraryTable;
    private JScrollPane libraryScrollPane;

    public DirectoryResourcePropertiesPanel() {
        this.initComponents();
        this.initLayout();
    }

    public void fillProperties(ResourceProperties properties) {
        DirectoryResourceProperties props = (DirectoryResourceProperties)properties;
        props.setDirectory(this.directoryField.getText());
        props.setDirectoryRecursion(this.includeSubdirectoriesCheckBox.isSelected());
        props.setDescription(this.descriptionTextPane.getText());
    }

    public void setProperties(ResourceProperties properties) {
        final DirectoryResourceProperties props = (DirectoryResourceProperties)properties;
        this.directoryField.setText(props.getDirectory());
        this.includeSubdirectoriesCheckBox.setSelected(props.isDirectoryRecursion());
        this.descriptionTextPane.setText(props.getDescription());
        final String workingId = PlatformUI.MIRTH_FRAME.startWorking("Loading libraries...");
        SwingWorker<List<String>, Void> worker = new SwingWorker<List<String>, Void>(){

            @Override
            public List<String> doInBackground() throws ClientException {
                return ((DirectoryResourceServletInterface)PlatformUI.MIRTH_FRAME.mirthClient.getServlet(DirectoryResourceServletInterface.class)).getLibraries(props.getId());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done() {
                try {
                    ArrayList libraries = (ArrayList)this.get();
                    if (libraries == null) {
                        libraries = new ArrayList();
                    }
                    Object[][] data = new Object[libraries.size()][1];
                    int i = 0;
                    for (String library : libraries) {
                        data[i++][0] = library;
                    }
                    ((RefreshTableModel)DirectoryResourcePropertiesPanel.this.libraryTable.getModel()).refreshDataVector(data);
                }
                catch (Throwable t) {
                    if (t instanceof ExecutionException) {
                        t = t.getCause();
                    }
                    PlatformUI.MIRTH_FRAME.alertThrowable((Component)PlatformUI.MIRTH_FRAME, t, "Error loading libraries: " + t.toString());
                }
                finally {
                    PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                }
            }
        };
        worker.execute();
    }

    public ResourceProperties getDefaults() {
        return new DirectoryResourceProperties();
    }

    public String checkProperties() {
        StringBuilder errors = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.directoryField.getText())) {
            this.directoryField.setBackground(UIConstants.INVALID_COLOR);
            errors.append("Directory cannot be blank.\n");
        } else if (this.directoryField.getText().trim().equals("/") || this.directoryField.getText().trim().equals("server-lib")) {
            this.directoryField.setBackground(UIConstants.INVALID_COLOR);
            errors.append("Directory cannot be equal to \"" + this.directoryField.getText().trim() + "\".\n");
        }
        return errors.toString();
    }

    public void resetInvalidProperties() {
        this.directoryField.setBackground(null);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Directory Settings", 0, 0, new Font("Tahoma", 1, 11)));
        this.directoryLabel = new JLabel("Directory:");
        this.directoryField = new MirthTextField();
        this.directoryField.setToolTipText("The directory to load libraries from.");
        this.includeSubdirectoriesCheckBox = new MirthCheckBox("Include All Subdirectories");
        this.includeSubdirectoriesCheckBox.setBackground(this.getBackground());
        this.includeSubdirectoriesCheckBox.setToolTipText("<html>Select Yes to traverse directories recursively and search for files in each one.</html>");
        this.descriptionLabel = new JLabel("Description:");
        this.descriptionTextPane = new MirthTextPane();
        this.descriptionScrollPane = new JScrollPane(this.descriptionTextPane);
        this.libraryLabel = new JLabel("Loaded Libraries:");
        this.libraryTable = new MirthTable();
        this.libraryTable.setModel((TableModel)new RefreshTableModel(new Object[]{"Library"}, 0));
        this.libraryTable.setDragEnabled(false);
        this.libraryTable.setRowSelectionAllowed(false);
        this.libraryTable.setRowHeight(20);
        this.libraryTable.setFocusable(false);
        this.libraryTable.setOpaque(true);
        this.libraryTable.getTableHeader().setReorderingAllowed(false);
        this.libraryTable.setEditable(false);
        this.libraryTable.setSortable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.libraryTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.libraryScrollPane = new JScrollPane((Component)this.libraryTable);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 5, novisualpadding, hidemode 3, fill"));
        this.add(this.directoryLabel, "right");
        this.add(this.directoryField, "w 300!, split");
        this.add(this.includeSubdirectoriesCheckBox);
        this.add(this.descriptionLabel, "newline, top, right");
        this.add(this.descriptionScrollPane, "grow, sx, push, h 50%");
        this.add(this.libraryLabel, "newline, top, right");
        this.add(this.libraryScrollPane, "grow, sx, push, h 50%");
    }
}

