/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.httpauth.javascript;

import com.mirth.connect.client.ui.FunctionList;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptHttpAuthDialog
extends MirthDialog {
    private boolean saved;
    private MirthRTextScrollPane scriptPane;
    private FunctionList functionList;
    private JSeparator separator;
    private JButton validateScriptButton;
    private JButton okButton;
    private JButton cancelButton;

    public JavaScriptHttpAuthDialog(Frame owner, String script) {
        super((Window)owner, true);
        this.initComponents(script);
        this.initLayout();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public boolean wasSaved() {
        return this.saved;
    }

    public String getScript() {
        return this.scriptPane.getText();
    }

    private void initComponents(String script) {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.setTitle("HTTP Authentication Script");
        this.setPreferredSize(new Dimension(750, 500));
        this.scriptPane = new MirthRTextScrollPane(ContextType.SOURCE_RECEIVER, true);
        this.scriptPane.setSaveEnabled(false);
        this.scriptPane.setCaretPosition(0);
        this.scriptPane.setText(script);
        this.functionList = new FunctionList(ContextType.SOURCE_RECEIVER);
        this.separator = new JSeparator();
        this.validateScriptButton = new JButton("Validate Script");
        this.validateScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptHttpAuthDialog.this.validateScript(true);
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (JavaScriptHttpAuthDialog.this.validateScript(false)) {
                    JavaScriptHttpAuthDialog.this.saved = true;
                    JavaScriptHttpAuthDialog.this.dispose();
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptHttpAuthDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 8, novisualpadding, hidemode 3, gap 6, fill"));
        this.add((Component)this.scriptPane, "grow, push");
        this.add((Component)this.functionList, "growy, w 200!");
        this.add(this.separator, "newline, growx, sx");
        this.add(this.validateScriptButton, "newline, sx, right, split 3");
        this.add(this.okButton);
        this.add(this.cancelButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateScript(boolean alertOnSuccess) {
        boolean success = false;
        StringBuilder sb = new StringBuilder();
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            context.compileString("function rhinoWrapper() {" + this.scriptPane.getText() + "\n}", UUID.randomUUID().toString(), 1, null);
            sb.append("JavaScript was successfully validated.");
            success = true;
        }
        catch (EvaluatorException e) {
            sb.append("Error on line " + e.lineNumber() + ": " + e.getMessage() + " of the current script.");
        }
        catch (Exception e) {
            sb.append("Unknown error occurred during validation.");
        }
        finally {
            Context.exit();
        }
        if (!success || alertOnSuccess) {
            PlatformUI.MIRTH_FRAME.alertInformation((Component)((Object)this), sb.toString());
        }
        return success;
    }
}

