/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.connectors.jms.JmsConnectorProperties;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/connectors/jms")
@Tag(name="Connector Services")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface JmsConnectorServletInterface
extends BaseServletInterface {
    public static final String PLUGIN_POINT = "JMS Connector Service";

    @GET
    @Path(value="/templates")
    @Operation(summary="Retrieves JMS connector settings templates.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="jms_connector_properties_map", ref="../apiexamples/jms_connector_properties_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="jms_connector_properties_map", ref="../apiexamples/jms_connector_properties_map_json")})})
    @MirthOperation(name="getTemplates", display="Get JMS Templates", type=Operation.ExecuteType.ASYNC, auditable=false)
    public LinkedHashMap<String, JmsConnectorProperties> getTemplates() throws ClientException;

    @GET
    @Path(value="/templates/{templateName}")
    @Operation(summary="Retrieves a single JMS connector settings template.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="jms_connector_properties", ref="../apiexamples/jms_connector_properties_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="jms_connector_properties", ref="../apiexamples/jms_connector_properties_json")})})
    @MirthOperation(name="getTemplate", display="Get JMS Template", type=Operation.ExecuteType.ASYNC, auditable=false)
    public JmsConnectorProperties getTemplate(@Param(value="templateName") @Parameter(description="The name of the template.", required=true) @PathParam(value="templateName") String var1) throws ClientException;

    @PUT
    @Path(value="/templates/{templateName}")
    @Operation(summary="Creates or updates a JMS connector settings template.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="jms_template_name_set", ref="../apiexamples/jms_template_name_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="jms_template_name_set", ref="../apiexamples/jms_template_name_set_json")})})
    @MirthOperation(name="saveTemplate", display="Save JMS Template", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Set<String> saveTemplate(@Param(value="templateName") @Parameter(description="The name of the template.", required=true) @PathParam(value="templateName") String var1, @Param(value="properties") @RequestBody(description="The JMS connector properties to save.", required=true, content={@Content(mediaType="application/xml", examples={@ExampleObject(name="jms_connector_properties", ref="../apiexamples/jms_connector_properties_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="jms_connector_properties", ref="../apiexamples/jms_connector_properties_json")})}) JmsConnectorProperties var2) throws ClientException;

    @DELETE
    @Path(value="/templates/{templateName}")
    @Operation(summary="Creates or updates a JMS connector settings template.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="jms_template_name_set", ref="../apiexamples/jms_template_name_set_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="jms_template_name_set", ref="../apiexamples/jms_template_name_set_json")})})
    @MirthOperation(name="saveTemplate", display="Save JMS Template", type=Operation.ExecuteType.ASYNC, auditable=false)
    public Set<String> deleteTemplate(@Param(value="templateName") @Parameter(description="The name of the template.", required=true) @PathParam(value="templateName") String var1) throws ClientException;
}

