/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.connectors.jms.JmsConnectorProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import java.util.Map;

public class JmsDispatcherProperties
extends JmsConnectorProperties
implements DestinationConnectorPropertiesInterface {
    private static final String NAME = "JMS Sender";
    private static final String PROTOCOL = "JMS";
    private String template;
    private DestinationConnectorProperties destinationConnectorProperties;

    public JmsDispatcherProperties() {
        this.template = "${message.encodedData}";
        this.destinationConnectorProperties = new DestinationConnectorProperties();
    }

    public JmsDispatcherProperties(JmsDispatcherProperties props) {
        super(props);
        this.template = props.getTemplate();
        this.destinationConnectorProperties = new DestinationConnectorProperties(props.getDestinationConnectorProperties());
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toFormattedString() {
        return super.toFormattedString() + "\n[CONTENT]\n" + this.template;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public DestinationConnectorProperties getDestinationConnectorProperties() {
        return this.destinationConnectorProperties;
    }

    public ConnectorProperties clone() {
        return new JmsDispatcherProperties(this);
    }

    public boolean canValidateResponse() {
        return false;
    }

    @Override
    public Map<String, Object> getPurgedProperties() {
        Map<String, Object> purgedProperties = super.getPurgedProperties();
        purgedProperties.put("templateLines", PurgeUtil.countLines((String)this.template));
        purgedProperties.put("destinationConnectorProperties", this.destinationConnectorProperties.getPurgedProperties());
        return purgedProperties;
    }
}

