/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.connectors.http.BinaryContentTypeResolver;
import com.mirth.connect.connectors.http.DefaultHttpConfiguration;
import com.mirth.connect.connectors.http.HttpConfiguration;
import com.mirth.connect.connectors.http.HttpMessageConverter;
import com.mirth.connect.connectors.http.HttpReceiverProperties;
import com.mirth.connect.connectors.http.HttpRequestMessage;
import com.mirth.connect.connectors.http.HttpStaticResource;
import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageSource;
import com.mirth.connect.donkey.server.message.batch.ResponseHandler;
import com.mirth.connect.donkey.server.message.batch.SimpleResponseHandler;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.plugins.httpauth.AuthenticationResult;
import com.mirth.connect.plugins.httpauth.AuthenticatorProvider;
import com.mirth.connect.plugins.httpauth.AuthenticatorProviderFactory;
import com.mirth.connect.plugins.httpauth.HttpAuthConnectorPluginProperties;
import com.mirth.connect.plugins.httpauth.RequestInfo;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.ResourceUtil;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.userutil.MessageHeaders;
import com.mirth.connect.userutil.MessageParameters;
import com.mirth.connect.util.CharsetUtils;
import com.mirth.connect.util.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.security.Constraint;

public class HttpReceiver
extends SourceConnector
implements BinaryContentTypeResolver {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private final TemplateValueReplacer replacer = new TemplateValueReplacer();
    private HttpConfiguration configuration = null;
    private Server server;
    private String host;
    private int port;
    private int timeout;
    private String[] binaryMimeTypesArray;
    private Pattern binaryMimeTypesRegex;
    private HttpAuthConnectorPluginProperties authProps;
    private AuthenticatorProvider authenticatorProvider;

    public void onDeploy() throws ConnectorTaskException {
        if (this.getConnectorProperties().isXmlBody() && this.isProcessBatch()) {
            throw new ConnectorTaskException("Batch processing is not supported for Xml Body.");
        }
        String configurationClass = this.getConfigurationClass();
        try {
            this.configuration = (HttpConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Exception e) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultHttpConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        String replacedBinaryMimeTypes = this.replacer.replaceValues(this.getConnectorProperties().getBinaryMimeTypes(), this.getChannelId(), this.getChannel().getName());
        if (this.getConnectorProperties().isBinaryMimeTypesRegex()) {
            try {
                this.binaryMimeTypesRegex = Pattern.compile(replacedBinaryMimeTypes);
            }
            catch (PatternSyntaxException e) {
                throw new ConnectorTaskException("Invalid binary MIME types regular expression: " + replacedBinaryMimeTypes, (Throwable)e);
            }
        } else {
            this.binaryMimeTypesArray = StringUtils.split((String)replacedBinaryMimeTypes.replaceAll("\\s*,\\s*", ",").trim(), (char)',');
        }
        if (this.getConnectorProperties().getPluginProperties() != null) {
            for (ConnectorPluginProperties pluginProperties : this.getConnectorProperties().getPluginProperties()) {
                if (!(pluginProperties instanceof HttpAuthConnectorPluginProperties)) continue;
                this.authProps = (HttpAuthConnectorPluginProperties)pluginProperties;
            }
        }
        if (this.authProps != null && this.authProps.getAuthType() != HttpAuthConnectorPluginProperties.AuthType.NONE) {
            try {
                this.authenticatorProvider = AuthenticatorProviderFactory.getAuthenticatorProvider((Connector)this, (HttpAuthConnectorPluginProperties)this.authProps);
            }
            catch (Exception e) {
                throw new ConnectorTaskException("Error creating authenticator provider.", (Throwable)e);
            }
        }
    }

    public void onUndeploy() throws ConnectorTaskException {
        if (this.authenticatorProvider != null) {
            this.authenticatorProvider.shutdown();
        }
        this.configuration.configureConnectorUndeploy((Connector)this);
    }

    public void onStart() throws ConnectorTaskException {
        String channelId = this.getChannelId();
        String channelName = this.getChannel().getName();
        this.host = this.replacer.replaceValues(this.getConnectorProperties().getListenerConnectorProperties().getHost(), channelId, channelName);
        this.port = NumberUtils.toInt((String)this.replacer.replaceValues(this.getConnectorProperties().getListenerConnectorProperties().getPort(), channelId, channelName));
        this.timeout = NumberUtils.toInt((String)this.replacer.replaceValues(this.getConnectorProperties().getTimeout(), channelId, channelName), (int)0);
        Object contextPath = (this.getConnectorProperties().getContextPath() == null ? "" : this.replacer.replaceValues(this.getConnectorProperties().getContextPath(), channelId, channelName)).trim();
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        if (((String)contextPath).endsWith("/")) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
        }
        try {
            HandlerCollection handlers;
            this.server = new Server();
            this.configuration.configureReceiver(this);
            HandlerCollection serverHandler = handlers = new HandlerCollection();
            if (this.getConnectorProperties().getStaticResources() != null) {
                TreeMap<Object, ArrayList<HttpStaticResource>> staticResourcesMap = new TreeMap<Object, ArrayList<HttpStaticResource>>();
                for (HttpStaticResource staticResource : this.getConnectorProperties().getStaticResources()) {
                    ArrayList<HttpStaticResource> staticResourcesList;
                    Object resourceContextPath = this.replacer.replaceValues(staticResource.getContextPath(), channelId, channelName);
                    HashMap<String, ArrayList<String>> queryParameters = new HashMap<String, ArrayList<String>>();
                    int queryIndex = ((String)resourceContextPath).indexOf(63);
                    if (queryIndex >= 0) {
                        String query = ((String)resourceContextPath).substring(queryIndex + 1);
                        resourceContextPath = ((String)resourceContextPath).substring(0, queryIndex);
                        for (NameValuePair param : URLEncodedUtils.parse((String)query, (Charset)Charset.defaultCharset())) {
                            ArrayList<String> currentValue = (ArrayList<String>)queryParameters.get(param.getName());
                            String value = StringUtils.defaultString((String)param.getValue());
                            if (currentValue == null) {
                                currentValue = new ArrayList<String>();
                                queryParameters.put(param.getName(), currentValue);
                            }
                            currentValue.add(value);
                        }
                    }
                    if (((String)resourceContextPath).endsWith("/")) {
                        resourceContextPath = ((String)resourceContextPath).substring(0, ((String)resourceContextPath).length() - 1);
                    }
                    if (!((String)resourceContextPath).startsWith("/")) {
                        resourceContextPath = "/" + (String)resourceContextPath;
                    }
                    if ((staticResourcesList = (ArrayList<HttpStaticResource>)staticResourcesMap.get(resourceContextPath = (String)contextPath + (String)resourceContextPath)) == null) {
                        staticResourcesList = new ArrayList<HttpStaticResource>();
                        staticResourcesMap.put(resourceContextPath, staticResourcesList);
                    }
                    staticResourcesList.add(new HttpStaticResource((String)resourceContextPath, staticResource.getResourceType(), staticResource.getValue(), staticResource.getContentType(), queryParameters));
                }
                for (List staticResourcesList : staticResourcesMap.descendingMap().values()) {
                    for (HttpStaticResource staticResource : staticResourcesList) {
                        this.logger.debug("Adding static resource handler for context path: " + staticResource.getContextPath());
                        ContextHandler resourceContextHandler = new ContextHandler();
                        resourceContextHandler.setContextPath(staticResource.getContextPath());
                        resourceContextHandler.setAllowNullPathInfo(true);
                        resourceContextHandler.setHandler((Handler)new StaticResourceHandler(staticResource));
                        handlers.addHandler((Handler)resourceContextHandler);
                    }
                }
            }
            ContextHandler contextHandler = new ContextHandler();
            contextHandler.setContextPath((String)contextPath);
            contextHandler.setHandler((Handler)new RequestHandler());
            handlers.addHandler((Handler)contextHandler);
            if (this.authenticatorProvider != null) {
                serverHandler = this.createSecurityHandler((Handler)handlers);
            }
            this.server.setHandler((Handler)serverHandler);
            this.logger.debug("starting HTTP server with address: " + this.host + ":" + this.port);
            this.server.start();
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
        }
        catch (Exception e) {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.FAILURE));
            throw new ConnectorTaskException("Failed to start HTTP Listener", (Throwable)e);
        }
    }

    public void onStop() throws ConnectorTaskException {
        ConnectorTaskException firstCause = null;
        if (this.server != null) {
            try {
                this.logger.debug("stopping HTTP server");
                this.server.stop();
            }
            catch (Exception e) {
                firstCause = new ConnectorTaskException("Failed to stop HTTP Listener", e.getCause());
            }
        }
        if (firstCause != null) {
            throw firstCause;
        }
    }

    public void onHalt() throws ConnectorTaskException {
        this.onStop();
    }

    protected String getConfigurationClass() {
        return this.configurationController.getProperty(this.getConnectorProperties().getProtocol(), "httpConfigurationClass");
    }

    protected void sendResponse(Request baseRequest, HttpServletResponse servletResponse, DispatchResult dispatchResult) throws Exception {
        ContentType contentType = ContentType.parse((String)this.replaceValues(this.getConnectorProperties().getResponseContentType(), dispatchResult));
        if (!this.getConnectorProperties().isResponseDataTypeBinary() && contentType.getCharset() == null) {
            contentType = ContentType.parse((String)(contentType.toString() + "; charset=" + CharsetUtils.getEncoding((String)this.getConnectorProperties().getCharset())));
        }
        Map<String, List<String>> responseHeaders = this.getHeaders(dispatchResult);
        this.sendResponse(baseRequest, servletResponse, dispatchResult, contentType, responseHeaders, null);
    }

    Map<String, List<String>> getHeaders(DispatchResult dispatchResult) {
        Map<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        if (this.getConnectorProperties().isUseHeadersVariable()) {
            responseHeaders = HttpUtil.getTableMap((String)this.getConnectorProperties().getResponseHeadersVariable(), (MessageMaps)this.channel.getMessageMaps(), (ConnectorMessage)dispatchResult.getProcessedMessage().getMergedConnectorMessage());
        } else {
            for (Map.Entry entry : this.getConnectorProperties().getResponseHeadersMap().entrySet()) {
                String replacedKey = this.replaceValues((String)entry.getKey(), dispatchResult);
                for (String headerValue : (List)entry.getValue()) {
                    List<String> list = responseHeaders.get(replacedKey);
                    if (list == null) {
                        list = new ArrayList<String>();
                        responseHeaders.put(replacedKey, list);
                    }
                    list.add(this.replaceValues(headerValue, dispatchResult));
                }
            }
        }
        return responseHeaders;
    }

    protected void sendResponse(Request baseRequest, HttpServletResponse servletResponse, DispatchResult dispatchResult, ContentType contentType, Map<String, List<String>> responseHeaders, byte[] responseBytes) throws Exception {
        servletResponse.setContentType(contentType.toString());
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            for (String headerValue : entry.getValue()) {
                servletResponse.addHeader(entry.getKey(), headerValue);
            }
        }
        int statusCode = NumberUtils.toInt((String)this.replaceValues(this.getConnectorProperties().getResponseStatusCode(), dispatchResult), (int)-1);
        if (dispatchResult != null && dispatchResult.getSelectedResponse() != null) {
            dispatchResult.setAttemptedResponse(true);
            Response selectedResponse = dispatchResult.getSelectedResponse();
            Status newMessageStatus = selectedResponse.getStatus();
            if (statusCode != -1) {
                servletResponse.setStatus(statusCode);
            } else if (newMessageStatus != null && newMessageStatus.equals((Object)Status.ERROR)) {
                servletResponse.setStatus(500);
            } else {
                servletResponse.setStatus(200);
            }
            String message = selectedResponse.getMessage();
            if (message != null || responseBytes != null) {
                ServletOutputStream responseOutputStream = servletResponse.getOutputStream();
                if (responseBytes == null) {
                    responseBytes = this.getConnectorProperties().isResponseDataTypeBinary() ? Base64Util.decodeBase64((byte[])message.getBytes("US-ASCII")) : message.getBytes(CharsetUtils.getEncoding((String)this.getConnectorProperties().getCharset()));
                }
                boolean gzipResponse = false;
                Enumeration en = baseRequest.getHeaders("Accept-Encoding");
                while (en.hasMoreElements()) {
                    String acceptEncoding = (String)en.nextElement();
                    if (acceptEncoding == null || !acceptEncoding.contains("gzip")) continue;
                    gzipResponse = true;
                    break;
                }
                if (gzipResponse) {
                    servletResponse.setHeader("Content-Encoding", "gzip");
                    GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)responseOutputStream);
                    gzipOutputStream.write(responseBytes);
                    gzipOutputStream.finish();
                } else {
                    responseOutputStream.write(responseBytes);
                }
            }
        } else if (statusCode != -1) {
            servletResponse.setStatus(statusCode);
        } else {
            servletResponse.setStatus(200);
        }
    }

    protected void sendErrorResponse(Request baseRequest, HttpServletResponse servletResponse, DispatchResult dispatchResult, Throwable t) throws IOException {
        String responseError = ExceptionUtils.getRootCauseMessage((Throwable)t);
        this.logger.error("Error receiving message (" + this.getConnectorProperties().getName() + " \"Source\" on channel " + this.getChannelId() + ").", t);
        this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), dispatchResult == null ? null : Long.valueOf(dispatchResult.getMessageId()), ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.getConnectorProperties().getName(), "Error receiving message", t));
        if (dispatchResult != null) {
            dispatchResult.setAttemptedResponse(true);
            dispatchResult.setResponseError(responseError);
            if (dispatchResult.getSelectedResponse() != null) {
                dispatchResult.getSelectedResponse().setMessage(responseError);
            }
        }
        servletResponse.setContentType("text/plain");
        servletResponse.setStatus(500);
        servletResponse.getOutputStream().write(responseError.getBytes());
    }

    protected Object getMessage(Request request, Map<String, Object> sourceMap, List<Attachment> attachments) throws IOException, ChannelException, MessagingException, DonkeyElement.DonkeyElementException, ParserConfigurationException {
        HttpRequestMessage requestMessage = this.createRequestMessage(request, false);
        Object rawMessageContent = this.getConnectorProperties().isXmlBody() ? HttpMessageConverter.httpRequestToXml(requestMessage, this.getConnectorProperties().isParseMultipart(), this.getConnectorProperties().isIncludeMetadata(), this) : requestMessage.getContent();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.RECEIVING));
        this.populateSourceMap(request, requestMessage, sourceMap);
        return rawMessageContent;
    }

    protected HttpRequestMessage createRequestMessage(Request request, boolean ignorePayload) throws IOException, MessagingException {
        return this.createRequestMessage(request, ignorePayload, this.shouldParseMultipart(this.getConnectorProperties(), request));
    }

    protected boolean shouldParseMultipart(HttpReceiverProperties connectorProperties, Request request) {
        return connectorProperties.isXmlBody() && connectorProperties.isParseMultipart() && ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    protected HttpRequestMessage createRequestMessage(Request request, boolean ignorePayload, boolean parseMultipart) throws IOException, MessagingException {
        ContentType contentType;
        HttpRequestMessage requestMessage = new HttpRequestMessage();
        requestMessage.setMethod(request.getMethod());
        requestMessage.setHeaders(HttpMessageConverter.convertFieldEnumerationToMap((HttpServletRequest)request));
        requestMessage.setParameters(this.extractParameters(request));
        try {
            contentType = ContentType.parse((String)request.getContentType());
        }
        catch (RuntimeException e) {
            contentType = ContentType.TEXT_PLAIN;
        }
        requestMessage.setContentType(contentType);
        requestMessage.setRemoteAddress(StringUtils.trimToEmpty((String)request.getRemoteAddr()));
        requestMessage.setQueryString(StringUtils.trimToEmpty((String)request.getQueryString()));
        requestMessage.setRequestUrl(StringUtils.trimToEmpty((String)this.getRequestURL(request)));
        requestMessage.setContextPath(StringUtils.trimToEmpty((String)new URL(requestMessage.getRequestUrl()).getPath()));
        if (!ignorePayload) {
            Object requestInputStream = request.getInputStream();
            try {
                byte[] entity = (byte[])request.getAttribute("Cached Entity");
                if (entity != null) {
                    requestInputStream = new ByteArrayInputStream(entity);
                }
            }
            catch (Exception entity) {
                // empty catch block
            }
            List<String> contentEncodingList = requestMessage.getCaseInsensitiveHeaders().get("Content-Encoding");
            if (CollectionUtils.isNotEmpty(contentEncodingList)) {
                for (String contentEncoding : contentEncodingList) {
                    if (contentEncoding == null || !contentEncoding.equalsIgnoreCase("gzip") && !contentEncoding.equalsIgnoreCase("x-gzip")) continue;
                    requestInputStream = new GZIPInputStream((InputStream)requestInputStream);
                    break;
                }
            }
            if (parseMultipart) {
                requestMessage.setContent(new MimeMultipart((DataSource)new ByteArrayDataSource((InputStream)requestInputStream, contentType.toString())));
            } else if (this.isBinaryContentType(contentType)) {
                requestMessage.setContent(IOUtils.toByteArray((InputStream)requestInputStream));
            } else {
                requestMessage.setContent(IOUtils.toString((InputStream)requestInputStream, (String)HttpMessageConverter.getDefaultHttpCharset(request.getCharacterEncoding())));
            }
        }
        return requestMessage;
    }

    protected void populateSourceMap(Request request, HttpRequestMessage requestMessage, Map<String, Object> sourceMap) {
        sourceMap.put("remoteAddress", requestMessage.getRemoteAddress());
        sourceMap.put("remotePort", request.getRemotePort());
        sourceMap.put("localAddress", StringUtils.trimToEmpty((String)request.getLocalAddr()));
        sourceMap.put("localPort", request.getLocalPort());
        sourceMap.put("method", requestMessage.getMethod());
        sourceMap.put("url", requestMessage.getRequestUrl());
        HttpURI uri = request.getHttpURI();
        sourceMap.put("uri", StringUtils.trimToEmpty((String)(uri.isAbsolute() ? uri.toString() : uri.getPathQuery())));
        sourceMap.put("protocol", StringUtils.trimToEmpty((String)request.getProtocol()));
        sourceMap.put("query", requestMessage.getQueryString());
        sourceMap.put("contextPath", requestMessage.getContextPath());
        sourceMap.put("headers", new MessageHeaders(requestMessage.getCaseInsensitiveHeaders()));
        sourceMap.put("parameters", new MessageParameters(requestMessage.getParameters()));
        sourceMap.putAll(this.configuration.getRequestInformation((ServletRequest)request));
    }

    protected String replaceValues(String template, DispatchResult dispatchResult) {
        ConnectorMessage mergedConnectorMessage = null;
        if (dispatchResult != null && dispatchResult.getProcessedMessage() != null) {
            mergedConnectorMessage = dispatchResult.getProcessedMessage().getMergedConnectorMessage();
        }
        return mergedConnectorMessage == null ? this.replacer.replaceValues(template, this.getChannelId(), this.getChannel().getName()) : this.replacer.replaceValues(template, mergedConnectorMessage);
    }

    public void handleRecoveredResponse(DispatchResult dispatchResult) {
        this.finishDispatch(dispatchResult);
    }

    public Server getServer() {
        return this.server;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected Map<String, List<String>> extractParameters(Request request) {
        HashMap<String, List<String>> parameterMap = new HashMap<String, List<String>>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            ArrayList<String> list = (ArrayList<String>)parameterMap.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<String>();
                parameterMap.put((String)entry.getKey(), list);
            }
            list.addAll(Arrays.asList((String[])entry.getValue()));
        }
        return parameterMap;
    }

    protected boolean parametersEqual(Map<String, List<String>> params1, Map<String, List<String>> params2) {
        if (!params1.keySet().equals(params2.keySet())) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : params1.entrySet()) {
            if (ListUtils.isEqualList((Collection)entry.getValue(), (Collection)params2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    protected String getRequestURL(Request request) {
        String requestURL = request.getRequestURL().toString();
        try {
            new URL(requestURL);
        }
        catch (MalformedURLException e) {
            StringBuilder builder = new StringBuilder();
            String scheme = request.getScheme();
            int port = request.getServerPort();
            builder.append(scheme);
            builder.append("://");
            builder.append(request.getServerName());
            if (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443) {
                builder.append(':');
                builder.append(port);
            }
            requestURL = builder.toString();
        }
        return requestURL;
    }

    private ConstraintSecurityHandler createSecurityHandler(Handler handler) throws Exception {
        final com.mirth.connect.plugins.httpauth.Authenticator authenticator = this.authenticatorProvider.getAuthenticator();
        final String authMethod = switch (this.authProps.getAuthType()) {
            case HttpAuthConnectorPluginProperties.AuthType.BASIC -> "BASIC";
            case HttpAuthConnectorPluginProperties.AuthType.DIGEST -> "DIGEST";
            default -> "customauth";
        };
        Constraint constraint = new Constraint();
        constraint.setName(authMethod);
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setAuthenticator(new Authenticator(){

            public void setConfiguration(Authenticator.AuthConfiguration configuration) {
            }

            public String getAuthMethod() {
                return authMethod;
            }

            public void prepareRequest(ServletRequest request) {
            }

            public Authentication validateRequest(final ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
                HttpServletRequest request = (HttpServletRequest)req;
                HttpServletResponse response = (HttpServletResponse)res;
                String remoteAddress = StringUtils.trimToEmpty((String)request.getRemoteAddr());
                int remotePort = request.getRemotePort();
                String localAddress = StringUtils.trimToEmpty((String)request.getLocalAddr());
                int localPort = request.getLocalPort();
                String protocol = StringUtils.trimToEmpty((String)request.getProtocol());
                String method = StringUtils.trimToEmpty((String)request.getMethod());
                String requestURI = StringUtils.trimToEmpty((String)request.getRequestURI());
                Map<String, List<String>> headers = HttpMessageConverter.convertFieldEnumerationToMap(request);
                LinkedHashMap<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();
                for (Map.Entry entry : req.getParameterMap().entrySet()) {
                    queryParameters.put((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
                }
                RequestInfo.EntityProvider entityProvider = new RequestInfo.EntityProvider(){

                    public byte[] getEntity() throws IOException {
                        byte[] entity = (byte[])req.getAttribute("Cached Entity");
                        if (entity == null) {
                            entity = IOUtils.toByteArray((InputStream)req.getInputStream());
                            req.setAttribute("Cached Entity", (Object)entity);
                        }
                        return entity;
                    }
                };
                RequestInfo requestInfo = new RequestInfo(remoteAddress, remotePort, localAddress, localPort, protocol, method, requestURI, headers, queryParameters, entityProvider, HttpReceiver.this.configuration.getRequestInformation((ServletRequest)request));
                try {
                    AuthenticationResult result = authenticator.authenticate(requestInfo);
                    for (Map.Entry entry : result.getResponseHeaders().entrySet()) {
                        if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey())) || entry.getValue() == null) continue;
                        for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                            if (i == 0) {
                                response.setHeader((String)entry.getKey(), (String)((List)entry.getValue()).get(i));
                                continue;
                            }
                            response.addHeader((String)entry.getKey(), (String)((List)entry.getValue()).get(i));
                        }
                    }
                    switch (result.getStatus()) {
                        case CHALLENGED: {
                            response.sendError(401);
                            return Authentication.SEND_CONTINUE;
                        }
                        case SUCCESS: {
                            AbstractLoginService.UserPrincipal userPrincipal = new AbstractLoginService.UserPrincipal(StringUtils.trimToEmpty((String)result.getUsername()), null);
                            Subject subject = new Subject();
                            subject.getPrincipals().add((Principal)userPrincipal);
                            return new UserAuthentication(this.getAuthMethod(), (UserIdentity)new DefaultUserIdentity(subject, (Principal)userPrincipal, new String[]{"user"}));
                        }
                    }
                    response.sendError(401);
                    return Authentication.SEND_FAILURE;
                }
                catch (Throwable t) {
                    HttpReceiver.this.logger.error("Error in HTTP authentication for " + HttpReceiver.this.getConnectorProperties().getName() + " (" + HttpReceiver.this.getConnectorProperties().getName() + " \"Source\" on channel " + HttpReceiver.this.getChannelId() + ").", t);
                    HttpReceiver.this.eventController.dispatchEvent((Event)new ErrorEvent(HttpReceiver.this.getChannelId(), Integer.valueOf(HttpReceiver.this.getMetaDataId()), null, ErrorEventType.DESTINATION_CONNECTOR, "Source", HttpReceiver.this.getConnectorProperties().getName(), "Error in HTTP authentication for " + HttpReceiver.this.getConnectorProperties().getName(), t));
                    throw new ServerAuthException(t);
                }
            }

            public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
                return true;
            }
        });
        securityHandler.addConstraintMapping(constraintMapping);
        securityHandler.setHandler(handler);
        return securityHandler;
    }

    @Override
    public boolean isBinaryContentType(ContentType contentType) {
        String mimeType = contentType.getMimeType();
        if (this.getConnectorProperties().isBinaryMimeTypesRegex()) {
            return this.binaryMimeTypesRegex.matcher(mimeType).matches();
        }
        return StringUtils.startsWithAny((CharSequence)mimeType, (CharSequence[])this.binaryMimeTypesArray);
    }

    public HttpReceiverProperties getConnectorProperties() {
        return (HttpReceiverProperties)super.getConnectorProperties();
    }

    private class StaticResourceHandler
    extends AbstractHandler {
        private HttpStaticResource staticResource;

        public StaticResourceHandler(HttpStaticResource staticResource) {
            this.staticResource = staticResource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request baseRequest, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
            if (!baseRequest.getMethod().equalsIgnoreCase(HttpMethod.GET.asString())) {
                return;
            }
            String originalThreadName = Thread.currentThread().getName();
            try {
                Object responseOutputStream;
                block35: {
                    Charset charset;
                    String value;
                    block36: {
                        FileInputStream is;
                        block38: {
                            block37: {
                                String contextPath;
                                block34: {
                                    ContentType contentType;
                                    Thread.currentThread().setName("HTTP Receiver Thread on " + HttpReceiver.this.getChannel().getName() + " (" + HttpReceiver.this.getChannelId() + ") < " + originalThreadName);
                                    HttpRequestMessage requestMessage = HttpReceiver.this.createRequestMessage(baseRequest, true);
                                    contextPath = StringUtils.replaceChars((String)URLDecoder.decode(requestMessage.getContextPath(), "US-ASCII"), (char)'\\', (char)'/');
                                    while (contextPath.endsWith("/")) {
                                        contextPath = contextPath.substring(0, contextPath.length() - 1);
                                    }
                                    HttpReceiver.this.logger.debug("Received static resource request at: " + contextPath);
                                    HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                                    HttpReceiver.this.populateSourceMap(baseRequest, requestMessage, sourceMap);
                                    value = HttpReceiver.this.replacer.replaceValues(this.staticResource.getValue(), HttpReceiver.this.getChannelId(), sourceMap);
                                    String contentTypeString = HttpReceiver.this.replacer.replaceValues(this.staticResource.getContentType(), HttpReceiver.this.getChannelId(), sourceMap);
                                    if (this.staticResource.getResourceType() != HttpStaticResource.ResourceType.DIRECTORY && !this.staticResource.getContextPath().equalsIgnoreCase(contextPath)) {
                                        return;
                                    }
                                    if (!HttpReceiver.this.parametersEqual(this.staticResource.getQueryParameters(), requestMessage.getParameters())) {
                                        return;
                                    }
                                    try {
                                        contentType = ContentType.parse((String)contentTypeString);
                                    }
                                    catch (Exception e) {
                                        contentType = ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (String)CharsetUtils.getEncoding((String)HttpReceiver.this.getConnectorProperties().getCharset()));
                                    }
                                    charset = contentType.getCharset();
                                    if (charset == null) {
                                        charset = Charset.forName(CharsetUtils.getEncoding((String)HttpReceiver.this.getConnectorProperties().getCharset()));
                                    }
                                    servletResponse.setContentType(contentType.toString());
                                    servletResponse.setStatus(200);
                                    responseOutputStream = servletResponse.getOutputStream();
                                    List<String> acceptEncodingList = requestMessage.getCaseInsensitiveHeaders().get("Accept-Encoding");
                                    if (CollectionUtils.isNotEmpty(acceptEncodingList)) {
                                        for (String acceptEncoding : acceptEncodingList) {
                                            if (acceptEncoding == null || !acceptEncoding.contains("gzip")) continue;
                                            servletResponse.setHeader("Content-Encoding", "gzip");
                                            responseOutputStream = new GZIPOutputStream((OutputStream)responseOutputStream);
                                            break;
                                        }
                                    }
                                    if (this.staticResource.getResourceType() != HttpStaticResource.ResourceType.FILE) break block34;
                                    FileInputStream is2 = null;
                                    try {
                                        is2 = new FileInputStream(value);
                                        IOUtils.copy((InputStream)is2, (OutputStream)responseOutputStream);
                                    }
                                    catch (Throwable throwable) {
                                        ResourceUtil.closeResourceQuietly(is2);
                                        throw throwable;
                                    }
                                    ResourceUtil.closeResourceQuietly((Closeable)is2);
                                    break block35;
                                }
                                if (this.staticResource.getResourceType() != HttpStaticResource.ResourceType.DIRECTORY) break block36;
                                File parentFile = new File(value);
                                File file = null;
                                if (parentFile.isDirectory()) {
                                    if (!StringUtils.startsWithIgnoreCase((CharSequence)contextPath, (CharSequence)this.staticResource.getContextPath())) {
                                        servletResponse.reset();
                                        return;
                                    }
                                    String childPath = StringUtils.replaceChars((String)StringUtils.removeStartIgnoreCase((String)contextPath, (String)this.staticResource.getContextPath()), (char)'\\', (char)'/');
                                    while (childPath.startsWith("/")) {
                                        childPath = childPath.substring(1);
                                    }
                                    if (childPath.contains("/")) {
                                        servletResponse.reset();
                                        return;
                                    }
                                    file = new File(parentFile, childPath);
                                } else {
                                    throw new Exception("\"" + parentFile.toString() + "\" does not exist or is not a directory.");
                                }
                                if (file == null || !file.exists()) break block37;
                                if (file.isDirectory()) {
                                    servletResponse.reset();
                                    return;
                                }
                                if (file.getParentFile() == null || !file.getParentFile().equals(parentFile)) {
                                    servletResponse.reset();
                                    return;
                                }
                                is = null;
                                try {
                                    is = new FileInputStream(file);
                                    IOUtils.copy((InputStream)is, (OutputStream)responseOutputStream);
                                }
                                catch (Throwable throwable) {
                                    ResourceUtil.closeResourceQuietly(is);
                                    throw throwable;
                                }
                                break block38;
                            }
                            servletResponse.reset();
                            return;
                        }
                        ResourceUtil.closeResourceQuietly((Closeable)is);
                        break block35;
                    }
                    IOUtils.write((String)value, (OutputStream)responseOutputStream, (Charset)charset);
                }
                if (responseOutputStream instanceof GZIPOutputStream) {
                    ((GZIPOutputStream)responseOutputStream).finish();
                }
            }
            catch (Throwable t) {
                HttpReceiver.this.logger.error("Error handling static HTTP resource request (" + HttpReceiver.this.getConnectorProperties().getName() + " \"Source\" on channel " + HttpReceiver.this.getChannelId() + ").", t);
                HttpReceiver.this.eventController.dispatchEvent((Event)new ErrorEvent(HttpReceiver.this.getChannelId(), Integer.valueOf(HttpReceiver.this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, HttpReceiver.this.getSourceName(), HttpReceiver.this.getConnectorProperties().getName(), "Error handling static HTTP resource request", t));
                servletResponse.reset();
                servletResponse.setContentType(ContentType.TEXT_PLAIN.toString());
                servletResponse.setStatus(500);
                servletResponse.getOutputStream().write(ExceptionUtils.getStackTrace((Throwable)t).getBytes());
            }
            finally {
                Thread.currentThread().setName(originalThreadName);
            }
            baseRequest.setHandled(true);
        }
    }

    private class RequestHandler
    extends AbstractHandler {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handle(String target, Request baseRequest, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
            block15: {
                HttpReceiver.this.logger.debug("received HTTP request");
                HttpReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(HttpReceiver.this.getChannelId(), Integer.valueOf(HttpReceiver.this.getMetaDataId()), HttpReceiver.this.getSourceName(), ConnectionStatusEventType.CONNECTED));
                DispatchResult dispatchResult = null;
                String originalThreadName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName("HTTP Receiver Thread on " + HttpReceiver.this.getChannel().getName() + " (" + HttpReceiver.this.getChannelId() + ") < " + originalThreadName);
                    HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                    Object messageContent = null;
                    try {
                        messageContent = HttpReceiver.this.getMessage(baseRequest, sourceMap, attachments);
                    }
                    catch (Throwable t) {
                        HttpReceiver.this.sendErrorResponse(baseRequest, servletResponse, dispatchResult, t);
                    }
                    if (messageContent == null) break block15;
                    if (HttpReceiver.this.isProcessBatch()) {
                        if (messageContent instanceof byte[]) {
                            BatchMessageException e = new BatchMessageException("Batch processing is not supported for binary data.");
                            HttpReceiver.this.logger.error(e.getMessage() + " (channel: " + ChannelController.getInstance().getDeployedChannelById(HttpReceiver.this.getChannelId()).getName() + ")", (Throwable)e);
                            HttpReceiver.this.eventController.dispatchEvent((Event)new ErrorEvent(HttpReceiver.this.getChannelId(), Integer.valueOf(HttpReceiver.this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, HttpReceiver.this.getSourceName(), HttpReceiver.this.getConnectorProperties().getName(), null, (Throwable)e));
                            break block15;
                        } else {
                            try {
                                BatchRawMessage batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader((String)messageContent), sourceMap, attachments);
                                SimpleResponseHandler responseHandler = new SimpleResponseHandler();
                                HttpReceiver.this.dispatchBatchMessage(batchRawMessage, (ResponseHandler)responseHandler);
                                dispatchResult = responseHandler.getResultForResponse();
                                HttpReceiver.this.sendResponse(baseRequest, servletResponse, dispatchResult);
                            }
                            catch (Throwable t) {
                                HttpReceiver.this.sendErrorResponse(baseRequest, servletResponse, dispatchResult, t);
                            }
                        }
                        break block15;
                    }
                    try {
                        RawMessage rawMessage = null;
                        rawMessage = messageContent instanceof byte[] ? new RawMessage((byte[])messageContent, null, sourceMap, attachments) : new RawMessage((String)messageContent, null, sourceMap, attachments);
                        dispatchResult = HttpReceiver.this.dispatchRawMessage(rawMessage);
                        HttpReceiver.this.sendResponse(baseRequest, servletResponse, dispatchResult);
                    }
                    catch (Throwable t) {
                        try {
                            HttpReceiver.this.sendErrorResponse(baseRequest, servletResponse, dispatchResult, t);
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            HttpReceiver.this.finishDispatch(dispatchResult);
                        }
                    }
                    HttpReceiver.this.finishDispatch(dispatchResult);
                }
                finally {
                    HttpReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(HttpReceiver.this.getChannelId(), Integer.valueOf(HttpReceiver.this.getMetaDataId()), HttpReceiver.this.getSourceName(), ConnectionStatusEventType.IDLE));
                    Thread.currentThread().setName(originalThreadName);
                }
            }
            baseRequest.setHandled(true);
        }
    }
}

