/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.client.service;

import com.mirth.connect.client.core.Client;
import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.EntityException;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.plugins.dynamiclookup.client.exception.LookupApiClientException;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.request.LookupValueRequest;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ErrorResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ExportGroupPagedResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ExportLookupGroupResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.GroupAuditEntriesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.GroupStatisticsResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ImportLookupGroupResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.ImportValuesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.LookupAllValuesResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.dto.response.LookupValueResponse;
import com.mirth.connect.plugins.dynamiclookup.shared.interfaces.LookupTableServletInterface;
import com.mirth.connect.plugins.dynamiclookup.shared.model.HistoryFilterState;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupGroup;
import com.mirth.connect.plugins.dynamiclookup.shared.model.LookupValue;
import com.mirth.connect.plugins.dynamiclookup.shared.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupServiceClient {
    private static LookupServiceClient instance = null;
    private LookupTableServletInterface servlet;
    private final Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LookupServiceClient getInstance() {
        Class<LookupServiceClient> clazz = LookupServiceClient.class;
        synchronized (LookupServiceClient.class) {
            if (instance == null) {
                instance = new LookupServiceClient();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<LookupGroup> getAllGroups() throws ClientException {
        try {
            String string = this.getServlet().getAllGroups();
            return JsonUtils.fromJsonList((String)string, LookupGroup.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get all groups", exception);
        }
    }

    public LookupGroup getGroupById(Integer n) throws ClientException {
        try {
            String string = this.getServlet().getGroupById(n);
            return (LookupGroup)JsonUtils.fromJson((String)string, LookupGroup.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get group by id", exception);
        }
    }

    public LookupGroup getGroupByName(String string) throws ClientException {
        try {
            String string2 = this.getServlet().getGroupByName(string);
            return (LookupGroup)JsonUtils.fromJson((String)string2, LookupGroup.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get group by name", exception);
        }
    }

    public LookupGroup createGroup(LookupGroup lookupGroup) throws ClientException {
        try {
            String string = JsonUtils.toJson((Object)lookupGroup);
            String string2 = this.getServlet().createGroup(string);
            return (LookupGroup)JsonUtils.fromJson((String)string2, LookupGroup.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create group", exception);
        }
    }

    public LookupGroup updateGroup(LookupGroup lookupGroup) throws ClientException {
        try {
            String string = JsonUtils.toJson((Object)lookupGroup);
            String string2 = this.getServlet().updateGroup(Integer.valueOf(lookupGroup.getId()), string);
            return (LookupGroup)JsonUtils.fromJson((String)string2, LookupGroup.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to update group", exception);
        }
    }

    public void deleteGroup(Integer n) throws ClientException {
        try {
            this.getServlet().deleteGroup(n);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to delete group", exception);
        }
    }

    public ImportLookupGroupResponse importGroup(boolean bl, String string) throws ClientException {
        try {
            String string2 = this.getServlet().importGroup(bl, string);
            return (ImportLookupGroupResponse)JsonUtils.fromJson((String)string2, ImportLookupGroupResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to import group", exception);
        }
    }

    public ExportLookupGroupResponse exportGroup(Integer n) throws ClientException {
        try {
            String string = this.getServlet().exportGroup(n);
            return (ExportLookupGroupResponse)JsonUtils.fromJson((String)string, ExportLookupGroupResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to export group", exception);
        }
    }

    public ExportGroupPagedResponse exportGroupPaged(Integer n, int n2, int n3) throws ClientException {
        try {
            String string = this.getServlet().exportGroupPaged(n, Integer.valueOf(n2), Integer.valueOf(n3));
            return (ExportGroupPagedResponse)JsonUtils.fromJson((String)string, ExportGroupPagedResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to export group (paged)", exception);
        }
    }

    public boolean checkValueExists(Integer n, String string) throws ClientException {
        try {
            String string2 = this.getServlet().getValue(n, string);
            JsonUtils.fromJson((String)string2, LookupValue.class);
            return true;
        }
        catch (ClientException clientException) {
            try {
                this.rethrowParsedClientError(clientException, false);
            }
            catch (LookupApiClientException lookupApiClientException) {
                if ("VALUE_NOT_FOUND".equalsIgnoreCase(lookupApiClientException.getError().getCode())) {
                    return false;
                }
                throw lookupApiClientException;
            }
            throw clientException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected error while checking value existence", exception);
        }
    }

    public LookupValue getValue(Integer n, String string) throws ClientException {
        try {
            String string2 = this.getServlet().getValue(n, string);
            return (LookupValue)JsonUtils.fromJson((String)string2, LookupValue.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get value", exception);
        }
    }

    public LookupValueResponse setValue(Integer n, LookupValue lookupValue) throws ClientException {
        try {
            LookupValueRequest lookupValueRequest = new LookupValueRequest();
            lookupValueRequest.setValue(lookupValue.getValueData());
            String string = this.getServlet().setValue(n, lookupValue.getKeyValue(), JsonUtils.toJson((Object)lookupValueRequest));
            return (LookupValueResponse)JsonUtils.fromJson((String)string, LookupValueResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to set value", exception);
        }
    }

    public void deleteValue(Integer n, String string) throws ClientException {
        try {
            this.getServlet().deleteValue(n, string);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to delete value", exception);
        }
    }

    public LookupAllValuesResponse getAllValues(Integer n, int n2, int n3, String string) throws ClientException {
        try {
            String string2 = this.getServlet().getAllValues(n, Integer.valueOf(n2), Integer.valueOf(n3), string);
            return (LookupAllValuesResponse)JsonUtils.fromJson((String)string2, LookupAllValuesResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get all values", exception);
        }
    }

    public ImportValuesResponse importValues(Integer n, boolean bl, Map<String, String> map) throws ClientException {
        try {
            HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
            hashMap.put("values", map);
            String string = this.getServlet().importValues(n, bl, JsonUtils.toJson(hashMap));
            return (ImportValuesResponse)JsonUtils.fromJson((String)string, ImportValuesResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to import values", exception);
        }
    }

    public GroupAuditEntriesResponse getAllAuditEntries(Integer n, int n2, int n3) throws ClientException {
        try {
            String string = this.getServlet().getGroupAuditEntries(n, Integer.valueOf(n2), Integer.valueOf(n3));
            return (GroupAuditEntriesResponse)JsonUtils.fromJson((String)string, GroupAuditEntriesResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get all audit entries", exception);
        }
    }

    public GroupAuditEntriesResponse searchAuditEntries(Integer n, int n2, int n3, HistoryFilterState historyFilterState) throws ClientException {
        try {
            String string = this.getServlet().searchGroupAuditEntries(n, Integer.valueOf(n2), Integer.valueOf(n3), historyFilterState.toJson());
            return (GroupAuditEntriesResponse)JsonUtils.fromJson((String)string, GroupAuditEntriesResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get search audit entries", exception);
        }
    }

    public GroupStatisticsResponse getGroupStatistics(Integer n) throws ClientException {
        try {
            String string = this.getServlet().getGroupStatistics(n);
            return (GroupStatisticsResponse)JsonUtils.fromJson((String)string, GroupStatisticsResponse.class);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to get group statistics", exception);
        }
    }

    public void resetGroupStatistics(Integer n) throws ClientException {
        try {
            this.getServlet().resetGroupStatistics(n);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to clear group statistics", exception);
        }
    }

    public void clearGroupCache(Integer n) throws ClientException {
        try {
            this.getServlet().clearGroupCache(n);
        }
        catch (ClientException clientException) {
            this.rethrowParsedClientError(clientException);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to clear group cache", exception);
        }
    }

    private LookupTableServletInterface getServlet() {
        if (this.servlet == null) {
            Client client = PlatformUI.MIRTH_FRAME.mirthClient;
            this.servlet = (LookupTableServletInterface)client.getServlet(LookupTableServletInterface.class);
        }
        return this.servlet;
    }

    private void rethrowParsedClientError(ClientException clientException) throws ClientException {
        this.rethrowParsedClientError(clientException, true);
    }

    private void rethrowParsedClientError(ClientException clientException, boolean bl) throws ClientException {
        Throwable throwable = clientException.getCause();
        if (throwable instanceof EntityException) {
            ErrorResponse errorResponse;
            String string = (String)((EntityException)throwable).getEntity();
            try {
                errorResponse = (ErrorResponse)JsonUtils.fromJson((String)string, ErrorResponse.class);
                if (bl) {
                    this.logger.error("Parsed API error: {}", (Object)JsonUtils.toJson((Object)errorResponse));
                }
            }
            catch (Exception exception) {
                if (bl) {
                    this.logger.error("Failed to parse server error response: {}", (Object)string, (Object)exception);
                }
                errorResponse = new ErrorResponse("UNPARSEABLE_RESPONSE", "Failed to parse server error");
            }
            throw new LookupApiClientException(errorResponse, clientException);
        }
        throw clientException;
    }
}

