/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.dto.response;

import java.util.ArrayList;
import java.util.List;

public class ImportLookupGroupResponse {
    public static final String STATUS_SUCCESS = "success";
    public static final String STATUS_ERROR = "error";
    private String status;
    private int groupId;
    private int importedCount;
    private List<String> errors;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int n) {
        this.groupId = n;
    }

    public int getImportedCount() {
        return this.importedCount;
    }

    public void setImportedCount(int n) {
        this.importedCount = n;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> list) {
        this.errors = list;
    }

    public boolean isSuccessful() {
        return STATUS_SUCCESS.equalsIgnoreCase(this.status);
    }

    public boolean isError() {
        return STATUS_ERROR.equalsIgnoreCase(this.status);
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public static ImportLookupGroupResponse fromResult(int n, int n2, List<String> list) {
        Builder builder = new Builder().withGroupId(n).withImportedCount(n2);
        if (list != null && !list.isEmpty()) {
            builder.addErrors(list);
        }
        return builder.build();
    }

    public static class Builder {
        private final ImportLookupGroupResponse response = new ImportLookupGroupResponse();

        public Builder() {
            this.response.setErrors(new ArrayList<String>());
        }

        public Builder withGroupId(int n) {
            this.response.setGroupId(n);
            return this;
        }

        public Builder withImportedCount(int n) {
            this.response.setImportedCount(n);
            return this;
        }

        public Builder addError(String string) {
            this.response.getErrors().add(string);
            return this;
        }

        public Builder addErrors(List<String> list) {
            if (list != null && !list.isEmpty()) {
                this.response.getErrors().addAll(list);
            }
            return this;
        }

        public ImportLookupGroupResponse build() {
            this.response.setStatus(ImportLookupGroupResponse.STATUS_SUCCESS);
            return this.response;
        }
    }
}

