/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.interfaces;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/v1/lookups")
@Tag(name="Lookup Table")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface LookupTableServletInterface
extends BaseServletInterface {
    public static final String PERMISSION_ACCESS = "Access Lookup Table";

    @POST
    @Path(value="/groups")
    @Operation(summary="Creates a new lookup group.")
    @ApiResponse(responseCode="200", description="The created lookup group returned as a JSON object.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="group", summary="Example response for a successfully created group", value="{\n  \"id\": 3,\n  \"name\": \"Provider Directory\",\n  \"description\": \"Provider information lookup\",\n  \"version\": \"1.0\",\n  \"cacheSize\": 500,\n  \"cachePolicy\": \"LRU\",\n  \"createdDate\": \"2025-05-01T08:15:00Z\",\n  \"updatedDate\": \"2025-05-01T08:15:00Z\"\n}")})})
    @MirthOperation(name="createGroup", display="Create new group", permission="Access Lookup Table")
    public String createGroup(@Param(value="requestBody") @RequestBody(description="JSON object representing the lookup group to be created.", required=true, content={@Content(mediaType="application/json", examples={@ExampleObject(name="group", summary="group", value="{\n  \"name\": \"Provider Directory\",\n  \"description\": \"Provider information lookup\",\n  \"version\": \"1.0\",\n  \"cacheSize\": 500,\n  \"cachePolicy\": \"LRU\"\n}")})}) String var1) throws ClientException;

    @GET
    @Path(value="/groups")
    @Operation(summary="Returns all lookup groups.")
    @MirthOperation(name="getAllGroups", display="Get lookup group list", permission="Access Lookup Table")
    public String getAllGroups() throws ClientException;

    @PUT
    @Path(value="/groups/{groupId}")
    @Operation(summary="Updates a specified group.")
    @ApiResponse(responseCode="200", description="Group was successfully updated.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="UpdatedGroup", summary="Updated group object", value="{\n  \"id\": 3,\n  \"name\": \"Provider Directory\",\n  \"description\": \"Updated provider information lookup\",\n  \"version\": \"1.1\",\n  \"cacheSize\": 1000,\n  \"cachePolicy\": \"LRU\",\n  \"createdDate\": \"2025-05-01T08:15:00Z\",\n  \"updatedDate\": \"2025-05-01T09:30:00Z\"\n}")})})
    @MirthOperation(name="updateGroup", display="Update group", permission="Access Lookup Table")
    public String updateGroup(@Param(value="groupId") @Parameter(name="groupId", description="The unique id of the group to update.", example="1", required=true) @PathParam(value="groupId") Integer var1, @RequestBody(description="JSON object representing the lookup group to be update.", required=true, content={@Content(mediaType="application/json", examples={@ExampleObject(name="group", summary="group", value="{\n  \"name\": \"Provider Directory\",\n  \"description\": \"Updated provider information lookup\",\n  \"version\": \"1.0\",\n  \"cacheSize\": 500,\n  \"cachePolicy\": \"LRU\"\n}")})}) String var2) throws ClientException;

    @GET
    @Path(value="/groups/{groupId}")
    @Operation(summary="Returns a specific lookup group by id.")
    @ApiResponse(responseCode="200", description="The lookup group returned as a JSON object.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="group", value="{\n  \"id\": 3,\n  \"name\": \"Provider Directory\",\n  \"description\": \"Provider information lookup\",\n  \"version\": \"1.0\",\n  \"cacheSize\": 500,\n  \"cachePolicy\": \"LRU\",\n  \"createdDate\": \"2025-05-01T08:15:00Z\",\n  \"updatedDate\": \"2025-05-01T08:15:00Z\"\n}")})})
    @MirthOperation(name="getGroupById", display="Get lookup group", permission="Access Lookup Table")
    public String getGroupById(@Param(value="groupId") @Parameter(description="The unique id of the group to retrieve.", required=true) @PathParam(value="groupId") Integer var1) throws ClientException;

    @GET
    @Path(value="/groups/name/{name}")
    @Operation(summary="Returns a specific lookup group by name.")
    @ApiResponse(responseCode="200", description="The lookup group returned as a JSON object.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="group", value="{\n  \"id\": 3,\n  \"name\": \"Provider Directory\",\n  \"description\": \"Provider information lookup\",\n  \"version\": \"1.0\",\n  \"cacheSize\": 500,\n  \"cachePolicy\": \"LRU\",\n  \"createdDate\": \"2025-05-01T08:15:00Z\",\n  \"updatedDate\": \"2025-05-01T08:15:00Z\"\n}")})})
    @MirthOperation(name="getGroupByName", display="Get lookup group", permission="Access Lookup Table")
    public String getGroupByName(@Param(value="name") @Parameter(description="The unique name of the group to retrieve.", required=true) @PathParam(value="name") String var1) throws ClientException;

    @DELETE
    @Path(value="/groups/{groupId}")
    @Operation(summary="Delete a specific group.")
    @MirthOperation(name="deleteGroup", display="Delete group", permission="Access Lookup Table")
    public void deleteGroup(@Param(value="groupId") @Parameter(description="The unique id of the group to delete.", required=true) @PathParam(value="groupId") Integer var1) throws ClientException;

    @GET
    @Path(value="/groups/{groupId}/values")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all values from a specific lookup group with optional pagination and key filtering.")
    @ApiResponse(responseCode="200", description="Successfully retrieved values", content={@Content(mediaType="application/json", examples={@ExampleObject(name="Successful response", value="{\n  \"groupId\": 1,\n  \"groupName\": \"Billing Codes\",\n  \"totalCount\": 7,\n  \"values\": [\n    {\n      \"keyValue\": \"99213\",\n      \"valueData\": \"Office Visit\",\n      \"createdDate\": \"2025-06-22T01:19:25.213+00:00\",\n      \"updatedDate\": \"2025-06-22T01:29:45.123+00:00\"\n    },\n    {\n      \"keyValue\": \"99214\",\n      \"valueData\": \"Office Visit, Level 4\",\n      \"createdDate\": \"2025-06-22T01:19:25.213+00:00\",\n      \"updatedDate\": \"2025-06-22T01:19:25.213+00:00\"\n    }\n    // truncated for brevity\n  ],\n  \"pagination\": {\n    \"limit\": 100,\n    \"offset\": 0,\n    \"hasMore\": false\n  }\n}")})})
    @MirthOperation(name="getAllValues", display="Retrieves all values", permission="Access Lookup Table")
    public String getAllValues(@Param(value="groupId") @Parameter(description="The unique ID of the group to retrieve.", required=true) @PathParam(value="groupId") Integer var1, @Param(value="offset") @Parameter(description="Offset for pagination (default: 0)", required=false) @QueryParam(value="offset") @DefaultValue(value="0") Integer var2, @Param(value="limit") @Parameter(description="Maximum number of values to return (default: 100)", required=false) @QueryParam(value="limit") @DefaultValue(value="100") Integer var3, @Param(value="pattern") @Parameter(description="Filter keys by pattern (optional)", required=false) @QueryParam(value="pattern") String var4) throws ClientException;

    @GET
    @Path(value="/groups/{groupId}/values/{key}")
    @Operation(summary="Retrieve a lookup value by group and key.")
    @ApiResponse(responseCode="200", description="Successfully retrieved the lookup value.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="LookupValue", summary="A sample lookup value response", value="{\n  \"groupId\": 1,\n  \"key\": \"99213\",\n  \"value\": \"Office Visit, Established Patient\",\n}")})})
    @MirthOperation(name="getValue", display="Retrieve Lookup Value", permission="Access Lookup Table")
    public String getValue(@Param(value="groupId") @Parameter(name="groupId", description="The unique ID of the lookup group containing the value.", example="1", required=true) @PathParam(value="groupId") Integer var1, @Param(value="key") @Parameter(name="key", description="The primary key of the lookup value within the specified group.", example="99213", required=true) @PathParam(value="key") String var2) throws ClientException;

    @PUT
    @Path(value="/groups/{groupId}/values/{key}")
    @Operation(summary="Set or update the value for a specific key within a lookup group.", description="Updates the value associated with the specified key in the given lookup group. Expects a JSON body with a 'value' field. If the key exists, the value is updated; otherwise, a new entry may be created.")
    @ApiResponse(responseCode="200", description="The lookup value returned as a JSON object.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="value", value="{\n  \"groupId\": 1,\n  \"key\": \"99213\",\n  \"value\": \"Office Visit, Established Patient - Level 3\",\n  \"createdDate\": \"2025-05-01T08:15:00Z\",\n  \"updatedDate\": \"2025-05-01T08:15:00Z\"\n}")})})
    @MirthOperation(name="setValue", display="Set Lookup Value", permission="Access Lookup Table")
    public String setValue(@Param(value="groupId") @Parameter(name="groupId", description="The unique ID of the lookup group containing the key-value pair.", example="42", required=true) @PathParam(value="groupId") Integer var1, @Param(value="key") @Parameter(name="key", description="The primary key of the lookup value to update within the specified group.", example="99213", required=true) @PathParam(value="key") String var2, @Param(value="requestBody") @RequestBody(description="Raw JSON string containing a 'value' field.", required=true, content={@Content(mediaType="application/json", examples={@ExampleObject(name="value", summary="Set or update value", value="{ \"value\": \"Office Visit, Established Patient - Level 3\" }")})}) String var3) throws ClientException;

    @DELETE
    @Path(value="/groups/{groupId}/values/{key}")
    @Operation(summary="Delete a lookup value by group and key.")
    @MirthOperation(name="deleteValue", display="Delete Lookup Value", permission="Access Lookup Table")
    @Produces(value={"application/json"})
    public void deleteValue(@Param(value="groupId") @Parameter(name="groupId", description="The unique ID of the lookup group containing the value.", example="42", required=true) @PathParam(value="groupId") Integer var1, @Param(value="key") @Parameter(name="key", description="The primary key of the lookup value within the specified group.", example="M", required=true) @PathParam(value="key") String var2) throws ClientException;

    @POST
    @Path(value="/groups/{groupId}/values")
    @Operation(summary="Imports key-value pairs into a specific lookup group.")
    @ApiResponse(responseCode="200", description="Import successful", content={@Content(mediaType="application/json", examples={@ExampleObject(name="Success", value="{\n  \"groupId\": 1,\n  \"status\": \"success\",\n  \"importedCount\": 4,\n  \"errors\": []\n}")})})
    @MirthOperation(name="importValues", display="Import lookup values", permission="Access Lookup Table")
    public String importValues(@Param(value="groupId") @Parameter(description="The ID of the group to import values into.", required=true) @PathParam(value="groupId") Integer var1, @Param(value="clearExist") @Parameter(description="If true, existing values in the group will be cleared before import. Default: false", required=false) @QueryParam(value="clearExist") @DefaultValue(value="false") boolean var2, @Param(value="requestBody") @RequestBody(description="Raw JSON containing a 'values' object with key-value pairs to import.", required=true, content={@Content(mediaType="application/json", examples={@ExampleObject(name="ImportValuesExample", summary="Key-value import payload", value="{\n  \"values\": {\n    \"99213\": \"Office Visit, Established Patient\",\n    \"99214\": \"Office Visit, Level 4\",\n    \"99215\": \"Office Visit, Level 5\",\n    \"J0696\": \"Injection, Ceftriaxone Sodium\"\n  }\n}")})}) String var3) throws ClientException;

    @GET
    @Path(value="/groups/{groupId}/export")
    @Produces(value={"application/json"})
    @Operation(summary="Exports a lookup group and its values for backup or migration.")
    @ApiResponse(responseCode="200", description="Successfully exported the lookup group and its values.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="ExportExample", summary="Exported lookup group for backup/migration", value="{\n  \"group\": {\n    \"id\": 1,\n    \"name\": \"Billing Codes\",\n    \"description\": \"Standard billing codes for claims\",\n    \"version\": \"1.0\",\n    \"cacheSize\": 1000,\n    \"cachePolicy\": \"LRU\",\n    \"createdDate\": \"2024-12-15T08:00:00Z\",\n    \"updatedDate\": \"2025-05-01T10:00:00Z\"\n  },\n  \"values\": {\n    \"99213\": \"Office Visit, Established Patient\",\n    \"99214\": \"Office Visit, Level 4\",\n    \"99215\": \"Office Visit, Level 5\",\n    \"J0696\": \"Injection, Ceftriaxone Sodium\"\n  },\n  \"exportDate\": \"2025-05-27T14:30:00Z\"\n}")})})
    @MirthOperation(name="exportGroup", display="Export Lookup Group", permission="Access Lookup Table")
    public String exportGroup(@Param(value="groupId") @Parameter(description="The ID of the lookup group to export.", required=true) @PathParam(value="groupId") Integer var1) throws ClientException;

    @GET
    @Path(value="/groups/{groupId}/exportPaged")
    @Produces(value={"application/json"})
    @Operation(summary="Exports values for a lookup group in pages, for large backups or migrations.")
    @ApiResponse(responseCode="200", description="Successfully exported a page of values for the specified lookup group.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="PagedExportExample", summary="A single page of lookup values", value="{\n  \"groupId\": 1,\n  \"offset\": 0,\n  \"limit\": 10000,\n  \"values\": {\n    \"99213\": \"Office Visit, Established Patient\",\n    \"99214\": \"Office Visit, Level 4\"\n  }\n}")})})
    @MirthOperation(name="exportGroupPaged", display="Export Paged Lookup Group", permission="Access Lookup Table")
    public String exportGroupPaged(@Param(value="groupId") @Parameter(description="The ID of the lookup group to export.", required=true) @PathParam(value="groupId") Integer var1, @QueryParam(value="offset") @DefaultValue(value="0") @Parameter(description="Offset for pagination.") Integer var2, @QueryParam(value="limit") @DefaultValue(value="10000") @Parameter(description="Maximum number of entries to return.") Integer var3) throws ClientException;

    @POST
    @Path(value="/groups/import")
    @Operation(summary="Imports a lookup group and its values for migration or restore. If the group already exists, all of its existing values will be deleted and replaced with the new ones.")
    @ApiResponse(responseCode="200", description="Successfully imported the lookup group and its values.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="ImportExample", summary="Imported lookup group", value="{\n  \"status\": \"success\",\n  \"groupId\": 1,\n  \"importedCount\": 4,\n  \"errors\": []\n}")})})
    @MirthOperation(name="importGroup", display="Import Lookup Group", permission="Access Lookup Table")
    public String importGroup(@Param(value="updateIfExists") @Parameter(description="If true, updates the group if it already exists. Default: false", required=false) @QueryParam(value="updateIfExists") @DefaultValue(value="false") boolean var1, @Param(value="requestBody") @RequestBody(description="Raw JSON containing a group and its values to import.", required=true, content={@Content(mediaType="application/json", examples={@ExampleObject(name="ImportRequestExample", summary="Import a group", value="{\n  \"group\": {\n    \"name\": \"Billing Codes\",\n    \"description\": \"Standard billing codes for claims\",\n    \"version\": \"1.0\",\n    \"cacheSize\": 1000,\n    \"cachePolicy\": \"LRU\"\n  },\n  \"values\": {\n    \"99213\": \"Office Visit, Established Patient\",\n    \"99214\": \"Office Visit, Level 4\",\n    \"99215\": \"Office Visit, Level 5\",\n    \"J0696\": \"Injection, Ceftriaxone Sodium\"\n  }\n}")})}) String var2) throws ClientException;

    @POST
    @Path(value="/groups/{groupId}/values/batch")
    @Operation(summary="Batch Get Values", description="Retrieves multiple values from a lookup group in a single request.")
    @ApiResponse(responseCode="200", description="Successfully retrieved values for provided keys.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="BatchGetExample", summary="Successful lookup", value="{\n  \"groupId\": 1,\n  \"values\": {\n    \"99213\": \"Office Visit, Established Patient\",\n    \"99214\": \"Office Visit, Level 4\",\n    \"99215\": \"Office Visit, Level 5\",\n    \"J0696\": \"Injection, Ceftriaxone Sodium\"\n  },\n  \"missingKeys\": []\n}")})})
    @MirthOperation(name="batchGetValues", display="Batch Get Values", permission="Access Lookup Table")
    public String batchGetValues(@Param(value="groupId") @Parameter(description="The ID of the group to retrieve values from.", required=true) @PathParam(value="groupId") Integer var1, @Param(value="requestBody") @RequestBody(description="JSON body containing a list of keys to retrieve.", required=true, content={@Content(mediaType="application/json", examples={@ExampleObject(name="BatchGetRequest", summary="Keys to fetch", value="{ \"keys\": [\"99213\", \"99214\", \"99215\", \"J0696\"] }")})}) String var2) throws ClientException;

    @GET
    @Path(value="/groups/{groupId}/statistics")
    @Operation(summary="Get Group Statistics", description="Retrieves usage and cache statistics for a specific lookup group.")
    @ApiResponse(responseCode="200", description="Successfully retrieved group statistics.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="GroupStatisticsExample", summary="Group usage and cache stats", value="{\n  \"groupId\": 1,\n  \"totalLookups\": 15423,\n  \"cacheHits\": 12501,\n  \"hitRate\": 0.81,\n  \"lastAccessed\": \"2025-05-01T16:45:12Z\",\n  \"resetDate\": \"2025-04-01T00:00:00Z\",\n  \"cacheStatistics\": {\n    \"size\": 267,\n    \"maxSize\": 1000,\n    \"hitCount\": 12501,\n    \"missCount\": 2922,\n    \"evictionCount\": 0\n  }\n}")})})
    @MirthOperation(name="getGroupStatistics", display="Get Group Statistics", permission="Access Lookup Table")
    public String getGroupStatistics(@Param(value="groupId") @Parameter(description="The ID of the group to retrieve statistics for.", required=true) @PathParam(value="groupId") Integer var1) throws ClientException;

    @POST
    @Path(value="/groups/{groupId}/statistics/reset")
    @Operation(summary="Reset Group Statistics", description="Resets total lookups and cache hits for a specific group, and updates the reset timestamp.")
    @ApiResponse(responseCode="200", description="Statistics successfully reset.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="ResetSuccessExample", summary="Successful statistics reset", value="{\n  \"status\": \"success\",\n  \"message\": \"Statistics reset successfully for group ID: 1\"\n}")})})
    @MirthOperation(name="resetGroupStatistics", display="Reset Group Statistics", permission="Access Lookup Table")
    public String resetGroupStatistics(@Param(value="groupId") @Parameter(description="The ID of the group whose statistics will be reset.", required=true) @PathParam(value="groupId") Integer var1) throws ClientException;

    @GET
    @Path(value="/groups/{groupId}/audit")
    @Operation(summary="Get Group Audit Entries", description="Retrieves a paginated list of audit entries for a specific lookup group.")
    @ApiResponse(responseCode="200", description="Successfully retrieved audit entries.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="AuditEntriesExample", summary="Audit log with pagination", value="{\n  \"groupId\": 1,\n  \"totalEntries\": 1243,\n  \"entries\": [...],\n  \"pagination\": {\n    \"limit\": 100,\n    \"offset\": 0,\n    \"hasMore\": true\n  }\n}")})})
    @MirthOperation(name="getGroupAuditEntries", display="Get Group Audit Entries", permission="Access Lookup Table")
    public String getGroupAuditEntries(@Param(value="groupId") @Parameter(description="The ID of the group to retrieve audit entries for.", required=true) @PathParam(value="groupId") Integer var1, @QueryParam(value="offset") @DefaultValue(value="0") @Parameter(description="Offset for pagination.") Integer var2, @QueryParam(value="limit") @DefaultValue(value="100") @Parameter(description="Maximum number of entries to return.") Integer var3) throws ClientException;

    @POST
    @Path(value="/groups/{groupId}/audit/search")
    @Operation(summary="Search Group Audit Entries", description="Retrieves a paginated list of audit entries for a specific group using filter criteria.")
    @ApiResponse(responseCode="200", description="Successfully retrieved audit entries.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="AuditEntriesExample", summary="Audit log with pagination", value="{\n  \"groupId\": 1,\n  \"totalEntries\": 1243,\n  \"entries\": [...],\n  \"pagination\": {\n    \"limit\": 100,\n    \"offset\": 0,\n    \"hasMore\": true\n  }\n}")})})
    @MirthOperation(name="searchGroupAuditEntries", display="Search Group Audit Entries", permission="Access Lookup Table")
    public String searchGroupAuditEntries(@Param(value="groupId") @PathParam(value="groupId") Integer var1, @QueryParam(value="offset") @DefaultValue(value="0") Integer var2, @QueryParam(value="limit") @DefaultValue(value="100") Integer var3, @Param(value="filterState") @RequestBody(description="JSON object representing filter criteria for audit entry search.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="filter", summary="Example filter for audit entry search", value="{\n  \"keyValue\": \"Provider\",\n  \"action\": \"CREATE\",\n  \"userId\": \"1\",\n  \"startDate\": \"2025-06-01T00:00:00\",\n  \"endDate\": \"2025-06-16T23:59:59\"\n}")})}) String var4) throws ClientException;

    @POST
    @Path(value="/groups/{groupId}/cache/clear")
    @Operation(summary="Clear Group Cache", description="Clears the in-memory cache for a specific lookup group.")
    @ApiResponse(responseCode="200", description="Cache cleared successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="SuccessResponse", summary="Successful cache clear", value="{\n  \"status\": \"success\",\n  \"message\": \"Cache cleared successfully for group ID: 1\"\n}")})})
    @MirthOperation(name="clearGroupCache", display="Clear Group Cache", permission="Access Lookup Table")
    public String clearGroupCache(@Param(value="groupId") @Parameter(description="The ID of the group to clear the cache for.", required=true) @PathParam(value="groupId") Integer var1) throws ClientException;

    @POST
    @Path(value="/cache/clear")
    @Operation(summary="Clear All Caches", description="Clears the in-memory caches for all lookup groups.")
    @ApiResponse(responseCode="200", description="All caches cleared successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="SuccessResponse", summary="All caches cleared", value="{\n  \"status\": \"success\",\n  \"message\": \"All caches cleared successfully\"\n}")})})
    @MirthOperation(name="clearAllCaches", display="Clear All Caches", permission="Access Lookup Table")
    public String clearAllCaches() throws ClientException;
}

