/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dynamiclookup.shared.model;

import java.util.Properties;

public class LookupProperties {
    public static final String AUDIT_PRUNE_ENABLED = "dynamiclookup.audit.prune.enabled";
    public static final String AUDIT_PRUNE_RETENTION_DAYS = "dynamiclookup.audit.prune.retentionDays";
    private boolean auditPruneEnabled;
    private int auditPruneRetentionDays;

    public LookupProperties(boolean bl, int n) {
        this.auditPruneEnabled = bl;
        this.auditPruneRetentionDays = n;
    }

    public boolean isAuditPruneEnabled() {
        return this.auditPruneEnabled;
    }

    public void setAuditPruneEnabled(boolean bl) {
        this.auditPruneEnabled = bl;
    }

    public int getAuditPruneRetentionDays() {
        return this.auditPruneRetentionDays;
    }

    public void setAuditPruneRetentionDays(int n) {
        this.auditPruneRetentionDays = n;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty(AUDIT_PRUNE_ENABLED, Boolean.toString(this.auditPruneEnabled));
        properties.setProperty(AUDIT_PRUNE_RETENTION_DAYS, Integer.toString(this.auditPruneRetentionDays));
        return properties;
    }

    public static LookupProperties fromProperties(Properties properties) {
        int n;
        if (properties == null) {
            return LookupProperties.getDefault();
        }
        boolean bl = Boolean.parseBoolean(properties.getProperty(AUDIT_PRUNE_ENABLED, "false"));
        try {
            n = Integer.parseInt(properties.getProperty(AUDIT_PRUNE_RETENTION_DAYS, "30"));
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        return new LookupProperties(bl, n);
    }

    public static LookupProperties getDefault() {
        return new LookupProperties(false, 30);
    }

    private LookupProperties() {
    }
}

