/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.DefaultFileConfiguration;
import com.mirth.connect.connectors.file.FileConfiguration;
import com.mirth.connect.connectors.file.FileConnector;
import com.mirth.connect.connectors.file.FileConnectorException;
import com.mirth.connect.connectors.file.FileDispatcherProperties;
import com.mirth.connect.connectors.file.FileScheme;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.SftpSchemeProperties;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.util.ThreadUtils;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.CharsetUtils;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDispatcher
extends DestinationConnector {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private FileDispatcherProperties connectorProperties;
    private FileConnector fileConnector;
    private String charsetEncoding;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private FileConfiguration configuration = null;

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (FileDispatcherProperties)this.getConnectorProperties();
        String configurationClass = this.configurationController.getProperty(this.connectorProperties.getProtocol(), "fileConfigurationClass");
        try {
            this.configuration = (FileConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Exception e) {
            this.logger.trace("could not find custom configuration class, using default");
            this.configuration = new DefaultFileConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this, (ConnectorProperties)this.connectorProperties);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        this.charsetEncoding = CharsetUtils.getEncoding((String)this.connectorProperties.getCharsetEncoding(), (String)System.getProperty("ca.uhn.hl7v2.llp.charset"));
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
    }

    public void onStop() throws ConnectorTaskException {
        try {
            this.fileConnector.doStop();
        }
        catch (FileConnectorException e) {
            throw new ConnectorTaskException("Failed to stop File Connector", (Throwable)e);
        }
    }

    public void onHalt() throws ConnectorTaskException {
        this.fileConnector.disconnect();
        this.onStop();
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        FileDispatcherProperties fileDispatcherProperties = (FileDispatcherProperties)connectorProperties;
        fileDispatcherProperties.setHost(this.replacer.replaceValues(fileDispatcherProperties.getHost(), connectorMessage));
        fileDispatcherProperties.setOutputPattern(this.replacer.replaceValues(fileDispatcherProperties.getOutputPattern(), connectorMessage));
        fileDispatcherProperties.setUsername(this.replacer.replaceValues(fileDispatcherProperties.getUsername(), connectorMessage));
        fileDispatcherProperties.setPassword(this.replacer.replaceValues(fileDispatcherProperties.getPassword(), connectorMessage));
        fileDispatcherProperties.setTemplate(this.replacer.replaceValues(fileDispatcherProperties.getTemplate(), connectorMessage));
        SchemeProperties schemeProperties = fileDispatcherProperties.getSchemeProperties();
        if (schemeProperties instanceof SftpSchemeProperties) {
            SftpSchemeProperties sftpProperties = (SftpSchemeProperties)schemeProperties;
            sftpProperties.setKeyFile(this.replacer.replaceValues(sftpProperties.getKeyFile(), connectorMessage));
            sftpProperties.setPassPhrase(this.replacer.replaceValues(sftpProperties.getPassPhrase(), connectorMessage));
            sftpProperties.setKnownHostsFile(this.replacer.replaceValues(sftpProperties.getKnownHostsFile(), connectorMessage));
            sftpProperties.setConfigurationSettings(this.replacer.replaceValuesInMap(sftpProperties.getConfigurationSettings(), connectorMessage));
        } else if (schemeProperties instanceof S3SchemeProperties) {
            S3SchemeProperties s3Properties = (S3SchemeProperties)schemeProperties;
            s3Properties.setRegion(this.replacer.replaceValues(s3Properties.getRegion(), connectorMessage));
            s3Properties.setCustomHeaders(this.replacer.replaceKeysAndValuesInMap(s3Properties.getCustomHeaders(), connectorMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) {
        FileDispatcherProperties fileDispatcherProperties = (FileDispatcherProperties)connectorProperties;
        String info = fileDispatcherProperties.getHost() + "/" + fileDispatcherProperties.getOutputPattern();
        if (fileDispatcherProperties.getScheme().equals((Object)FileScheme.FTP) || fileDispatcherProperties.getScheme().equals((Object)FileScheme.SFTP)) {
            info = fileDispatcherProperties.isBinary() ? info + "   File Type: Binary" : info + "   File Type: ASCII";
        }
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.WRITING, "Writing file to: " + info));
        String responseData = null;
        String responseError = null;
        Object responseStatusMessage = null;
        Status responseStatus = Status.QUEUED;
        FileSystemConnection fileSystemConnection = null;
        URI uri = null;
        FileSystemConnectionOptions fileSystemOptions = null;
        ByteArrayInputStream is = null;
        try {
            uri = this.fileConnector.getEndpointURI(fileDispatcherProperties.getHost(), fileDispatcherProperties.getScheme(), fileDispatcherProperties.getSchemeProperties(), fileDispatcherProperties.isSecure());
            String filename = fileDispatcherProperties.getOutputPattern();
            if (filename == null) {
                throw new IOException("Filename is null");
            }
            fileSystemOptions = new FileSystemConnectionOptions(uri, fileDispatcherProperties.isAnonymous(), fileDispatcherProperties.getUsername(), fileDispatcherProperties.getPassword(), fileDispatcherProperties.getSchemeProperties());
            String path = this.fileConnector.getPathPart(uri);
            String template = fileDispatcherProperties.getTemplate();
            byte[] bytes = this.getAttachmentHandlerProvider().reAttachMessage(template, connectorMessage, this.charsetEncoding, fileDispatcherProperties.isBinary(), fileDispatcherProperties.getDestinationConnectorProperties().isReattachAttachments());
            long contentLength = bytes.length;
            is = new ByteArrayInputStream(bytes);
            ThreadUtils.checkInterruptedStatus();
            fileSystemConnection = this.fileConnector.getConnection(fileSystemOptions);
            if (fileDispatcherProperties.isErrorOnExists() && fileSystemConnection.exists(filename, path)) {
                throw new IOException("Destination file already exists, will not overwrite.");
            }
            if (fileDispatcherProperties.isTemporary()) {
                String tempFilename = filename + ".tmp";
                this.logger.debug("writing temp file: " + tempFilename);
                fileSystemConnection.writeFile(tempFilename, path, false, is, contentLength, connectorMessage.getConnectorMap());
                this.logger.debug("renaming temp file: " + filename);
                fileSystemConnection.move(tempFilename, path, filename, path);
            } else {
                fileSystemConnection.writeFile(filename, path, fileDispatcherProperties.isOutputAppend(), is, contentLength, connectorMessage.getConnectorMap());
            }
            responseStatusMessage = "File successfully written: " + fileDispatcherProperties.toURIString();
            responseStatus = Status.SENT;
        }
        catch (Exception e) {
            try {
                this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error writing file", (Throwable)e));
                responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Error writing file", (Throwable)e);
                responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Error writing file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                if (fileSystemConnection != null) {
                    try {
                        if (!fileDispatcherProperties.isKeepConnectionOpen()) {
                            this.fileConnector.destroyConnection(fileSystemConnection, fileSystemOptions);
                        } else {
                            this.fileConnector.releaseConnection(fileSystemConnection, fileSystemOptions);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
                throw throwable;
            }
            IOUtils.closeQuietly(is);
            if (fileSystemConnection != null) {
                try {
                    if (!fileDispatcherProperties.isKeepConnectionOpen()) {
                        this.fileConnector.destroyConnection(fileSystemConnection, fileSystemOptions);
                    } else {
                        this.fileConnector.releaseConnection(fileSystemConnection, fileSystemOptions);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
        IOUtils.closeQuietly((InputStream)is);
        if (fileSystemConnection != null) {
            try {
                if (!fileDispatcherProperties.isKeepConnectionOpen()) {
                    this.fileConnector.destroyConnection(fileSystemConnection, fileSystemOptions);
                } else {
                    this.fileConnector.releaseConnection(fileSystemConnection, fileSystemOptions);
                }
            }
            catch (Exception filename) {
                // empty catch block
            }
        }
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        return new Response(responseStatus, responseData, (String)responseStatusMessage, responseError);
    }

    public void setFileConnector(FileConnector fileConnector) {
        this.fileConnector = fileConnector;
    }
}

