/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.file;

import com.mirth.connect.connectors.file.DefaultFileConfiguration;
import com.mirth.connect.connectors.file.FileAction;
import com.mirth.connect.connectors.file.FileConfiguration;
import com.mirth.connect.connectors.file.FileConnector;
import com.mirth.connect.connectors.file.FileConnectorException;
import com.mirth.connect.connectors.file.FileReceiverProperties;
import com.mirth.connect.connectors.file.FileSystemConnectionOptions;
import com.mirth.connect.connectors.file.S3SchemeProperties;
import com.mirth.connect.connectors.file.SchemeProperties;
import com.mirth.connect.connectors.file.SftpSchemeProperties;
import com.mirth.connect.connectors.file.filesystems.FileInfo;
import com.mirth.connect.connectors.file.filesystems.FileSystemConnection;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.PollConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageSource;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.CharsetUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;

public class FileReceiver
extends PollConnector {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String moveToDirectory = null;
    private String moveToFileName = null;
    private String errorMoveToDirectory = null;
    private String errorMoveToFileName = null;
    private String filenamePattern = null;
    private FileSystemConnectionOptions fileSystemOptions = null;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private FileConfiguration configuration = null;
    private FileConnector fileConnector = null;
    private String originalFilename = null;
    private FileReceiverProperties connectorProperties;
    private String charsetEncoding;
    private long fileSizeMinimum;
    private long fileSizeMaximum;

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (FileReceiverProperties)SerializationUtils.clone((Serializable)this.getConnectorProperties());
        if (this.connectorProperties.isBinary() && this.isProcessBatch()) {
            throw new ConnectorTaskException("Batch processing is not supported for binary data.");
        }
        this.charsetEncoding = CharsetUtils.getEncoding((String)this.connectorProperties.getCharsetEncoding(), (String)System.getProperty("ca.uhn.hl7v2.llp.charset"));
        String configurationClass = this.configurationController.getProperty(this.connectorProperties.getProtocol(), "fileConfigurationClass");
        try {
            this.configuration = (FileConfiguration)Class.forName(configurationClass).newInstance();
        }
        catch (Exception e) {
            this.logger.trace((Object)"could not find custom configuration class, using default");
            this.configuration = new DefaultFileConfiguration();
        }
        try {
            this.configuration.configureConnectorDeploy((Connector)this, (ConnectorProperties)this.connectorProperties);
        }
        catch (Exception e) {
            throw new ConnectorTaskException((Throwable)e);
        }
        this.moveToDirectory = this.connectorProperties.getMoveToDirectory();
        this.moveToFileName = this.connectorProperties.getMoveToFileName();
        this.errorMoveToDirectory = this.connectorProperties.getErrorMoveToDirectory();
        this.errorMoveToFileName = this.connectorProperties.getErrorMoveToFileName();
        this.fileSizeMinimum = NumberUtils.toLong((String)this.connectorProperties.getFileSizeMinimum(), (long)0L);
        this.fileSizeMaximum = NumberUtils.toLong((String)this.connectorProperties.getFileSizeMaximum(), (long)0L);
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
        try {
            String channelId = this.getChannelId();
            String channelName = this.getChannel().getName();
            String username = this.replacer.replaceValues(this.connectorProperties.getUsername(), channelId, channelName);
            String password = this.replacer.replaceValues(this.connectorProperties.getPassword(), channelId, channelName);
            String host = this.replacer.replaceValues(this.connectorProperties.getHost(), channelId, channelName);
            SchemeProperties schemeProperties = null;
            if (this.connectorProperties.getSchemeProperties() != null) {
                schemeProperties = this.connectorProperties.getSchemeProperties().clone();
            }
            if (schemeProperties instanceof SftpSchemeProperties) {
                SftpSchemeProperties sftpProperties = (SftpSchemeProperties)schemeProperties;
                sftpProperties.setKeyFile(this.replacer.replaceValues(sftpProperties.getKeyFile(), channelId, channelName));
                sftpProperties.setPassPhrase(this.replacer.replaceValues(sftpProperties.getPassPhrase(), channelId, channelName));
                sftpProperties.setKnownHostsFile(this.replacer.replaceValues(sftpProperties.getKnownHostsFile(), channelId, channelName));
                sftpProperties.setConfigurationSettings(this.replacer.replaceValues(sftpProperties.getConfigurationSettings(), channelId, channelName));
            } else if (schemeProperties instanceof S3SchemeProperties) {
                S3SchemeProperties s3Properties = (S3SchemeProperties)schemeProperties;
                s3Properties.setRegion(this.replacer.replaceValues(s3Properties.getRegion(), channelId, channelName));
                s3Properties.setCustomHeaders(this.replacer.replaceKeysAndValuesInMap(s3Properties.getCustomHeaders(), channelId, channelName));
            }
            URI uri = this.fileConnector.getEndpointURI(host, this.connectorProperties.getScheme(), schemeProperties, this.connectorProperties.isSecure());
            this.fileSystemOptions = new FileSystemConnectionOptions(uri, this.connectorProperties.isAnonymous(), username, password, schemeProperties);
            FileSystemConnection con = this.fileConnector.getConnection(this.fileSystemOptions);
            this.fileConnector.releaseConnection(con, this.fileSystemOptions);
        }
        catch (URISyntaxException e1) {
            throw new ConnectorTaskException("Error creating URI.", (Throwable)e1);
        }
        catch (Exception e) {
            throw new ConnectorTaskException(e.getMessage(), (Throwable)e);
        }
    }

    public void onStop() throws ConnectorTaskException {
        try {
            this.fileConnector.doStop();
        }
        catch (FileConnectorException e) {
            throw new ConnectorTaskException("Failed to stop File Connector", (Throwable)e);
        }
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
    }

    public void onHalt() throws ConnectorTaskException {
        this.fileConnector.disconnect();
        this.onStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.POLLING));
        try {
            String channelId = this.getChannelId();
            String channelName = this.getChannel().getName();
            String host = this.replacer.replaceValues(this.connectorProperties.getHost(), channelId, channelName);
            String username = this.replacer.replaceValues(this.connectorProperties.getUsername(), channelId, channelName);
            String password = this.replacer.replaceValues(this.connectorProperties.getPassword(), channelId, channelName);
            this.filenamePattern = this.replacer.replaceValues(this.connectorProperties.getFileFilter(), channelId, channelName);
            SchemeProperties schemeProperties = null;
            if (this.connectorProperties.getSchemeProperties() != null) {
                schemeProperties = this.connectorProperties.getSchemeProperties().clone();
            }
            if (schemeProperties instanceof SftpSchemeProperties) {
                SftpSchemeProperties sftpProperties = (SftpSchemeProperties)schemeProperties;
                sftpProperties.setKeyFile(this.replacer.replaceValues(sftpProperties.getKeyFile(), channelId, channelName));
                sftpProperties.setPassPhrase(this.replacer.replaceValues(sftpProperties.getPassPhrase(), channelId, channelName));
                sftpProperties.setKnownHostsFile(this.replacer.replaceValues(sftpProperties.getKnownHostsFile(), channelId, channelName));
                sftpProperties.setConfigurationSettings(this.replacer.replaceValues(sftpProperties.getConfigurationSettings(), channelId, channelName));
            } else if (schemeProperties instanceof S3SchemeProperties) {
                S3SchemeProperties s3Properties = (S3SchemeProperties)schemeProperties;
                s3Properties.setRegion(this.replacer.replaceValues(s3Properties.getRegion(), channelId, channelName));
                s3Properties.setCustomHeaders(this.replacer.replaceKeysAndValuesInMap(s3Properties.getCustomHeaders(), channelId, channelName));
            }
            URI uri = this.fileConnector.getEndpointURI(host, this.connectorProperties.getScheme(), schemeProperties, this.connectorProperties.isSecure());
            String readDir = this.fileConnector.getPathPart(uri);
            this.fileSystemOptions = new FileSystemConnectionOptions(uri, this.connectorProperties.isAnonymous(), username, password, schemeProperties);
            String pollId = "" + System.nanoTime();
            AtomicInteger pollSequenceId = new AtomicInteger(1);
            if (this.connectorProperties.isDirectoryRecursion()) {
                List<FileInfo> files;
                HashSet<String> visitedDirectories = new HashSet<String>();
                Stack<String> directoryStack = new Stack<String>();
                directoryStack.push(readDir);
                List<FileInfo> previousFiles = null;
                while ((files = this.listFilesRecursively(visitedDirectories, directoryStack)) != null) {
                    if (files.isEmpty()) continue;
                    if (previousFiles != null) {
                        this.processFiles(previousFiles, pollId, pollSequenceId, false);
                    }
                    previousFiles = files;
                }
                if (previousFiles != null) {
                    this.processFiles(previousFiles, pollId, pollSequenceId, true);
                }
            } else {
                this.processFiles(this.listFiles(readDir), pollId, pollSequenceId, true);
            }
        }
        catch (Throwable t) {
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), null, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), null, t));
            this.logger.error((Object)("Error polling in channel: " + this.getChannelId()), t);
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
        }
    }

    private List<FileInfo> listFilesRecursively(Set<String> visitedDirectories, Stack<String> directoryStack) throws Exception {
        while (!directoryStack.isEmpty()) {
            String fromDir = directoryStack.pop();
            if (visitedDirectories.contains(fromDir)) continue;
            visitedDirectories.add(fromDir);
            List<String> directories = this.listDirectories(fromDir);
            for (int i = directories.size() - 1; i >= 0; --i) {
                directoryStack.push(directories.get(i));
            }
            return this.listFiles(fromDir);
        }
        return null;
    }

    private void processFiles(List<FileInfo> files, String pollId, AtomicInteger pollSequenceId, boolean recursionComplete) {
        this.sortFiles(files);
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            if (this.isTerminated()) {
                return;
            }
            FileInfo file = files.get(i);
            boolean pollComplete = recursionComplete && i == size - 1;
            boolean fileValid = this.isFileValid(file);
            if (fileValid && recursionComplete && !pollComplete) {
                boolean nextValidFileFound = false;
                for (int j = i + 1; j < size; ++j) {
                    FileInfo nextFile = files.get(j);
                    if (!this.isFileValid(nextFile)) continue;
                    nextValidFileFound = true;
                    break;
                }
                if (!nextValidFileFound) {
                    pollComplete = true;
                }
            }
            if (!fileValid && !pollComplete) continue;
            if (!fileValid) {
                this.logger.warn((Object)("The file " + file.getName() + " may have been modified since being listed by the File Reader. This message will still be processed by the channel, but the file age/size may not be correct with respect to the current File Reader settings."));
            }
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.READING));
            this.processFile(file, pollId, pollSequenceId, pollComplete);
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
            if (pollComplete) break;
        }
    }

    public void sortFiles(List<FileInfo> files) {
        String sortAttribute = this.connectorProperties.getSortBy();
        if (sortAttribute.equals("date")) {
            files.sort(Comparator.comparingLong(FileInfo::getLastModified));
        } else if (sortAttribute.equals("size")) {
            files.sort(Comparator.comparingLong(FileInfo::getSize));
        } else {
            files.sort((file1, file2) -> file1.getName().compareToIgnoreCase(file2.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void processFile(FileInfo file, String pollId, AtomicInteger pollSequenceId, boolean pollComplete) {
        block27: {
            try {
                this.originalFilename = file.getName();
                sourceMap = new HashMap<String, Object>();
                sourceMap.put("originalFilename", this.originalFilename);
                sourceMap.put("fileDirectory", file.getParent());
                sourceMap.put("fileSize", file.getSize());
                sourceMap.put("fileLastModified", file.getLastModified());
                sourceMap.put("pollId", pollId);
                sourceMap.put("pollSequenceId", pollSequenceId.get());
                if (pollComplete) {
                    sourceMap.put("pollComplete", true);
                }
                action = FileAction.NONE;
                errorResponse = false;
                if (file.isDirectory()) break block27;
                if (!file.isReadable() || !file.isFile()) {
                    throw new FileConnectorException("File is not readable.");
                }
                fileProcessedException = null;
                error = false;
                try {
                    response = null;
                    file.populateSourceMap(sourceMap);
                    if (this.isProcessBatch()) {
                        con = this.fileConnector.getConnection(this.fileSystemOptions);
                        in = null;
                        try {
                            in = new InputStreamReader(con.readFile(file.getName(), file.getParent(), sourceMap), this.charsetEncoding);
                            batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader(in), sourceMap);
                            messagesExist = this.dispatchBatchMessage(batchRawMessage, null);
                            if (messagesExist == null || messagesExist.booleanValue()) ** GOTO lbl60
                            this.logger.warn((Object)("File " + this.originalFilename + " was successfully processed, but no messages were dispatched to the channel."));
                        }
                        finally {
                            pollSequenceId.incrementAndGet();
                            if (in != null) {
                                in.close();
                            }
                            con.closeReadFile();
                            this.fileConnector.releaseConnection(con, this.fileSystemOptions);
                        }
                    } else {
                        rawMessage = this.connectorProperties.isBinary() != false ? new RawMessage(this.getBytesFromFile(file, sourceMap)) : new RawMessage(new String(this.getBytesFromFile(file, sourceMap), this.charsetEncoding));
                        rawMessage.setSourceMap(sourceMap);
                        dispatchResult = null;
                        try {
                            dispatchResult = this.dispatchRawMessage(rawMessage);
                        }
                        finally {
                            pollSequenceId.incrementAndGet();
                            this.finishDispatch(dispatchResult);
                        }
                        response = dispatchResult.getSelectedResponse();
                    }
lbl60:
                    // 3 sources

                    errorResponse = response != null && response.getStatus() == Status.ERROR;
                }
                catch (Exception e) {
                    error = true;
                    this.logger.error((Object)("Unable to dispatch message to channel " + this.getChannelId() + ". File: " + file.getAbsolutePath()), (Throwable)e);
                }
                catch (Throwable t) {
                    error = true;
                    errorMessage = "Error reading file " + file.getAbsolutePath() + "\n" + t.getMessage();
                    this.logger.error((Object)errorMessage);
                    fileProcessedException = new FileConnectorException(errorMessage, t);
                }
                shouldUseErrorFields = false;
                if (error) {
                    action = this.connectorProperties.getErrorReadingAction();
                    shouldUseErrorFields = true;
                } else if (errorResponse && this.connectorProperties.getErrorResponseAction() != FileAction.AFTER_PROCESSING) {
                    action = this.connectorProperties.getErrorResponseAction();
                    shouldUseErrorFields = true;
                } else {
                    action = this.connectorProperties.getAfterProcessingAction();
                }
                if (action == FileAction.MOVE) {
                    destinationDir = shouldUseErrorFields != false ? this.errorMoveToDirectory : this.moveToDirectory;
                    destinationName = shouldUseErrorFields != false ? this.errorMoveToFileName : this.moveToFileName;
                    destinationDir = StringUtils.isNotBlank((CharSequence)destinationDir) != false ? this.replacer.replaceValues(destinationDir, this.getChannelId(), this.getChannel().getName(), sourceMap) : file.getParent();
                    destinationName = StringUtils.isNotBlank((CharSequence)destinationName) != false ? this.replacer.replaceValues(destinationName, this.getChannelId(), this.getChannel().getName(), sourceMap) : this.originalFilename;
                    if (!this.filesEqual(file.getParent(), this.originalFilename, destinationDir, destinationName)) {
                        if (shouldUseErrorFields) {
                            this.logger.error((Object)("Moving file to error directory: " + destinationDir));
                        }
                        this.deleteFile(destinationName, destinationDir, true);
                        resultOfFileMoveOperation = this.renameFile(file.getName(), file.getParent(), destinationName, destinationDir);
                        if (!resultOfFileMoveOperation) {
                            throw new FileConnectorException("Error moving file from [" + this.pathname(file.getName(), file.getParent()) + "] to [" + this.pathname(destinationName, destinationDir) + "]");
                        }
                    }
                } else if (action == FileAction.DELETE && !(resultOfFileMoveOperation = this.deleteFile(file.getName(), file.getParent(), false))) {
                    throw new FileConnectorException("Error deleting file from [" + this.pathname(file.getName(), file.getParent()) + "]");
                }
                if (fileProcessedException != null) {
                    throw fileProcessedException;
                }
            }
            catch (Exception e) {
                this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(12345L), ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), "", (Throwable)e));
                this.logger.error((Object)("Error processing file in channel: " + this.getChannelId()), (Throwable)e);
            }
        }
    }

    private boolean filesEqual(String dir1, String name1, String dir2, String name2) {
        String separator = System.getProperty("file.separator");
        String escapedSeparator = StringEscapeUtils.escapeJava((String)separator);
        String file1 = dir1 + (dir1.endsWith(separator) ? "" : separator) + name1.replaceAll("^" + escapedSeparator, "");
        String file2 = dir2 + (dir2.endsWith(separator) ? "" : separator) + name2.replaceAll("^" + escapedSeparator, "");
        try {
            return new File(file1).getCanonicalPath().equals(new File(file2).getCanonicalPath());
        }
        catch (IOException e) {
            return file1.equals(file2);
        }
    }

    private String pathname(String name, String dir) {
        if (dir != null && dir.length() > 0) {
            return dir + "/" + name;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteFile(String name, String dir, boolean mayNotExist) throws Exception {
        FileSystemConnection con = this.fileConnector.getConnection(this.fileSystemOptions);
        try {
            con.delete(name, dir, mayNotExist);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (mayNotExist) {
                boolean bl = true;
                return bl;
            }
            this.logger.info((Object)"Unable to delete destination file");
            boolean bl = false;
            return bl;
        }
        finally {
            this.fileConnector.releaseConnection(con, this.fileSystemOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renameFile(String fromName, String fromDir, String toName, String toDir) throws Exception {
        FileSystemConnection con = this.fileConnector.getConnection(this.fileSystemOptions);
        try {
            con.move(fromName, fromDir, toName, toDir);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.fileConnector.releaseConnection(con, this.fileSystemOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromFile(FileInfo file, Map<String, Object> sourceMap) throws Exception {
        FileSystemConnection con = this.fileConnector.getConnection(this.fileSystemOptions);
        try {
            byte[] byArray;
            block10: {
                InputStream is = null;
                try {
                    int offset;
                    is = con.readFile(file.getName(), file.getParent(), sourceMap);
                    long length = file.getSize();
                    if (length > Integer.MAX_VALUE) {
                        throw new IOException("File " + file.getName() + " is too large. Unable to read files greater than 2147483647 bytes.");
                    }
                    byte[] bytes = new byte[(int)length];
                    int numRead = 0;
                    for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                    }
                    if (offset < bytes.length) {
                        throw new IOException("Could not completely read file " + file.getName());
                    }
                    con.closeReadFile();
                    byArray = bytes;
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                is.close();
            }
            return byArray;
        }
        finally {
            this.fileConnector.releaseConnection(con, this.fileSystemOptions);
        }
    }

    boolean isFileValid(FileInfo file) {
        long fileSize;
        if (file.isDirectory() || !file.isReadable() || !file.isFile()) {
            return false;
        }
        boolean checkFileAge = this.connectorProperties.isCheckFileAge();
        if (checkFileAge) {
            long fileAge = Long.valueOf(this.connectorProperties.getFileAge());
            long lastMod = file.getLastModified();
            long now = System.currentTimeMillis();
            if (now - lastMod < fileAge) {
                return false;
            }
        }
        if ((fileSize = file.getSize()) < this.fileSizeMinimum) {
            return false;
        }
        return this.connectorProperties.isIgnoreFileSizeMaximum() || fileSize <= this.fileSizeMaximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FileInfo> listFiles(String fromDir) throws Exception {
        FileSystemConnection con = this.fileConnector.getConnection(this.fileSystemOptions);
        try {
            ArrayList<FileInfo> files = con.listFiles(fromDir, this.filenamePattern, this.connectorProperties.isRegex(), this.connectorProperties.isIgnoreDot());
            if (files != null) {
                Iterator<FileInfo> it = files.iterator();
                while (it.hasNext()) {
                    if (this.isFileValid(it.next())) continue;
                    it.remove();
                }
            }
            ArrayList<FileInfo> arrayList = CollectionUtils.isNotEmpty(files) ? files : new ArrayList<FileInfo>();
            return arrayList;
        }
        finally {
            this.fileConnector.releaseConnection(con, this.fileSystemOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> listDirectories(String fromDir) throws Exception {
        FileSystemConnection con = this.fileConnector.getConnection(this.fileSystemOptions);
        try {
            List<String> list = con.listDirectories(fromDir);
            return list;
        }
        finally {
            this.fileConnector.releaseConnection(con, this.fileSystemOptions);
        }
    }

    public void handleRecoveredResponse(DispatchResult dispatchResult) {
        this.finishDispatch(dispatchResult);
    }

    public void setFileConnector(FileConnector fileConnector) {
        this.fileConnector = fileConnector;
    }
}

