/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.connectors.jms.JmsDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.util.BeanUtil;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JmsDispatcher
extends DestinationConnector {
    private JmsDispatcherProperties connectorProperties;
    private TemplateValueReplacer replacer = new TemplateValueReplacer();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Map<String, JmsConnection> jmsConnections = new ConcurrentHashMap<String, JmsConnection>();
    private static final int maxConnections = 1000;

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (JmsDispatcherProperties)this.getConnectorProperties();
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() throws ConnectorTaskException {
    }

    public void onStart() throws ConnectorTaskException {
    }

    public void onStop() throws ConnectorTaskException {
        ConnectorTaskException firstCause = null;
        for (String connectorKey : this.jmsConnections.keySet().toArray(new String[this.jmsConnections.size()])) {
            try {
                this.closeJmsConnection(connectorKey);
            }
            catch (Exception e) {
                if (firstCause != null) continue;
                firstCause = new ConnectorTaskException("Error closing JMS connection (" + this.connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", firstCause);
            }
        }
        if (firstCause != null) {
            throw firstCause;
        }
    }

    public void onHalt() throws ConnectorTaskException {
        this.onStop();
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage message) {
        JmsDispatcherProperties jmsDispatcherProperties = (JmsDispatcherProperties)connectorProperties;
        jmsDispatcherProperties.setTemplate(this.replacer.replaceValues(jmsDispatcherProperties.getTemplate(), message));
        jmsDispatcherProperties.setDestinationName(this.replacer.replaceValues(jmsDispatcherProperties.getDestinationName(), message));
        jmsDispatcherProperties.setConnectionProperties(this.replacer.replaceValuesInMap(jmsDispatcherProperties.getConnectionProperties(), message));
        jmsDispatcherProperties.setUsername(this.replacer.replaceValues(jmsDispatcherProperties.getUsername(), message));
        jmsDispatcherProperties.setPassword(this.replacer.replaceValues(jmsDispatcherProperties.getPassword(), message));
        jmsDispatcherProperties.setClientId(this.replacer.replaceValues(jmsDispatcherProperties.getClientId(), message));
        if (jmsDispatcherProperties.isUseJndi()) {
            jmsDispatcherProperties.setJndiProviderUrl(this.replacer.replaceValues(jmsDispatcherProperties.getJndiProviderUrl(), message));
            jmsDispatcherProperties.setJndiInitialContextFactory(this.replacer.replaceValues(jmsDispatcherProperties.getJndiInitialContextFactory(), message));
            jmsDispatcherProperties.setJndiConnectionFactoryName(this.replacer.replaceValues(jmsDispatcherProperties.getJndiConnectionFactoryName(), message));
        } else {
            jmsDispatcherProperties.setConnectionFactoryClass(this.replacer.replaceValues(jmsDispatcherProperties.getConnectionFactoryClass(), message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(ConnectorProperties connectorProperties, ConnectorMessage connectorMessage) throws InterruptedException {
        Status responseStatus;
        String responseStatusMessage;
        String responseError;
        block13: {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.SENDING));
            JmsDispatcherProperties jmsDispatcherProperties = (JmsDispatcherProperties)connectorProperties;
            responseError = null;
            responseStatusMessage = "Message sent successfully.";
            responseStatus = Status.SENT;
            boolean connectionCreated = false;
            long dispatcherId = connectorMessage.getDispatcherId();
            String connectionKey = this.getConnectionKey(jmsDispatcherProperties);
            JmsConnection jmsConnection = this.jmsConnections.get(connectionKey);
            try {
                try {
                    if (jmsConnection == null) {
                        connectionCreated = true;
                        jmsConnection = this.getJmsConnection(jmsDispatcherProperties, connectionKey, dispatcherId, false);
                    }
                    JmsSession jmsSession = this.getJmsSession(jmsConnection, dispatcherId);
                    jmsSession.getProducer().send(this.getDestination(jmsDispatcherProperties, jmsSession, jmsConnection.getInitialContext()), (Message)jmsSession.getSession().createTextMessage(jmsDispatcherProperties.getTemplate()));
                }
                catch (Exception e) {
                    if (!connectionCreated) {
                        jmsConnection = this.getJmsConnection(jmsDispatcherProperties, connectionKey, dispatcherId, true);
                        JmsSession jmsSession = this.getJmsSession(jmsConnection, dispatcherId);
                        jmsSession.getProducer().send(this.getDestination(jmsDispatcherProperties, jmsSession, jmsConnection.getInitialContext()), (Message)jmsSession.getSession().createTextMessage(jmsDispatcherProperties.getTemplate()));
                        break block13;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                String logMessage = "An error occurred in channel \"" + ChannelController.getInstance().getDeployedChannelById(this.getChannelId()).getName() + "\": " + e.getMessage();
                if (this.isQueueEnabled()) {
                    this.logger.warn(logMessage, ExceptionUtils.getRootCause((Throwable)e));
                } else {
                    this.logger.error(logMessage, ExceptionUtils.getRootCause((Throwable)e));
                }
                this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(connectorMessage.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error occurred when attempting to send JMS message.", (Throwable)e));
                responseStatus = Status.QUEUED;
                responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Error occurred when attempting to send JMS message.", (Throwable)e);
                responseError = ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Error occurred when attempting to send JMS message.", (Throwable)e);
            }
            finally {
                this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
            }
        }
        return new Response(responseStatus, null, responseStatusMessage, responseError);
    }

    private String getConnectionKey(JmsDispatcherProperties jmsDispatcherProperties) {
        char delimiter = ':';
        StringBuilder builder = new StringBuilder();
        builder.append(jmsDispatcherProperties.isUseJndi());
        if (jmsDispatcherProperties.isUseJndi()) {
            builder.append(delimiter);
            builder.append(jmsDispatcherProperties.getJndiProviderUrl());
            builder.append(delimiter);
            builder.append(jmsDispatcherProperties.getJndiInitialContextFactory());
            builder.append(delimiter);
            builder.append(jmsDispatcherProperties.getJndiConnectionFactoryName());
        } else {
            builder.append(delimiter);
            builder.append(jmsDispatcherProperties.getConnectionFactoryClass());
            builder.append(delimiter);
            builder.append(jmsDispatcherProperties.isTopic());
        }
        for (String value : jmsDispatcherProperties.getConnectionProperties().values()) {
            builder.append(value);
        }
        builder.append(delimiter);
        builder.append(jmsDispatcherProperties.getUsername());
        builder.append(delimiter);
        builder.append(jmsDispatcherProperties.getPassword());
        builder.append(delimiter);
        builder.append(jmsDispatcherProperties.getClientId());
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized JmsConnection getJmsConnection(JmsDispatcherProperties jmsDispatcherProperties, String connectionKey, Long dispatcherId, boolean replace) throws Exception {
        JmsConnection jmsConnection;
        if (replace) {
            this.closeJmsConnectionQuietly(connectionKey);
        }
        if ((jmsConnection = this.jmsConnections.get(connectionKey)) == null) {
            if (this.jmsConnections.size() >= 1000) {
                throw new Exception("Cannot create new connection. Maximum number (1000) of cached connections reached.");
            }
            Context initialContext = null;
            ConnectionFactory connectionFactory = null;
            Connection connection = null;
            Map connectionProperties = jmsDispatcherProperties.getConnectionProperties();
            if (jmsDispatcherProperties.isUseJndi()) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    MirthContextFactory contextFactory = this.contextFactoryController.getContextFactory(this.getResourceIds());
                    Thread.currentThread().setContextClassLoader(contextFactory.getApplicationClassLoader());
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.provider.url", jmsDispatcherProperties.getJndiProviderUrl());
                    env.put("java.naming.factory.initial", jmsDispatcherProperties.getJndiInitialContextFactory());
                    env.put("java.naming.security.principal", jmsDispatcherProperties.getUsername());
                    env.put("java.naming.security.credentials", jmsDispatcherProperties.getPassword());
                    initialContext = new InitialContext(env);
                    String connectionFactoryName = jmsDispatcherProperties.getJndiConnectionFactoryName();
                    connectionFactory = (ConnectionFactory)initialContext.lookup(connectionFactoryName);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            } else {
                String className = jmsDispatcherProperties.getConnectionFactoryClass();
                MirthContextFactory contextFactory = this.contextFactoryController.getContextFactory(this.getResourceIds());
                connectionFactory = (ConnectionFactory)Class.forName(className, true, contextFactory.getApplicationClassLoader()).newInstance();
            }
            BeanUtil.setProperties((Object)connectionFactory, (Map)connectionProperties);
            try {
                this.logger.debug("Creating JMS connection and session");
                connection = connectionFactory.createConnection(jmsDispatcherProperties.getUsername(), jmsDispatcherProperties.getPassword());
                String clientId = jmsDispatcherProperties.getClientId();
                if (!clientId.isEmpty()) {
                    connection.setClientID(clientId);
                }
                this.logger.debug("Starting JMS connection");
                connection.start();
            }
            catch (JMSException e) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e1) {
                    this.logger.debug("Failed to close JMS connection.", (Throwable)e);
                }
                try {
                    if (initialContext != null) {
                        initialContext.close();
                    }
                }
                catch (Exception e1) {
                    this.logger.debug("Failed to close initial context.", (Throwable)e);
                }
                throw e;
            }
            jmsConnection = new JmsConnection(connection, initialContext);
            this.jmsConnections.put(connectionKey, jmsConnection);
        }
        return jmsConnection;
    }

    private JmsSession getJmsSession(JmsConnection jmsConnection, Long dispatcherId) throws Exception {
        Map<Long, JmsSession> jmsSessions = jmsConnection.getJmsSessions();
        JmsSession jmsSession = jmsSessions.get(dispatcherId);
        if (jmsSession == null) {
            Session session = jmsConnection.getConnection().createSession(false, 2);
            MessageProducer producer = session.createProducer(null);
            jmsSession = new JmsSession(session, producer);
            jmsSessions.put(dispatcherId, jmsSession);
        }
        return jmsSession;
    }

    private void closeJmsConnectionQuietly(String connectionKey) {
        try {
            this.closeJmsConnection(connectionKey);
        }
        catch (Exception e) {
            this.logger.debug("Error closing JMS connection on channel " + this.getChannelId(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeJmsConnection(String connectionKey) throws Exception {
        JmsConnection jmsConnection = this.jmsConnections.get(connectionKey);
        if (jmsConnection != null) {
            try {
                Context initialContext;
                Throwable firstException = null;
                Connection connection = jmsConnection.getConnection();
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException e) {
                        firstException = e;
                        this.logger.debug("Failed to close the JMS connection", (Throwable)e);
                    }
                }
                if ((initialContext = jmsConnection.getInitialContext()) != null) {
                    try {
                        initialContext.close();
                    }
                    catch (NamingException e) {
                        if (firstException == null) {
                            firstException = e;
                        }
                        this.logger.debug("Failed to close the initial context", (Throwable)e);
                    }
                    initialContext = null;
                }
                if (firstException != null) {
                    throw firstException;
                }
            }
            finally {
                this.jmsConnections.remove(connectionKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(JmsDispatcherProperties jmsDispatcherProperties, JmsSession jmsSession, Context initialContext) throws Exception {
        try {
            String destinationName = jmsDispatcherProperties.getDestinationName();
            if (destinationName.equals(jmsSession.getDestinationName())) {
                return jmsSession.getDestination();
            }
            jmsSession.setDestinationName(destinationName);
            if (jmsDispatcherProperties.isUseJndi()) {
                Context context = initialContext;
                synchronized (context) {
                    jmsSession.setDestination((Destination)initialContext.lookup(destinationName));
                }
            } else if (jmsDispatcherProperties.isTopic()) {
                jmsSession.setDestination((Destination)jmsSession.getSession().createTopic(destinationName));
                this.logger.debug("Connected to topic: " + destinationName);
            } else {
                jmsSession.setDestination((Destination)jmsSession.getSession().createQueue(destinationName));
                this.logger.debug("Connected to queue: " + destinationName);
            }
            return jmsSession.getDestination();
        }
        catch (Exception e) {
            jmsSession.setDestination(null);
            jmsSession.setDestinationName(null);
            throw e;
        }
    }

    private class JmsConnection {
        private Connection connection;
        private Context initialContext;
        private Map<Long, JmsSession> jmsSessions = new ConcurrentHashMap<Long, JmsSession>();

        public JmsConnection(Connection connection, Context initialContext) {
            this.connection = connection;
            this.initialContext = initialContext;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Context getInitialContext() {
            return this.initialContext;
        }

        public Map<Long, JmsSession> getJmsSessions() {
            return this.jmsSessions;
        }
    }

    private class JmsSession {
        private Session session;
        private MessageProducer producer;
        private String destinationName;
        private Destination destination;

        public JmsSession(Session session, MessageProducer producer) {
            this.session = session;
            this.producer = producer;
        }

        public Session getSession() {
            return this.session;
        }

        public MessageProducer getProducer() {
            return this.producer;
        }

        public String getDestinationName() {
            return this.destinationName;
        }

        public void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public Destination getDestination() {
            return this.destination;
        }

        public void setDestination(Destination destination) {
            this.destination = destination;
        }
    }
}

