/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jms;

import com.mirth.connect.connectors.jms.JmsClient;
import com.mirth.connect.connectors.jms.JmsReceiverProperties;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.ChannelException;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DispatchResult;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageSource;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.TemplateValueReplacer;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JmsReceiver
extends SourceConnector {
    private JmsClient jmsClient;
    private JmsReceiverProperties connectorProperties;
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public void onDeploy() throws ConnectorTaskException {
        this.connectorProperties = (JmsReceiverProperties)this.getConnectorProperties();
        this.jmsClient = new JmsClient((Connector)this, this.connectorProperties, this.getSourceName());
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.IDLE));
    }

    public void onUndeploy() {
    }

    public void onStart() throws ConnectorTaskException {
        this.jmsClient.start();
        TemplateValueReplacer replacer = new TemplateValueReplacer();
        String channelId = this.getChannelId();
        String channelName = this.getChannel().getName();
        String destinationName = replacer.replaceValues(this.connectorProperties.getDestinationName(), channelId, channelName);
        try {
            Destination destination = this.jmsClient.getDestination(destinationName);
            String selector = replacer.replaceValues(this.connectorProperties.getSelector(), channelId, channelName);
            Object consumer = this.connectorProperties.isTopic() && this.connectorProperties.isDurableTopic() ? this.jmsClient.getSession().createDurableSubscriber((Topic)destination, this.connectorProperties.getClientId(), selector, true) : this.jmsClient.getSession().createConsumer(destination, selector, true);
            consumer.setMessageListener((MessageListener)new JmsReceiverMessageListener());
            this.logger.debug("Message consumer created");
        }
        catch (Exception e) {
            try {
                this.jmsClient.stop();
            }
            catch (Exception e1) {
                this.logger.error((Object)e1);
            }
            throw new ConnectorTaskException("Failed to initialize JMS message consumer for destination \"" + destinationName + "\"", (Throwable)e);
        }
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.CONNECTED));
    }

    public void onStop() throws ConnectorTaskException {
        try {
            this.jmsClient.stop();
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Failed to close JMS connection", (Throwable)e);
        }
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getSourceName(), ConnectionStatusEventType.DISCONNECTED));
    }

    public void onHalt() throws ConnectorTaskException {
        this.onStop();
    }

    public void handleRecoveredResponse(DispatchResult dispatchResult) {
        this.finishDispatch(dispatchResult);
    }

    private void reportError(String errorMessage, Long messageId, Exception e) {
        this.logger.error(errorMessage + " (channel: " + ChannelController.getInstance().getDeployedChannelById(this.getChannelId()).getName() + ")", (Throwable)e);
        this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), messageId, ErrorEventType.SOURCE_CONNECTOR, this.getSourceName(), this.connectorProperties.getName(), null, e.getCause()));
    }

    private class JmsReceiverMessageListener
    implements MessageListener {
        private JmsReceiverMessageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            block20: {
                Long messageId = null;
                RawMessage rawMessage = null;
                DispatchResult dispatchResult = null;
                JmsReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(JmsReceiver.this.getChannelId(), Integer.valueOf(JmsReceiver.this.getMetaDataId()), JmsReceiver.this.getSourceName(), ConnectionStatusEventType.RECEIVING));
                String originalThreadName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName("JMS Receiver Thread on " + JmsReceiver.this.getChannel().getName() + " (" + JmsReceiver.this.getChannelId() + ") < " + originalThreadName);
                    try {
                        rawMessage = this.jmsMessageToRawMessage(message);
                        messageId = rawMessage.getOriginalMessageId();
                    }
                    catch (Exception e) {
                        JmsReceiver.this.reportError("Failed to read JMS message", messageId, e);
                        JmsReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(JmsReceiver.this.getChannelId(), Integer.valueOf(JmsReceiver.this.getMetaDataId()), JmsReceiver.this.getSourceName(), ConnectionStatusEventType.IDLE));
                        Thread.currentThread().setName(originalThreadName);
                        return;
                    }
                    if (JmsReceiver.this.isProcessBatch()) {
                        if (rawMessage.isBinary().booleanValue()) {
                            JmsReceiver.this.reportError("Batch processing is not supported for binary data.", messageId, (Exception)((Object)new BatchMessageException("Batch processing is not supported for binary data.")));
                            return;
                        }
                        BatchRawMessage batchRawMessage = new BatchRawMessage((BatchMessageSource)new BatchMessageReader(rawMessage.getRawData()), rawMessage.getSourceMap());
                        rawMessage = null;
                        try {
                            JmsReceiver.this.dispatchBatchMessage(batchRawMessage, null);
                            try {
                                message.acknowledge();
                                break block20;
                            }
                            catch (JMSException e) {
                                JmsReceiver.this.reportError("Failed to acknowledge JMS message", messageId, (Exception)((Object)e));
                            }
                        }
                        catch (BatchMessageException e) {
                            JmsReceiver.this.reportError("Failed to process batch message", messageId, (Exception)((Object)e));
                        }
                        break block20;
                    }
                    try {
                        dispatchResult = JmsReceiver.this.dispatchRawMessage(rawMessage);
                        dispatchResult.setAttemptedResponse(true);
                        try {
                            message.acknowledge();
                        }
                        catch (JMSException e) {
                            JmsReceiver.this.reportError("Failed to acknowledge JMS message", messageId, (Exception)((Object)e));
                            dispatchResult.setResponseError("Failed to acknowledge message: " + e.getMessage());
                        }
                    }
                    catch (ChannelException e) {
                        JmsReceiver.this.reportError("Failed to process message", messageId, (Exception)((Object)e));
                    }
                    finally {
                        JmsReceiver.this.finishDispatch(dispatchResult);
                    }
                }
                finally {
                    JmsReceiver.this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(JmsReceiver.this.getChannelId(), Integer.valueOf(JmsReceiver.this.getMetaDataId()), JmsReceiver.this.getSourceName(), ConnectionStatusEventType.IDLE));
                    Thread.currentThread().setName(originalThreadName);
                }
            }
        }

        private RawMessage jmsMessageToRawMessage(Message message) throws JMSException, IOException {
            if (message instanceof TextMessage) {
                return new RawMessage(((TextMessage)message).getText());
            }
            if (message instanceof BytesMessage) {
                return this.bytesMessageToRawMessage((BytesMessage)message);
            }
            if (message instanceof ObjectMessage) {
                return new RawMessage(((ObjectMessage)message).getObject().toString());
            }
            return new RawMessage(message.toString());
        }

        private RawMessage bytesMessageToRawMessage(BytesMessage message) throws JMSException, IOException {
            int numBytesRead;
            BytesMessage bytesMessage = message;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int bufferSize = 10240;
            do {
                byte[] buffer;
                if ((numBytesRead = bytesMessage.readBytes(buffer = new byte[10240], 10240)) <= 0) continue;
                outputStream.write(buffer);
            } while (numBytesRead > 0);
            return new RawMessage(outputStream.toByteArray());
        }
    }
}

