/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.core.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.MirthOperation;
import com.mirth.connect.client.core.api.Param;
import com.mirth.connect.model.DatabaseTask;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/databaseTasks")
@Tag(name="Database Tasks")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public interface DatabaseTaskServletInterface
extends BaseServletInterface {
    @GET
    @Path(value="/")
    @Operation(summary="Retrieves all current database tasks.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="database_task_map", ref="../apiexamples/database_task_map_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="database_task_map", ref="../apiexamples/database_task_map_json")})})
    @MirthOperation(name="getDatabaseTasks", display="Get database tasks", permission="viewDatabaseTasks")
    public Map<String, DatabaseTask> getDatabaseTasks() throws ClientException;

    @GET
    @Path(value="/{databaseTaskId}")
    @Operation(summary="Retrieves a single database task.")
    @ApiResponse(content={@Content(mediaType="application/xml", examples={@ExampleObject(name="database_task", ref="../apiexamples/database_task_xml")}), @Content(mediaType="application/json", examples={@ExampleObject(name="database_task", ref="../apiexamples/database_task_json")})})
    @MirthOperation(name="getDatabaseTask", display="Get database task", permission="viewDatabaseTasks")
    public DatabaseTask getDatabaseTask(@Param(value="databaseTaskId") @Parameter(description="The ID of the database task.", required=true) @PathParam(value="databaseTaskId") String var1) throws ClientException;

    @POST
    @Path(value="/{databaseTaskId}/_run")
    @Produces(value={"text/plain"})
    @Operation(summary="Executes the specified database task.")
    @ApiResponse(content={@Content(mediaType="text/plain", examples={@ExampleObject(value="Table SOME_TABLE successfully dropped.")})})
    @MirthOperation(name="runDatabaseTask", display="Run database task", permission="manageDatabaseTasks")
    public String runDatabaseTask(@Param(value="databaseTaskId") @Parameter(description="The ID of the database task.", required=true) @PathParam(value="databaseTaskId") String var1) throws ClientException;

    @POST
    @Path(value="/{databaseTaskId}/_cancel")
    @Operation(summary="Cancels execution of the specified database task.")
    @MirthOperation(name="cancelDatabaseTask", display="Cancel database task", permission="manageDatabaseTasks")
    public void cancelDatabaseTask(@Param(value="databaseTaskId") @Parameter(description="The ID of the database task.", required=true) @PathParam(value="databaseTaskId") String var1) throws ClientException;
}

