/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.Cacheable;
import com.mirth.connect.model.Channel;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

@XStreamAlias(value="channelGroup")
public class ChannelGroup
implements Serializable,
Migratable,
Purgable,
Cacheable<ChannelGroup> {
    public static final String DEFAULT_ID = "Default Group";
    public static final String DEFAULT_NAME = "[Default Group]";
    private String id;
    private String name;
    private Integer revision;
    private Calendar lastModified;
    private String description;
    private List<Channel> channels;

    public ChannelGroup() {
        this("", "");
    }

    public ChannelGroup(String name, String description) {
        this(UUID.randomUUID().toString(), name, description);
    }

    public ChannelGroup(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.revision = 1;
        this.lastModified = Calendar.getInstance();
        this.description = description;
        this.channels = new ArrayList<Channel>();
    }

    public ChannelGroup(ChannelGroup group) {
        this.id = group.getId();
        this.name = group.getName();
        this.revision = group.getRevision();
        this.lastModified = group.getLastModified();
        this.description = group.getDescription();
        this.channels = new ArrayList<Channel>();
        for (Channel channel : group.getChannels()) {
            this.channels.add(new Channel(channel.getId()));
        }
    }

    public static ChannelGroup getDefaultGroup() {
        ChannelGroup defaultGroup = new ChannelGroup(DEFAULT_ID, DEFAULT_NAME, "Channels not part of a group will appear here.");
        defaultGroup.setRevision(null);
        defaultGroup.setLastModified(null);
        return defaultGroup;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public void replaceChannelsWithIds() {
        if (CollectionUtils.isNotEmpty(this.channels)) {
            ArrayList<Channel> list = new ArrayList<Channel>();
            for (Channel channel : this.channels) {
                list.add(new Channel(channel.getId()));
            }
            this.channels = list;
        }
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("id", this.id);
        purgedProperties.put("nameChars", PurgeUtil.countChars((String)this.name));
        purgedProperties.put("descriptionChars", PurgeUtil.countChars((String)this.description));
        purgedProperties.put("lastModified", this.lastModified);
        purgedProperties.put("channelCount", this.channels.size());
        return purgedProperties;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false, null, (String[])new String[]{"DEFAULT_ID", "DEFAULT_NAME"});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append('[');
        builder.append("id=").append(this.id).append(", ");
        builder.append("name=").append(this.name).append(", ");
        builder.append("revision=").append(this.revision).append(", ");
        builder.append("lastModified=").append(this.lastModified).append(", ");
        builder.append("description=").append(this.description).append(']');
        return builder.toString();
    }

    @Override
    public ChannelGroup cloneIfNeeded() {
        return new ChannelGroup(this);
    }
}

