/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.model.AbstractSettings;
import com.mirth.connect.model.Auditable;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.math.NumberUtils;

@XStreamAlias(value="databaseSettings")
public class DatabaseSettings
extends AbstractSettings
implements Serializable,
Auditable {
    private static final long serialVersionUID = 1L;
    public static final String DIR_BASE = "dir.base";
    public static final int DEFAULT_MAX_CONNECTIONS = 20;
    public static final int DEFAULT_MAX_RETRY = 2;
    public static final int DEFAULT_MAX_RETRY_WAIT_TIME = 10000;
    private static Map<String, String> databaseDriverMap = null;
    private static Map<String, Boolean> databaseJdbc4Map = null;
    private static Map<String, String> databaseTestQueryMap = null;
    private boolean splitReadWrite;
    private boolean writePoolCache;
    private String database;
    private String databaseUrl;
    private String databaseDriver;
    private String databaseUsername;
    private String databasePassword;
    private Integer databaseMaxConnections;
    private String databasePool;
    private String databaseReadOnly;
    private String databaseReadOnlyUrl;
    private String databaseReadOnlyDriver;
    private String databaseReadOnlyUsername;
    private String databaseReadOnlyPassword;
    private Integer databaseReadOnlyMaxConnections;
    private Integer databaseConnectionMaxRetry;
    private Integer databaseConnectionMaxRetryWaitTimeInMs;
    private String databaseReadOnlyPool;
    private String dirBase;

    public DatabaseSettings() {
    }

    public DatabaseSettings(Properties properties) {
        this.setProperties(properties);
    }

    public boolean isSplitReadWrite() {
        return this.splitReadWrite;
    }

    public void setSplitReadWrite(boolean splitReadWrite) {
        this.splitReadWrite = splitReadWrite;
    }

    public boolean isWritePoolCache() {
        return this.writePoolCache;
    }

    public void setWritePoolCache(boolean writePoolCache) {
        this.writePoolCache = writePoolCache;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(String databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public Integer getDatabaseMaxConnections() {
        return this.databaseMaxConnections;
    }

    public void setDatabaseMaxConnections(Integer databaseMaxConnections) {
        this.databaseMaxConnections = databaseMaxConnections;
    }

    public String getDatabasePool() {
        return this.databasePool;
    }

    public void setDatabasePool(String databasePool) {
        this.databasePool = databasePool;
    }

    public String getDatabaseReadOnly() {
        return this.databaseReadOnly;
    }

    public void setDatabaseReadOnly(String databaseReadOnly) {
        this.databaseReadOnly = databaseReadOnly;
    }

    public String getDatabaseReadOnlyUrl() {
        return this.databaseReadOnlyUrl;
    }

    public void setDatabaseReadOnlyUrl(String databaseReadOnlyUrl) {
        this.databaseReadOnlyUrl = databaseReadOnlyUrl;
    }

    public String getDatabaseReadOnlyDriver() {
        return this.databaseReadOnlyDriver;
    }

    public void setDatabaseReadOnlyDriver(String databaseReadOnlyDriver) {
        this.databaseReadOnlyDriver = databaseReadOnlyDriver;
    }

    public String getDatabaseReadOnlyUsername() {
        return this.databaseReadOnlyUsername;
    }

    public void setDatabaseReadOnlyUsername(String databaseReadOnlyUsername) {
        this.databaseReadOnlyUsername = databaseReadOnlyUsername;
    }

    public String getDatabaseReadOnlyPassword() {
        return this.databaseReadOnlyPassword;
    }

    public void setDatabaseReadOnlyPassword(String databaseReadOnlyPassword) {
        this.databaseReadOnlyPassword = databaseReadOnlyPassword;
    }

    public Integer getDatabaseReadOnlyMaxConnections() {
        return this.databaseReadOnlyMaxConnections;
    }

    public void setDatabaseReadOnlyMaxConnections(Integer databaseReadOnlyMaxConnections) {
        this.databaseReadOnlyMaxConnections = databaseReadOnlyMaxConnections;
    }

    public String getDatabaseReadOnlyPool() {
        return this.databaseReadOnlyPool;
    }

    public void setDatabaseReadOnlyPool(String databaseReadOnlyPool) {
        this.databaseReadOnlyPool = databaseReadOnlyPool;
    }

    public String getDirBase() {
        return this.dirBase;
    }

    public void setDirBase(String dirBase) {
        this.dirBase = dirBase;
    }

    public Integer getDatabaseConnectionMaxRetry() {
        return this.databaseConnectionMaxRetry;
    }

    public void setDatabaseConnectionMaxRetry(Integer databaseConnectionMaxRetry) {
        this.databaseConnectionMaxRetry = databaseConnectionMaxRetry;
    }

    public Integer getDatabaseConnectionMaxRetryWaitTimeInMs() {
        return this.databaseConnectionMaxRetryWaitTimeInMs;
    }

    public void setDatabaseConnectionMaxRetryWaitTimeInMs(Integer databaseConnectionMaxRetryWaitTimeInMs) {
        this.databaseConnectionMaxRetryWaitTimeInMs = databaseConnectionMaxRetryWaitTimeInMs;
    }

    String getMappedDatabaseDriver() {
        if (StringUtils.isBlank((CharSequence)this.databaseDriver)) {
            return MapUtils.getString(databaseDriverMap, (Object)this.getDatabase());
        }
        return this.databaseDriver;
    }

    String getMappedReadOnlyDatabaseDriver() {
        if (StringUtils.isBlank((CharSequence)this.databaseReadOnlyDriver)) {
            if (StringUtils.isNotBlank((CharSequence)this.getDatabaseReadOnly()) && !StringUtils.equalsIgnoreCase((CharSequence)this.getDatabase(), (CharSequence)this.getDatabaseReadOnly())) {
                return MapUtils.getString(databaseDriverMap, (Object)this.getDatabaseReadOnly());
            }
            return this.getMappedDatabaseDriver();
        }
        return this.databaseReadOnlyDriver;
    }

    private Boolean getMappedJdbc4() {
        return MapUtils.getBoolean(databaseJdbc4Map, (Object)this.getDatabase());
    }

    private Boolean getMappedReadOnlyJdbc4() {
        return MapUtils.getBoolean(databaseJdbc4Map, (Object)((String)StringUtils.defaultIfBlank((CharSequence)this.getDatabaseReadOnly(), (CharSequence)this.getDatabase())));
    }

    private String getMappedTestQuery() {
        return MapUtils.getString(databaseTestQueryMap, (Object)this.getDatabase());
    }

    private String getMappedReadOnlyTestQuery() {
        return MapUtils.getString(databaseTestQueryMap, (Object)((String)StringUtils.defaultIfBlank((CharSequence)this.getDatabaseReadOnly(), (CharSequence)this.getDatabase())));
    }

    @Override
    public void setProperties(Properties properties) {
        this.setSplitReadWrite(Boolean.parseBoolean(properties.getProperty("database.enable-read-write-split")));
        this.setWritePoolCache(Boolean.parseBoolean(properties.getProperty("database.write-pool-cache")));
        this.setDatabase(properties.getProperty("database"));
        this.setDatabaseUrl(properties.getProperty("database.url"));
        this.setDatabaseDriver(properties.getProperty("database.driver"));
        this.setDatabaseUsername(properties.getProperty("database.username"));
        this.setDatabasePassword(properties.getProperty("database.password"));
        this.setDatabaseMaxConnections(NumberUtils.toInt((String)properties.getProperty("database.max-connections"), (int)20));
        this.setDatabasePool(properties.getProperty("database.pool"));
        this.setDatabaseConnectionMaxRetry(NumberUtils.toInt((String)properties.getProperty("database.connection.maxretry"), (int)2));
        this.setDatabaseConnectionMaxRetryWaitTimeInMs(NumberUtils.toInt((String)properties.getProperty("database.connection.retrywaitinmilliseconds"), (int)10000));
        this.setDatabaseReadOnly(properties.getProperty("database-readonly"));
        this.setDatabaseReadOnlyUrl(properties.getProperty("database-readonly.url"));
        this.setDatabaseReadOnlyDriver(properties.getProperty("database-readonly.driver"));
        this.setDatabaseReadOnlyUsername(properties.getProperty("database-readonly.username"));
        this.setDatabaseReadOnlyPassword(properties.getProperty("database-readonly.password"));
        String readOnlyMaxConnectionsString = properties.getProperty("database-readonly.max-connections");
        if (StringUtils.isNotBlank((CharSequence)readOnlyMaxConnectionsString)) {
            this.setDatabaseReadOnlyMaxConnections(NumberUtils.toInt((String)readOnlyMaxConnectionsString, (int)this.getDatabaseMaxConnections()));
        }
        this.setDatabaseReadOnlyPool(properties.getProperty("database-readonly.pool"));
        this.setDirBase(properties.getProperty(DIR_BASE));
    }

    @Override
    public Properties getProperties() {
        PropertiesConfiguration configuration = PropertiesConfigurationUtil.create();
        configuration.setProperty("database.enable-read-write-split", (Object)Boolean.toString(this.splitReadWrite));
        configuration.setProperty("database.write-pool-cache", (Object)Boolean.toString(this.writePoolCache));
        if (this.getDirBase() != null) {
            configuration.setProperty(DIR_BASE, (Object)this.getDirBase());
        }
        if (this.getDatabase() != null) {
            configuration.setProperty("database", (Object)this.getDatabase());
        }
        if (this.getDatabaseUrl() != null) {
            configuration.setProperty("database.url", (Object)this.getDatabaseUrl());
        }
        if (this.getMappedDatabaseDriver() != null) {
            configuration.setProperty("database.driver", (Object)this.getMappedDatabaseDriver());
        }
        if (this.getDatabasePool() != null) {
            configuration.setProperty("database.pool", (Object)this.getDatabasePool());
        }
        if (this.getMappedJdbc4() != null) {
            configuration.setProperty("database.jdbc4", (Object)this.getMappedJdbc4());
        }
        if (this.getMappedTestQuery() != null) {
            configuration.setProperty("database.test-query", (Object)this.getMappedTestQuery());
        }
        if (this.getDatabaseUsername() != null) {
            configuration.setProperty("database.username", (Object)this.getDatabaseUsername());
        } else {
            configuration.setProperty("database.username", (Object)"");
        }
        if (this.getDatabasePassword() != null) {
            configuration.setProperty("database.password", (Object)this.getDatabasePassword());
        } else {
            configuration.setProperty("database.password", (Object)"");
        }
        if (this.getDatabaseMaxConnections() != null) {
            configuration.setProperty("database.max-connections", (Object)this.getDatabaseMaxConnections().toString());
        } else {
            configuration.setProperty("database.max-connections", (Object)"");
        }
        if (this.getDatabaseConnectionMaxRetry() != null) {
            configuration.setProperty("database.connection.maxretry", (Object)this.getDatabaseConnectionMaxRetry().toString());
        } else {
            configuration.setProperty("database.connection.maxretry", (Object)"");
        }
        if (this.getDatabaseConnectionMaxRetryWaitTimeInMs() != null) {
            configuration.setProperty("database.connection.retrywaitinmilliseconds", (Object)this.getDatabaseConnectionMaxRetryWaitTimeInMs().toString());
        } else {
            configuration.setProperty("database.connection.retrywaitinmilliseconds", (Object)"");
        }
        if (this.getDatabaseReadOnly() != null) {
            configuration.setProperty("database-readonly", (Object)this.getDatabaseReadOnly());
        }
        if (this.getDatabaseReadOnlyUrl() != null) {
            configuration.setProperty("database-readonly.url", (Object)this.getDatabaseReadOnlyUrl());
        }
        if (this.getMappedDatabaseDriver() != null) {
            configuration.setProperty("database-readonly.driver", (Object)this.getMappedReadOnlyDatabaseDriver());
        }
        if (this.getDatabaseReadOnlyPool() != null) {
            configuration.setProperty("database-readonly.pool", (Object)this.getDatabaseReadOnlyPool());
        }
        if (this.getMappedJdbc4() != null) {
            configuration.setProperty("database-readonly.jdbc4", (Object)this.getMappedReadOnlyJdbc4());
        }
        if (this.getMappedTestQuery() != null) {
            configuration.setProperty("database-readonly.test-query", (Object)this.getMappedReadOnlyTestQuery());
        }
        if (this.getDatabaseReadOnlyUsername() != null) {
            configuration.setProperty("database-readonly.username", (Object)this.getDatabaseReadOnlyUsername());
        }
        if (this.getDatabaseReadOnlyPassword() != null) {
            configuration.setProperty("database-readonly.password", (Object)this.getDatabaseReadOnlyPassword());
        }
        if (this.getDatabaseReadOnlyMaxConnections() != null) {
            configuration.setProperty("database-readonly.max-connections", (Object)this.getDatabaseReadOnlyMaxConnections().toString());
        }
        return ConfigurationConverter.getProperties((Configuration)configuration);
    }

    @Override
    public String toAuditString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    static {
        databaseDriverMap = new HashMap<String, String>();
        databaseDriverMap.put("derby", "org.apache.derby.jdbc.EmbeddedDriver");
        databaseDriverMap.put("mysql", "com.mysql.cj.jdbc.Driver");
        databaseDriverMap.put("oracle", "oracle.jdbc.OracleDriver");
        databaseDriverMap.put("postgres", "org.postgresql.Driver");
        databaseDriverMap.put("sqlserver", "net.sourceforge.jtds.jdbc.Driver");
        databaseJdbc4Map = new HashMap<String, Boolean>();
        databaseJdbc4Map.put("derby", true);
        databaseJdbc4Map.put("mysql", true);
        databaseJdbc4Map.put("oracle", true);
        databaseJdbc4Map.put("postgres", true);
        databaseJdbc4Map.put("sqlserver", false);
        databaseTestQueryMap = new HashMap<String, String>();
        databaseTestQueryMap.put("derby", "SELECT 1");
        databaseTestQueryMap.put("mysql", "SELECT 1");
        databaseTestQueryMap.put("oracle", "SELECT 1 FROM DUAL");
        databaseTestQueryMap.put("postgres", "SELECT 1");
        databaseTestQueryMap.put("sqlserver", "SELECT 1");
    }
}

