/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.donkey.util.xstream.Base64StringConverter;
import com.mirth.connect.model.FilterTransformer;
import com.mirth.connect.model.Step;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="transformer")
public class Transformer
extends FilterTransformer<Step> {
    @XStreamConverter(value=Base64StringConverter.class)
    private String inboundTemplate;
    @XStreamConverter(value=Base64StringConverter.class)
    private String outboundTemplate;
    private String inboundDataType;
    private String outboundDataType;
    private DataTypeProperties inboundProperties;
    private DataTypeProperties outboundProperties;

    public Transformer() {
    }

    public Transformer(Transformer props) {
        super(props);
        this.inboundTemplate = props.getInboundTemplate();
        this.outboundTemplate = props.getOutboundTemplate();
        this.inboundDataType = props.getInboundDataType();
        this.outboundDataType = props.getOutboundDataType();
        this.inboundProperties = props.getInboundProperties().clone();
        this.outboundProperties = props.getOutboundProperties().clone();
    }

    public String getInboundDataType() {
        return this.inboundDataType;
    }

    public void setInboundDataType(String inboundDataType) {
        this.inboundDataType = inboundDataType;
    }

    public String getInboundTemplate() {
        return this.inboundTemplate;
    }

    public void setInboundTemplate(String inboundTemplate) {
        this.inboundTemplate = inboundTemplate;
    }

    public String getOutboundDataType() {
        return this.outboundDataType;
    }

    public void setOutboundDataType(String outboundDataType) {
        this.outboundDataType = outboundDataType;
    }

    public String getOutboundTemplate() {
        return this.outboundTemplate;
    }

    public void setOutboundTemplate(String outboundTemplate) {
        this.outboundTemplate = outboundTemplate;
    }

    public DataTypeProperties getInboundProperties() {
        return this.inboundProperties;
    }

    public void setInboundProperties(DataTypeProperties inboundProperties) {
        this.inboundProperties = inboundProperties;
    }

    public DataTypeProperties getOutboundProperties() {
        return this.outboundProperties;
    }

    public void setOutboundProperties(DataTypeProperties outboundProperties) {
        this.outboundProperties = outboundProperties;
    }

    @Override
    public void migrate3_0_1(DonkeyElement transformer) {
        for (DonkeyElement step : transformer.getChildElement("steps").getChildElements()) {
            step.getChildElement("data").removeAttribute("class");
        }
    }

    @Override
    public void migrate3_5_0(DonkeyElement element) {
        DonkeyElement stepsElement = element.removeChild("steps");
        List steps = stepsElement.getChildElements();
        stepsElement = element.addChildElement("elements");
        for (DonkeyElement stepElement : steps) {
            DonkeyElement newStepElement;
            String type = stepElement.getChildElement("type").getTextContent();
            DonkeyElement dataElement = stepElement.getChildElement("data");
            HashMap<String, DonkeyElement> dataMap = new HashMap<String, DonkeyElement>();
            for (Object entry : dataElement.getChildElements()) {
                List values = entry.getChildElements();
                dataMap.put(((DonkeyElement)values.get(0)).getTextContent(), (DonkeyElement)values.get(1));
            }
            if (StringUtils.equals((CharSequence)type, (CharSequence)"Mapper")) {
                Object entry;
                newStepElement = stepsElement.addChildElement("com.mirth.connect.plugins.mapper.MapperStep");
                newStepElement.addChildElement("variable", ((DonkeyElement)dataMap.get("Variable")).getTextContent());
                newStepElement.addChildElement("mapping", ((DonkeyElement)dataMap.get("Mapping")).getTextContent());
                newStepElement.addChildElement("defaultValue", ((DonkeyElement)dataMap.get("DefaultValue")).getTextContent());
                replacements = newStepElement.addChildElement("replacements");
                entry = ((DonkeyElement)dataMap.get("RegularExpressions")).getChildElements().iterator();
                while (entry.hasNext()) {
                    DonkeyElement regex = (DonkeyElement)entry.next();
                    values = regex.getChildElements();
                    pair = replacements.addChildElement("org.apache.commons.lang3.tuple.ImmutablePair");
                    left = pair.addChildElement("left", ((DonkeyElement)values.get(0)).getTextContent());
                    left.setAttribute("class", "string");
                    right = pair.addChildElement("right", ((DonkeyElement)values.get(1)).getTextContent());
                    right.setAttribute("class", "string");
                }
                String scope = ((DonkeyElement)dataMap.get("isGlobal")).getTextContent();
                if (StringUtils.equalsIgnoreCase((CharSequence)scope, (CharSequence)"global")) {
                    newStepElement.addChildElement("scope", "GLOBAL");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)scope, (CharSequence)"globalChannel")) {
                    newStepElement.addChildElement("scope", "GLOBAL_CHANNEL");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)scope, (CharSequence)"response")) {
                    newStepElement.addChildElement("scope", "RESPONSE");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)scope, (CharSequence)"connector")) {
                    newStepElement.addChildElement("scope", "CONNECTOR");
                } else {
                    newStepElement.addChildElement("scope", "CHANNEL");
                }
            } else if (StringUtils.equals((CharSequence)type, (CharSequence)"Message Builder")) {
                newStepElement = stepsElement.addChildElement("com.mirth.connect.plugins.messagebuilder.MessageBuilderStep");
                newStepElement.addChildElement("messageSegment", ((DonkeyElement)dataMap.get("Variable")).getTextContent());
                newStepElement.addChildElement("mapping", ((DonkeyElement)dataMap.get("Mapping")).getTextContent());
                newStepElement.addChildElement("defaultValue", ((DonkeyElement)dataMap.get("DefaultValue")).getTextContent());
                replacements = newStepElement.addChildElement("replacements");
                for (DonkeyElement regex : ((DonkeyElement)dataMap.get("RegularExpressions")).getChildElements()) {
                    values = regex.getChildElements();
                    pair = replacements.addChildElement("org.apache.commons.lang3.tuple.ImmutablePair");
                    left = pair.addChildElement("left", ((DonkeyElement)values.get(0)).getTextContent());
                    left.setAttribute("class", "string");
                    right = pair.addChildElement("right", ((DonkeyElement)values.get(1)).getTextContent());
                    right.setAttribute("class", "string");
                }
            } else if (StringUtils.equals((CharSequence)type, (CharSequence)"External Script")) {
                newStepElement = stepsElement.addChildElement("com.mirth.connect.plugins.scriptfilestep.ExternalScriptStep");
                newStepElement.addChildElement("scriptPath", ((DonkeyElement)dataMap.get("Variable")).getTextContent());
            } else if (StringUtils.equals((CharSequence)type, (CharSequence)"XSLT Step")) {
                newStepElement = stepsElement.addChildElement("com.mirth.connect.plugins.xsltstep.XsltStep");
                newStepElement.addChildElement("sourceXml", ((DonkeyElement)dataMap.get("Source")).getTextContent());
                newStepElement.addChildElement("resultVariable", ((DonkeyElement)dataMap.get("Result")).getTextContent());
                newStepElement.addChildElement("template", ((DonkeyElement)dataMap.get("XsltTemplate")).getTextContent());
                DonkeyElement factory = (DonkeyElement)dataMap.get("Factory");
                if (factory != null) {
                    newStepElement.addChildElement("useCustomFactory", "true");
                    newStepElement.addChildElement("customFactory", factory.getTextContent());
                } else {
                    newStepElement.addChildElement("useCustomFactory", "false");
                    newStepElement.addChildElement("customFactory", "");
                }
            } else {
                newStepElement = stepsElement.addChildElement("com.mirth.connect.plugins.javascriptstep.JavaScriptStep");
                DonkeyElement script = (DonkeyElement)dataMap.get("Script");
                if (script != null) {
                    newStepElement.addChildElement("script", script.getTextContent());
                } else {
                    newStepElement.addChildElement("script", stepElement.getChildElement("script").getTextContent());
                }
            }
            newStepElement.addChildElement("sequenceNumber", stepElement.getChildElement("sequenceNumber").getTextContent());
            DonkeyElement nameElement = stepElement.getChildElement("name");
            newStepElement.addChildElement("name", nameElement != null ? nameElement.getTextContent() : "");
        }
    }

    @Override
    public void migrate3_6_0(DonkeyElement element) {
    }

    @Override
    public Map<String, Object> getPurgedProperties() {
        Map<String, Object> purgedProperties = super.getPurgedProperties();
        purgedProperties.put("inboundTemplateChars", PurgeUtil.countChars((String)this.inboundTemplate));
        purgedProperties.put("outboundTemplateChars", PurgeUtil.countChars((String)this.outboundTemplate));
        purgedProperties.put("inboundDataType", this.inboundDataType);
        purgedProperties.put("outboundDataType", this.outboundDataType);
        purgedProperties.put("inboundProperties", this.inboundProperties.getPurgedProperties());
        purgedProperties.put("outboundProperties", this.outboundProperties.getPurgedProperties());
        return purgedProperties;
    }

    @Override
    public Transformer clone() {
        return new Transformer(this);
    }
}

