/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.codetemplates;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.Cacheable;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

@XStreamAlias(value="codeTemplateLibrary")
public class CodeTemplateLibrary
implements Serializable,
Migratable,
Purgable,
Cacheable<CodeTemplateLibrary> {
    private String id;
    private String name;
    private Integer revision;
    private Calendar lastModified;
    private String description;
    private boolean includeNewChannels;
    private Set<String> enabledChannelIds;
    private Set<String> disabledChannelIds;
    private List<CodeTemplate> codeTemplates;

    public CodeTemplateLibrary() {
        this.id = UUID.randomUUID().toString();
        this.enabledChannelIds = new TreeSet<String>();
        this.disabledChannelIds = new TreeSet<String>();
        this.codeTemplates = new ArrayList<CodeTemplate>();
    }

    public CodeTemplateLibrary(CodeTemplateLibrary library) {
        this.id = library.getId();
        this.name = library.getName();
        this.revision = library.getRevision();
        this.lastModified = library.getLastModified();
        this.description = library.getDescription();
        this.includeNewChannels = library.isIncludeNewChannels();
        this.enabledChannelIds = new TreeSet<String>(library.getEnabledChannelIds());
        this.disabledChannelIds = new TreeSet<String>(library.getDisabledChannelIds());
        this.codeTemplates = new ArrayList<CodeTemplate>();
        if (CollectionUtils.isNotEmpty(library.getCodeTemplates())) {
            for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                this.codeTemplates.add(new CodeTemplate(codeTemplate));
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isIncludeNewChannels() {
        return this.includeNewChannels;
    }

    public void setIncludeNewChannels(boolean includeNewChannels) {
        this.includeNewChannels = includeNewChannels;
    }

    public Set<String> getEnabledChannelIds() {
        return this.enabledChannelIds;
    }

    public void setEnabledChannelIds(Set<String> enabledChannelIds) {
        this.enabledChannelIds = enabledChannelIds;
    }

    public Set<String> getDisabledChannelIds() {
        return this.disabledChannelIds;
    }

    public void setDisabledChannelIds(Set<String> disabledChannelIds) {
        this.disabledChannelIds = disabledChannelIds;
    }

    public List<CodeTemplate> getCodeTemplates() {
        return this.codeTemplates;
    }

    public void setCodeTemplates(List<CodeTemplate> codeTemplates) {
        this.codeTemplates = codeTemplates;
    }

    public void sortCodeTemplates() {
        if (CollectionUtils.isNotEmpty(this.codeTemplates)) {
            Collections.sort(this.codeTemplates, new Comparator<CodeTemplate>(){

                @Override
                public int compare(CodeTemplate o1, CodeTemplate o2) {
                    if (o1.getName() == null && o2.getName() != null) {
                        return -1;
                    }
                    if (o1.getName() != null && o2.getName() == null) {
                        return 1;
                    }
                    if (o1.getName() == null && o2.getName() == null) {
                        return 0;
                    }
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
        }
    }

    public void replaceCodeTemplatesWithIds() {
        if (CollectionUtils.isNotEmpty(this.codeTemplates)) {
            ArrayList<CodeTemplate> list = new ArrayList<CodeTemplate>();
            for (CodeTemplate codeTemplate : this.codeTemplates) {
                list.add(new CodeTemplate(codeTemplate.getId()));
            }
            this.codeTemplates = list;
        }
    }

    @Override
    public CodeTemplateLibrary cloneIfNeeded() {
        return new CodeTemplateLibrary(this);
    }

    public void migrate3_0_1(DonkeyElement element) {
    }

    public void migrate3_0_2(DonkeyElement element) {
    }

    public void migrate3_1_0(DonkeyElement element) {
    }

    public void migrate3_2_0(DonkeyElement element) {
    }

    public void migrate3_3_0(DonkeyElement element) {
    }

    public void migrate3_4_0(DonkeyElement element) {
    }

    public void migrate3_5_0(DonkeyElement element) {
    }

    public void migrate3_6_0(DonkeyElement element) {
    }

    public void migrate3_7_0(DonkeyElement element) {
    }

    public void migrate3_9_0(DonkeyElement element) {
    }

    public void migrate3_11_0(DonkeyElement element) {
    }

    public void migrate3_11_1(DonkeyElement element) {
    }

    public void migrate3_12_0(DonkeyElement element) {
    }

    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("id", this.id);
        purgedProperties.put("nameChars", PurgeUtil.countChars((String)this.name));
        purgedProperties.put("lastModified", this.lastModified);
        purgedProperties.put("descriptionChars", PurgeUtil.countChars((String)this.description));
        purgedProperties.put("includeNewChannels", this.includeNewChannels);
        purgedProperties.put("enabledChannelIdsCount", this.enabledChannelIds.size());
        purgedProperties.put("disabledChannelIdsCount", this.disabledChannelIds.size());
        ArrayList<Map<String, Object>> purgedCodeTemplates = new ArrayList<Map<String, Object>>();
        for (CodeTemplate codeTemplate : this.codeTemplates) {
            purgedCodeTemplates.add(codeTemplate.getPurgedProperties());
        }
        purgedProperties.put("codeTemplates", purgedCodeTemplates);
        return purgedProperties;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false, null, (String[])new String[]{"UNASSIGNED_LIBRARY_ID", "UNASSIGNED_LIBRARY_DESCRIPTION"});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append('[');
        builder.append("id=").append(this.id).append(", ");
        builder.append("name=").append(this.name).append(", ");
        builder.append("revision=").append(this.revision).append(", ");
        builder.append("lastModified=").append(this.lastModified).append(", ");
        builder.append("description=").append(this.description).append(", ");
        builder.append("includeNewChannels=").append(this.includeNewChannels).append(", ");
        builder.append("enabledChannelIds=").append(this.enabledChannelIds).append(", ");
        builder.append("disabledChannelIds=").append(this.disabledChannelIds).append(", ");
        builder.append("codeTemplates=").append(this.codeTemplates).append(']');
        return builder.toString();
    }
}

