/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DirectedAcyclicGraphNode<E> {
    private E element;
    private Map<E, DirectedAcyclicGraphNode<E>> dependentNodes = new HashMap<E, DirectedAcyclicGraphNode<E>>();
    private Map<E, DirectedAcyclicGraphNode<E>> dependencyNodes = new HashMap<E, DirectedAcyclicGraphNode<E>>();

    public DirectedAcyclicGraphNode(E element) {
        this.element = element;
    }

    public E getElement() {
        return this.element;
    }

    public boolean isSink() {
        return this.dependentNodes.isEmpty();
    }

    public boolean isSource() {
        return this.dependencyNodes.isEmpty();
    }

    Set<DirectedAcyclicGraphNode<E>> getDependentNodes() {
        return new HashSet<DirectedAcyclicGraphNode<E>>(this.dependentNodes.values());
    }

    public DirectedAcyclicGraphNode<E> findDependentNode(E element) {
        DirectedAcyclicGraphNode<E> dependentNode;
        block2: {
            DirectedAcyclicGraphNode<E> node;
            if (Objects.equals(this.getElement(), element)) {
                return this;
            }
            dependentNode = this.dependentNodes.get(element);
            if (dependentNode != null) break block2;
            Iterator<DirectedAcyclicGraphNode<E>> iterator = this.dependentNodes.values().iterator();
            while (iterator.hasNext() && (dependentNode = (node = iterator.next()).findDependentNode(element)) == null) {
            }
        }
        return dependentNode;
    }

    public Set<E> getDirectDependentElements() {
        return new LinkedHashSet<E>(this.dependentNodes.keySet());
    }

    public Set<DirectedAcyclicGraphNode<E>> getDirectDependentNodes() {
        return new LinkedHashSet<DirectedAcyclicGraphNode<E>>(this.dependentNodes.values());
    }

    public Set<E> getAllDependentElements() {
        LinkedHashSet dependentElements = new LinkedHashSet();
        this.getAllDependentElements(dependentElements);
        return dependentElements;
    }

    private void getAllDependentElements(Set<E> set) {
        for (DirectedAcyclicGraphNode<E> node : this.dependentNodes.values()) {
            set.add(node.getElement());
            node.getAllDependentElements(set);
        }
    }

    void putDependentNode(DirectedAcyclicGraphNode<E> dependentNode) {
        this.dependentNodes.put(dependentNode.getElement(), dependentNode);
    }

    Set<DirectedAcyclicGraphNode<E>> getDependencyNodes() {
        return new HashSet<DirectedAcyclicGraphNode<E>>(this.dependencyNodes.values());
    }

    public DirectedAcyclicGraphNode<E> findDependencyNode(E element) {
        DirectedAcyclicGraphNode<E> dependencyNode;
        block2: {
            DirectedAcyclicGraphNode<E> node;
            if (Objects.equals(this.getElement(), element)) {
                return this;
            }
            dependencyNode = this.dependencyNodes.get(element);
            if (dependencyNode != null) break block2;
            Iterator<DirectedAcyclicGraphNode<E>> iterator = this.dependencyNodes.values().iterator();
            while (iterator.hasNext() && (dependencyNode = (node = iterator.next()).findDependencyNode(element)) == null) {
            }
        }
        return dependencyNode;
    }

    public Set<E> getDirectDependencyElements() {
        return new LinkedHashSet<E>(this.dependencyNodes.keySet());
    }

    public Set<DirectedAcyclicGraphNode<E>> getDirectDependencyNodes() {
        return new LinkedHashSet<DirectedAcyclicGraphNode<E>>(this.dependencyNodes.values());
    }

    public Set<E> getAllDependencyElements() {
        LinkedHashSet dependencyIds = new LinkedHashSet();
        this.getAllDependencyElements(dependencyIds);
        return dependencyIds;
    }

    private void getAllDependencyElements(Set<E> set) {
        for (DirectedAcyclicGraphNode<E> node : this.dependencyNodes.values()) {
            set.add(node.getElement());
            node.getAllDependencyElements(set);
        }
    }

    void putDependencyNode(DirectedAcyclicGraphNode<E> dependencyNode) {
        this.dependencyNodes.put(dependencyNode.getElement(), dependencyNode);
    }

    Set<DirectedAcyclicGraphNode<E>> getSinkNodes() {
        HashSet<DirectedAcyclicGraphNode<DirectedAcyclicGraphNode<E>>> sinkNodes = new HashSet<DirectedAcyclicGraphNode<DirectedAcyclicGraphNode<E>>>();
        if (this.isSink()) {
            sinkNodes.add(this);
        } else {
            for (DirectedAcyclicGraphNode<E> node : this.dependentNodes.values()) {
                sinkNodes.addAll(node.getSinkNodes());
            }
        }
        return sinkNodes;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DirectedAcyclicGraphNode) {
            return Objects.equals(this.element, ((DirectedAcyclicGraphNode)obj).getElement());
        }
        return false;
    }
}

