/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.util;

import java.io.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;

public class TcpUtil {
    public static final String DEFAULT_LLP_START_BYTES = "0B";
    public static final String DEFAULT_LLP_END_BYTES = "1C0D";

    public static boolean isValidHexString(String str) {
        return str.matches("^[0-9A-F]*$");
    }

    public static String convertHexToAbbreviation(String str) {
        if (TcpUtil.isValidHexString(str)) {
            return TcpUtil.getByteAbbreviation(TcpUtil.stringToByteArray(str));
        }
        return "Invalid Hex";
    }

    public static String getByteAbbreviation(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        block36: for (byte b : bytes) {
            switch (b) {
                case 0: {
                    builder.append("<NUL>");
                    continue block36;
                }
                case 1: {
                    builder.append("<SOH>");
                    continue block36;
                }
                case 2: {
                    builder.append("<STX>");
                    continue block36;
                }
                case 3: {
                    builder.append("<ETX>");
                    continue block36;
                }
                case 4: {
                    builder.append("<EOT>");
                    continue block36;
                }
                case 5: {
                    builder.append("<ENQ>");
                    continue block36;
                }
                case 6: {
                    builder.append("<ACK>");
                    continue block36;
                }
                case 7: {
                    builder.append("<BEL>");
                    continue block36;
                }
                case 8: {
                    builder.append("<BS>");
                    continue block36;
                }
                case 9: {
                    builder.append("<TAB>");
                    continue block36;
                }
                case 10: {
                    builder.append("<LF>");
                    continue block36;
                }
                case 11: {
                    builder.append("<VT>");
                    continue block36;
                }
                case 12: {
                    builder.append("<FF>");
                    continue block36;
                }
                case 13: {
                    builder.append("<CR>");
                    continue block36;
                }
                case 14: {
                    builder.append("<SO>");
                    continue block36;
                }
                case 15: {
                    builder.append("<SI>");
                    continue block36;
                }
                case 16: {
                    builder.append("<DLE>");
                    continue block36;
                }
                case 17: {
                    builder.append("<DC1>");
                    continue block36;
                }
                case 18: {
                    builder.append("<DC2>");
                    continue block36;
                }
                case 19: {
                    builder.append("<DC3>");
                    continue block36;
                }
                case 20: {
                    builder.append("<DC4>");
                    continue block36;
                }
                case 21: {
                    builder.append("<NAK>");
                    continue block36;
                }
                case 22: {
                    builder.append("<SYN>");
                    continue block36;
                }
                case 23: {
                    builder.append("<ETB>");
                    continue block36;
                }
                case 24: {
                    builder.append("<CAN>");
                    continue block36;
                }
                case 25: {
                    builder.append("<EM>");
                    continue block36;
                }
                case 26: {
                    builder.append("<SUB>");
                    continue block36;
                }
                case 27: {
                    builder.append("<ESC>");
                    continue block36;
                }
                case 28: {
                    builder.append("<FS>");
                    continue block36;
                }
                case 29: {
                    builder.append("<GS>");
                    continue block36;
                }
                case 30: {
                    builder.append("<RS>");
                    continue block36;
                }
                case 31: {
                    builder.append("<US>");
                    continue block36;
                }
                case 32: {
                    builder.append("<Space>");
                    continue block36;
                }
                case 127: {
                    builder.append("<DEL>");
                    continue block36;
                }
                default: {
                    builder.append(new String(new byte[]{b}));
                }
            }
        }
        return builder.toString();
    }

    public static byte[] stringToByteArray(String str) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            String hexString = str.toUpperCase().replaceAll("[^0-9A-F]", "");
            for (String hexByte : ((hexString.length() % 2 > 0 ? "0" : "") + hexString).split("(?<=\\G..)")) {
                bytes.write((byte)((Character.digit(hexByte.charAt(0), 16) << 4) + Character.digit(hexByte.charAt(1), 16)));
            }
        }
        return bytes.toByteArray();
    }

    public static String getFixedHost(String host) {
        if (host == null || host.length() == 0) {
            return "localhost";
        }
        return host;
    }
}

