/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.UIDDictionary;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.AssociationReaper;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.DataWriter;
import org.dcm4che2.net.DataWriterAdapter;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.FutureDimseRSP;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NoPresentationContextException;
import org.dcm4che2.net.PDUDecoder;
import org.dcm4che2.net.PDUEncoder;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.State;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.UserIdentity;
import org.dcm4che2.net.pdu.AAbort;
import org.dcm4che2.net.pdu.AAssociateAC;
import org.dcm4che2.net.pdu.AAssociateRJ;
import org.dcm4che2.net.pdu.AAssociateRQ;
import org.dcm4che2.net.pdu.ExtendedNegotiation;
import org.dcm4che2.net.pdu.PresentationContext;
import org.dcm4che2.net.pdu.RoleSelection;
import org.dcm4che2.util.CloseUtils;
import org.dcm4che2.util.IntHashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Association
implements Runnable {
    static Logger log = LoggerFactory.getLogger(Association.class);
    private static final AtomicInteger nextSerialNo = new AtomicInteger(0);
    private final int serialNo = nextSerialNo.incrementAndGet();
    private final NetworkConnection connector;
    private final AssociationReaper reaper;
    private NetworkApplicationEntity ae;
    private UserIdentity userIdentity;
    private Socket socket;
    private boolean requestor;
    private InputStream in;
    private OutputStream out;
    private PDUEncoder encoder;
    private PDUDecoder decoder;
    private State state;
    private String name = "Association(" + this.serialNo + ")";
    private AAssociateRQ associateRQ;
    private AAssociateAC associateAC;
    private IOException exception;
    private int maxOpsInvoked;
    private int maxPDULength;
    private int performing;
    private boolean closed;
    private IntHashtable<DimseRSPHandler> rspHandlerForMsgId = new IntHashtable();
    private IntHashtable<DimseRSP> cancelHandlerForMsgId = new IntHashtable();
    private HashMap<String, Map<String, PresentationContext>> acceptedPCs = new HashMap();
    private HashMap<String, TransferCapability> scuTCs = new HashMap();
    private HashMap<String, TransferCapability> scpTCs = new HashMap();
    private long idleTimeout = Long.MAX_VALUE;

    protected Association(Socket socket, NetworkConnection connector, boolean requestor) throws IOException {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        if (connector == null) {
            throw new NullPointerException("connector");
        }
        this.connector = connector;
        this.reaper = connector.getDevice().getAssociationReaper();
        this.socket = socket;
        this.requestor = requestor;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.encoder = new PDUEncoder(this, this.out);
        this.state = State.STA1;
        log.info(requestor ? "{} initiated {}" : "{} accepted {}", (Object)this.name, (Object)socket);
    }

    public String toString() {
        return this.name;
    }

    public static Association request(Socket socket, NetworkConnection connector, NetworkApplicationEntity ae, UserIdentity userIdentity) throws IOException {
        Association a = new Association(socket, connector, true);
        a.setApplicationEntity(ae);
        a.setUserIdentity(userIdentity);
        a.setState(State.STA4);
        return a;
    }

    public static Association accept(Socket socket, NetworkConnection connector) throws IOException {
        Association a = new Association(socket, connector, false);
        a.setState(State.STA2);
        return a;
    }

    public final Socket getSocket() {
        return this.socket;
    }

    final void setApplicationEntity(NetworkApplicationEntity ae) {
        this.ae = ae;
    }

    final void setUserIdentity(UserIdentity userIdentity) {
        this.userIdentity = userIdentity;
    }

    public final AAssociateAC getAssociateAC() {
        return this.associateAC;
    }

    public final AAssociateRQ getAssociateRQ() {
        return this.associateRQ;
    }

    final IOException getException() {
        return this.exception;
    }

    void checkException() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public final boolean isRequestor() {
        return this.requestor;
    }

    public final boolean isReadyForDataTransfer() {
        return this.state.isReadyForDataTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailableOps() {
        if (this.maxOpsInvoked == 0) {
            return true;
        }
        IntHashtable<DimseRSPHandler> intHashtable = this.rspHandlerForMsgId;
        synchronized (intHashtable) {
            return this.rspHandlerForMsgId.size() < this.maxOpsInvoked;
        }
    }

    private boolean isReadyForDataReceive() {
        return this.state.isReadyForDataReceive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(State state) {
        Association association = this;
        synchronized (association) {
            if (this.state == state) {
                return;
            }
            log.debug("{} enter state: {}", (Object)this, (Object)state);
            this.state = state;
            this.notifyAll();
        }
    }

    private void processAC() {
        Collection<PresentationContext> c = this.associateAC.getPresentationContexts();
        for (PresentationContext presentationContext : c) {
            if (!presentationContext.isAccepted()) continue;
            PresentationContext pcrq = this.associateRQ.getPresentationContext(presentationContext.getPCID());
            if (pcrq == null) {
                log.warn("{}: Missing Presentation Context(id={}) in received AA-AC", (Object)this.name, (Object)new Integer(presentationContext.getPCID()));
                continue;
            }
            String as = pcrq.getAbstractSyntax();
            Map<String, PresentationContext> ts2pc = this.acceptedPCs.get(as);
            if (ts2pc == null) {
                ts2pc = new HashMap<String, PresentationContext>();
                this.acceptedPCs.put(as, ts2pc);
            }
            ts2pc.put(presentationContext.getTransferSyntax(), presentationContext);
        }
        for (Map.Entry entry : this.acceptedPCs.entrySet()) {
            TransferCapability tc;
            byte[] extinfo;
            String asuid = (String)entry.getKey();
            Map ts2pc = (Map)entry.getValue();
            String[] tsuids = ts2pc.keySet().toArray(new String[ts2pc.size()]);
            String cuid = asuid;
            ExtendedNegotiation extneg = this.associateAC.getExtendedNegotiationFor(cuid);
            byte[] byArray = extinfo = extneg != null ? extneg.getInformation() : null;
            if (this.isSCUFor(cuid)) {
                tc = new TransferCapability(cuid, tsuids, "SCU");
                tc.setExtInfo(extinfo);
                this.scuTCs.put(cuid, tc);
            }
            if (!this.isSCPFor(cuid)) continue;
            tc = new TransferCapability(cuid, tsuids, "SCP");
            tc.setExtInfo(extinfo);
            this.scpTCs.put(cuid, tc);
        }
    }

    private boolean isSCPFor(String cuid) {
        RoleSelection rolsel = this.associateAC.getRoleSelectionFor(cuid);
        if (rolsel == null) {
            return !this.requestor;
        }
        return this.requestor ? rolsel.isSCP() : rolsel.isSCU();
    }

    private boolean isSCUFor(String cuid) {
        RoleSelection rolsel = this.associateAC.getRoleSelectionFor(cuid);
        if (rolsel == null) {
            return this.requestor;
        }
        return this.requestor ? rolsel.isSCU() : rolsel.isSCP();
    }

    public String getCallingAET() {
        return this.associateRQ != null ? this.associateRQ.getCallingAET() : null;
    }

    public String getCalledAET() {
        return this.associateRQ != null ? this.associateRQ.getCalledAET() : null;
    }

    public String getRemoteAET() {
        return this.requestor ? this.getCalledAET() : this.getCallingAET();
    }

    public String getLocalAET() {
        return this.requestor ? this.getCallingAET() : this.getCalledAET();
    }

    public final UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public TransferCapability getTransferCapabilityAsSCP(String cuid) {
        return this.scpTCs.get(cuid);
    }

    public TransferCapability getTransferCapabilityAsSCU(String cuid) {
        return this.scuTCs.get(cuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AAssociateAC negotiate(AAssociateRQ rq) throws IOException, InterruptedException {
        this.sendAssociateRQ(rq);
        Association association = this;
        synchronized (association) {
            while (this.state == State.STA5) {
                this.wait();
            }
        }
        this.checkException();
        if (this.state != State.STA6) {
            throw new RuntimeException("unexpected state: " + this.state);
        }
        return this.associateAC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean waitForRSP) throws InterruptedException {
        if (this.ae != null) {
            this.ae.removeFromPool(this);
        }
        if (waitForRSP) {
            this.waitForDimseRSP();
        }
        this.sendReleaseRQ();
        Association association = this;
        synchronized (association) {
            while (this.state != State.STA1) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDimseRSP() throws InterruptedException {
        IntHashtable<DimseRSPHandler> intHashtable = this.rspHandlerForMsgId;
        synchronized (intHashtable) {
            while (!this.rspHandlerForMsgId.isEmpty() && this.isReadyForDataReceive()) {
                this.rspHandlerForMsgId.wait();
            }
        }
    }

    public void abort() {
        this.abort(new AAbort());
    }

    private PresentationContext pcFor(String cuid, String tsuid) throws NoPresentationContextException {
        Map<String, PresentationContext> ts2pc = this.acceptedPCs.get(cuid);
        if (ts2pc == null) {
            throw new NoPresentationContextException("Abstract Syntax " + UIDDictionary.getDictionary().prompt(cuid) + " not supported");
        }
        if (tsuid == null) {
            return ts2pc.values().iterator().next();
        }
        PresentationContext pc = ts2pc.get(tsuid);
        if (pc == null) {
            throw new NoPresentationContextException("Abstract Syntax " + UIDDictionary.getDictionary().prompt(cuid) + " with Transfer Syntax " + UIDDictionary.getDictionary().prompt(tsuid) + " not supported");
        }
        return pc;
    }

    public void cstore(String cuid, String iuid, int priority, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.cstore(cuid, cuid, iuid, priority, data, tsuid, rspHandler);
    }

    public void cstore(String asuid, String cuid, String iuid, int priority, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject cstorerq = CommandUtils.mkCStoreRQ(this.ae.nextMessageID(), cuid, iuid, priority);
        this.invoke(pc.getPCID(), cstorerq, data, rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP cstore(String cuid, String iuid, int priority, DataWriter data, String tsuid) throws IOException, InterruptedException {
        return this.cstore(cuid, cuid, iuid, priority, data, tsuid);
    }

    public DimseRSP cstore(String asuid, String cuid, String iuid, int priority, DataWriter data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.cstore(asuid, cuid, iuid, priority, data, tsuid, rsp);
        return rsp;
    }

    public void cstore(String cuid, String iuid, int priority, String moveOriginatorAET, int moveOriginatorMsgId, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.cstore(cuid, cuid, iuid, priority, moveOriginatorAET, moveOriginatorMsgId, data, tsuid, rspHandler);
    }

    public void cstore(String asuid, String cuid, String iuid, int priority, String moveOriginatorAET, int moveOriginatorMsgId, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject cstorerq = CommandUtils.mkCStoreRQ(this.ae.nextMessageID(), cuid, iuid, priority, moveOriginatorAET, moveOriginatorMsgId);
        this.invoke(pc.getPCID(), cstorerq, data, rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP cstore(String cuid, String iuid, int priority, String moveOriginatorAET, int moveOriginatorMsgId, DataWriter data, String tsuid) throws IOException, InterruptedException {
        return this.cstore(cuid, cuid, iuid, priority, moveOriginatorAET, moveOriginatorMsgId, data, tsuid);
    }

    public DimseRSP cstore(String asuid, String cuid, String iuid, int priority, String moveOriginatorAET, int moveOriginatorMsgId, DataWriter data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.cstore(asuid, cuid, iuid, priority, moveOriginatorAET, moveOriginatorMsgId, data, tsuid, rsp);
        return rsp;
    }

    public void cfind(String cuid, int priority, DicomObject data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.cfind(cuid, cuid, priority, data, tsuid, rspHandler);
    }

    public void cfind(String asuid, String cuid, int priority, DicomObject data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject cfindrq = CommandUtils.mkCFindRQ(this.ae.nextMessageID(), cuid, priority);
        this.invoke(pc.getPCID(), cfindrq, new DataWriterAdapter(data), rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP cfind(String cuid, int priority, DicomObject data, String tsuid, int autoCancel) throws IOException, InterruptedException {
        return this.cfind(cuid, cuid, priority, data, tsuid, autoCancel);
    }

    public DimseRSP cfind(String asuid, String cuid, int priority, DicomObject data, String tsuid, int autoCancel) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        rsp.setAutoCancel(autoCancel);
        this.cfind(asuid, cuid, priority, data, tsuid, rsp);
        return rsp;
    }

    public void cget(String cuid, int priority, DicomObject data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.cget(cuid, cuid, priority, data, tsuid, rspHandler);
    }

    public void cget(String asuid, String cuid, int priority, DicomObject data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject cfindrq = CommandUtils.mkCGetRQ(this.ae.nextMessageID(), cuid, priority);
        this.invoke(pc.getPCID(), cfindrq, new DataWriterAdapter(data), rspHandler, this.ae.getRetrieveRspTimeout());
    }

    public DimseRSP cget(String cuid, int priority, DicomObject data, String tsuid) throws IOException, InterruptedException {
        return this.cget(cuid, cuid, priority, data, tsuid);
    }

    public DimseRSP cget(String asuid, String cuid, int priority, DicomObject data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.cget(asuid, cuid, priority, data, tsuid, rsp);
        return rsp;
    }

    public void cmove(String cuid, int priority, DicomObject data, String tsuid, String destination, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.cmove(cuid, cuid, priority, data, tsuid, destination, rspHandler);
    }

    public void cmove(String asuid, String cuid, int priority, DicomObject data, String tsuid, String destination, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject cfindrq = CommandUtils.mkCMoveRQ(this.ae.nextMessageID(), cuid, priority, destination);
        this.invoke(pc.getPCID(), cfindrq, new DataWriterAdapter(data), rspHandler, this.ae.getRetrieveRspTimeout());
    }

    public DimseRSP cmove(String cuid, int priority, DicomObject data, String tsuid, String destination) throws IOException, InterruptedException {
        return this.cmove(cuid, cuid, priority, data, tsuid, destination);
    }

    public DimseRSP cmove(String asuid, String cuid, int priority, DicomObject data, String tsuid, String destination) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.cmove(asuid, cuid, priority, data, tsuid, destination, rsp);
        return rsp;
    }

    public DimseRSP cecho() throws IOException, InterruptedException {
        return this.cecho("1.2.840.10008.1.1");
    }

    public DimseRSP cecho(String cuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        PresentationContext pc = this.pcFor(cuid, null);
        DicomObject cechorq = CommandUtils.mkCEchoRQ(this.ae.nextMessageID(), cuid);
        this.invoke(pc.getPCID(), cechorq, null, rsp, this.ae.getDimseRspTimeout());
        return rsp;
    }

    public void nevent(String cuid, String iuid, int eventTypeId, DicomObject attrs, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nevent(cuid, cuid, iuid, eventTypeId, attrs, tsuid, rspHandler);
    }

    public void nevent(String asuid, String cuid, String iuid, int eventTypeId, DicomObject attrs, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject neventrq = CommandUtils.mkNEventReportRQ(this.ae.nextMessageID(), cuid, iuid, eventTypeId, attrs);
        this.invoke(pc.getPCID(), neventrq, attrs != null ? new DataWriterAdapter(attrs) : null, rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP nevent(String cuid, String iuid, int eventTypeId, DicomObject attrs, String tsuid) throws IOException, InterruptedException {
        return this.nevent(cuid, cuid, iuid, eventTypeId, attrs, tsuid);
    }

    public DimseRSP nevent(String asuid, String cuid, String iuid, int eventTypeId, DicomObject attrs, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.nevent(asuid, cuid, iuid, eventTypeId, attrs, tsuid, rsp);
        return rsp;
    }

    public void nget(String cuid, String iuid, int[] tags, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nget(cuid, cuid, iuid, tags, rspHandler);
    }

    public void nget(String asuid, String cuid, String iuid, int[] tags, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, null);
        DicomObject ngetrq = CommandUtils.mkNGetRQ(this.ae.nextMessageID(), cuid, iuid, tags);
        this.invoke(pc.getPCID(), ngetrq, null, rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP nget(String cuid, String iuid, int[] tags) throws IOException, InterruptedException {
        return this.nget(cuid, cuid, iuid, tags);
    }

    public DimseRSP nget(String asuid, String cuid, String iuid, int[] tags) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.nget(asuid, cuid, iuid, tags, rsp);
        return rsp;
    }

    public void nset(String cuid, String iuid, DicomObject attrs, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nset(cuid, cuid, iuid, new DataWriterAdapter(attrs), tsuid, rspHandler);
    }

    public void nset(String asuid, String cuid, String iuid, DicomObject attrs, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nset(asuid, cuid, iuid, new DataWriterAdapter(attrs), tsuid, rspHandler);
    }

    public DimseRSP nset(String cuid, String iuid, DicomObject attrs, String tsuid) throws IOException, InterruptedException {
        return this.nset(cuid, cuid, iuid, new DataWriterAdapter(attrs), tsuid);
    }

    public DimseRSP nset(String asuid, String cuid, String iuid, DicomObject attrs, String tsuid) throws IOException, InterruptedException {
        return this.nset(asuid, cuid, iuid, new DataWriterAdapter(attrs), tsuid);
    }

    public void nset(String cuid, String iuid, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nset(cuid, cuid, iuid, data, tsuid, rspHandler);
    }

    public void nset(String asuid, String cuid, String iuid, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject nsetrq = CommandUtils.mkNSetRQ(this.ae.nextMessageID(), cuid, iuid);
        this.invoke(pc.getPCID(), nsetrq, data, rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP nset(String cuid, String iuid, DataWriter data, String tsuid) throws IOException, InterruptedException {
        return this.nset(cuid, cuid, iuid, data, tsuid);
    }

    public DimseRSP nset(String asuid, String cuid, String iuid, DataWriter attrs, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.nset(asuid, cuid, iuid, attrs, tsuid, (DimseRSPHandler)rsp);
        return rsp;
    }

    public void naction(String cuid, String iuid, int actionTypeId, DicomObject attrs, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.naction(cuid, cuid, iuid, actionTypeId, attrs, tsuid, rspHandler);
    }

    public void naction(String asuid, String cuid, String iuid, int actionTypeId, DicomObject attrs, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject nactionrq = CommandUtils.mkNActionRQ(this.ae.nextMessageID(), cuid, iuid, actionTypeId, attrs);
        this.invoke(pc.getPCID(), nactionrq, attrs != null ? new DataWriterAdapter(attrs) : null, rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP naction(String cuid, String iuid, int actionTypeId, DicomObject attrs, String tsuid) throws IOException, InterruptedException {
        return this.naction(cuid, cuid, iuid, actionTypeId, attrs, tsuid);
    }

    public DimseRSP naction(String asuid, String cuid, String iuid, int actionTypeId, DicomObject attrs, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.naction(asuid, cuid, iuid, actionTypeId, attrs, tsuid, rsp);
        return rsp;
    }

    public void ncreate(String cuid, String iuid, DicomObject attrs, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.ncreate(cuid, cuid, iuid, attrs, tsuid, rspHandler);
    }

    public void ncreate(String asuid, String cuid, String iuid, DicomObject attrs, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, tsuid);
        DicomObject ncreaterq = CommandUtils.mkNCreateRQ(this.ae.nextMessageID(), cuid, iuid);
        this.invoke(pc.getPCID(), ncreaterq, attrs != null ? new DataWriterAdapter(attrs) : null, rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP ncreate(String cuid, String iuid, DicomObject attrs, String tsuid) throws IOException, InterruptedException {
        return this.ncreate(cuid, cuid, iuid, attrs, tsuid);
    }

    public DimseRSP ncreate(String asuid, String cuid, String iuid, DicomObject attrs, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.ncreate(asuid, cuid, iuid, attrs, tsuid, rsp);
        return rsp;
    }

    public void ndelete(String cuid, String iuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.ndelete(cuid, cuid, iuid, rspHandler);
    }

    public void ndelete(String asuid, String cuid, String iuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        PresentationContext pc = this.pcFor(asuid, null);
        DicomObject nsetrq = CommandUtils.mkNDeleteRQ(this.ae.nextMessageID(), cuid, iuid);
        this.invoke(pc.getPCID(), nsetrq, null, rspHandler, this.ae.getDimseRspTimeout());
    }

    public DimseRSP ndelete(String asuid, String cuid, String iuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP();
        this.ndelete(asuid, cuid, iuid, rsp);
        return rsp;
    }

    public DimseRSP ndelete(String cuid, String iuid) throws IOException, InterruptedException {
        return this.ndelete(cuid, cuid, iuid);
    }

    void invoke(int pcid, DicomObject cmd, DataWriter data, DimseRSPHandler rspHandler, int rspTimeout) throws IOException, InterruptedException {
        if (CommandUtils.isResponse(cmd)) {
            throw new IllegalArgumentException("cmd:\n" + cmd);
        }
        this.checkException();
        if (!this.isReadyForDataTransfer()) {
            throw new IllegalStateException(this.state.toString());
        }
        PresentationContext pc = this.associateAC.getPresentationContext(pcid);
        if (pc == null) {
            throw new IllegalStateException("No Presentation Context with id - " + pcid);
        }
        if (!pc.isAccepted()) {
            throw new IllegalStateException("Presentation Context not accepted - " + pc);
        }
        rspHandler.setPcid(pcid);
        rspHandler.setMsgId(cmd.getInt(272));
        this.addDimseRSPHandler(cmd.getInt(272), rspHandler);
        this.encoder.writeDIMSE(pcid, cmd, data, pc.getTransferSyntax());
        rspHandler.setTimeout(System.currentTimeMillis() + (long)rspTimeout);
    }

    void cancel(int pcid, int msgid) throws IOException {
        DicomObject cmd = CommandUtils.mkCCancelRQ(msgid);
        this.encoder.writeDIMSE(pcid, cmd, null, null);
    }

    public void writeDimseRSP(int pcid, DicomObject cmd) throws IOException {
        this.writeDimseRSP(pcid, cmd, null);
    }

    public void writeDimseRSP(int pcid, DicomObject cmd, DicomObject data) throws IOException {
        if (!CommandUtils.isResponse(cmd)) {
            throw new IllegalArgumentException("cmd:\n" + cmd);
        }
        PresentationContext pc = this.associateAC.getPresentationContext(pcid);
        if (pc == null) {
            throw new IllegalStateException("No Presentation Context with id - " + pcid);
        }
        if (!pc.isAccepted()) {
            throw new IllegalStateException("Presentation Context not accepted - " + pc);
        }
        DataWriterAdapter writer = null;
        int datasetType = 257;
        if (data != null) {
            writer = new DataWriterAdapter(data);
            datasetType = CommandUtils.getWithDatasetType();
        }
        cmd.putInt(2048, VR.US, datasetType);
        this.encoder.writeDIMSE(pcid, cmd, writer, pc.getTransferSyntax());
        if (!CommandUtils.isPending(cmd)) {
            this.updateIdleTimeout();
            this.decPerforming();
        }
    }

    void onCancelRQ(DicomObject cmd) throws IOException {
        int msgId = cmd.getInt(288);
        DimseRSP handler = this.removeCancelRQHandler(msgId);
        if (handler != null) {
            handler.cancel(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCancelRQHandler(DicomObject cmd, DimseRSP handler) {
        IntHashtable<DimseRSP> intHashtable = this.cancelHandlerForMsgId;
        synchronized (intHashtable) {
            this.cancelHandlerForMsgId.put(cmd.getInt(272), (Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimseRSP removeCancelRQHandler(int msgId) {
        IntHashtable<DimseRSP> intHashtable = this.cancelHandlerForMsgId;
        synchronized (intHashtable) {
            return (DimseRSP)this.cancelHandlerForMsgId.remove(msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDimseRSP(DicomObject cmd, DicomObject data) throws IOException {
        int msgId = cmd.getInt(288);
        DimseRSPHandler rspHandler = this.getDimseRSPHandler(msgId);
        if (rspHandler == null) {
            log.warn("unexpected message ID in DIMSE RSP:\n{}", (Object)cmd);
            throw new AAbort();
        }
        try {
            rspHandler.onDimseRSP(this, cmd, data);
        }
        catch (Throwable throwable) {
            if (!CommandUtils.isPending(cmd)) {
                this.updateIdleTimeout();
                this.removeDimseRSPHandler(msgId);
            } else {
                rspHandler.setTimeout(System.currentTimeMillis() + (long)(Association.isRetrieveRsp(cmd) ? this.ae.getRetrieveRspTimeout() : this.ae.getDimseRspTimeout()));
            }
            throw throwable;
        }
        if (!CommandUtils.isPending(cmd)) {
            this.updateIdleTimeout();
            this.removeDimseRSPHandler(msgId);
        } else {
            rspHandler.setTimeout(System.currentTimeMillis() + (long)(Association.isRetrieveRsp(cmd) ? this.ae.getRetrieveRspTimeout() : this.ae.getDimseRspTimeout()));
        }
    }

    private static boolean isRetrieveRsp(DicomObject cmd) {
        int cmdField = cmd.getInt(256);
        return cmdField == 32801 || cmdField == 32784;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDimseRSPHandler(int msgId, DimseRSPHandler rspHandler) throws InterruptedException {
        IntHashtable<DimseRSPHandler> intHashtable = this.rspHandlerForMsgId;
        synchronized (intHashtable) {
            while (this.maxOpsInvoked > 0 && this.rspHandlerForMsgId.size() >= this.maxOpsInvoked) {
                this.rspHandlerForMsgId.wait();
            }
            if (this.isReadyForDataReceive()) {
                this.rspHandlerForMsgId.put(msgId, (Object)rspHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimseRSPHandler removeDimseRSPHandler(int msgId) {
        IntHashtable<DimseRSPHandler> intHashtable = this.rspHandlerForMsgId;
        synchronized (intHashtable) {
            DimseRSPHandler tmp = (DimseRSPHandler)this.rspHandlerForMsgId.remove(msgId);
            this.rspHandlerForMsgId.notifyAll();
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimseRSPHandler getDimseRSPHandler(int msgId) {
        IntHashtable<DimseRSPHandler> intHashtable = this.rspHandlerForMsgId;
        synchronized (intHashtable) {
            return (DimseRSPHandler)this.rspHandlerForMsgId.get(msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.startARTIM(this.requestor ? this.connector.getAcceptTimeout() : this.connector.getRequestTimeout());
            this.connector.incListenerConnectionCount();
            this.decoder = new PDUDecoder(this, this.in);
            while (this.state != State.STA1 && this.state != State.STA13) {
                this.decoder.nextPDU();
            }
        }
        catch (AAbort aa) {
            this.abort(aa);
        }
        catch (SocketTimeoutException e) {
            this.exception = e;
            log.warn("ARTIM timer expired in State: " + this.state);
        }
        catch (EOFException e) {
            this.exception = e;
            if (this.state == State.STA2) {
                log.debug("Client closed connection without sending data");
            } else {
                log.warn("i/o exception in State " + this.state, (Throwable)e);
            }
        }
        catch (IOException e) {
            this.exception = e;
            log.warn("i/o exception in State " + this.state, (Throwable)e);
        }
        finally {
            this.connector.decListenerConnectionCount();
            this.closeSocket();
        }
    }

    private void closeSocket() {
        if (this.state == State.STA13) {
            try {
                Thread.sleep(this.connector.getSocketCloseDelay());
            }
            catch (InterruptedException e) {
                log.warn("Interrupted Socket Close Delay", (Throwable)e);
            }
        }
        this.setState(State.STA1);
        CloseUtils.safeClose((Closeable)this.out);
        CloseUtils.safeClose((Closeable)this.in);
        if (!this.closed) {
            log.info("{}: close {}", (Object)this.name, (Object)this.socket);
            CloseUtils.safeClose((Socket)this.socket);
            this.closed = true;
            this.onClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClosed() {
        if (this.ae != null) {
            this.ae.removeFromPool(this);
        }
        this.reaper.unregister(this);
        IntHashtable<DimseRSPHandler> intHashtable = this.rspHandlerForMsgId;
        synchronized (intHashtable) {
            this.rspHandlerForMsgId.accept(new IntHashtable.Visitor(){

                public boolean visit(int key, Object value) {
                    ((DimseRSPHandler)value).onClosed(Association.this);
                    return true;
                }
            });
            this.rspHandlerForMsgId.clear();
            this.rspHandlerForMsgId.notifyAll();
        }
        if (this.ae != null) {
            this.ae.associationClosed(this);
        }
    }

    int getMaxPDULengthSend() {
        return this.maxPDULength;
    }

    boolean isPackPDV() {
        return this.ae.isPackPDV();
    }

    private void startARTIM(int timeout) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(this.name + ": start ARTIM " + timeout + "ms");
        }
        this.socket.setSoTimeout(timeout);
    }

    private void stopARTIM() throws IOException {
        this.socket.setSoTimeout(0);
        log.debug("{}: stop ARTIM", (Object)this.name);
    }

    void receivedAssociateRQ(AAssociateRQ rq) throws IOException {
        log.info("{}: A-ASSOCIATE-RQ {} >> {}", (Object[])new String[]{this.name, rq.getCallingAET(), rq.getCalledAET()});
        log.debug("{}", (Object)rq);
        this.state.receivedAssociateRQ(this, rq);
    }

    void receivedAssociateAC(AAssociateAC ac) throws IOException {
        log.info("{}: A-ASSOCIATE-AC {} >> {}", (Object[])new String[]{this.name, ac.getCallingAET(), ac.getCalledAET()});
        log.debug("{}", (Object)ac);
        this.state.receivedAssociateAC(this, ac);
    }

    void receivedAssociateRJ(AAssociateRJ rj) throws IOException {
        log.info("{} >> {}", (Object)this.name, (Object)rj);
        this.state.receivedAssociateRJ(this, rj);
    }

    void receivedPDataTF() throws IOException {
        this.state.receivedPDataTF(this);
    }

    void onPDataTF() throws IOException {
        this.decoder.decodeDIMSE();
    }

    void receivedReleaseRQ() throws IOException {
        log.info("{} >> A-RELEASE-RQ", (Object)this.name);
        this.state.receivedReleaseRQ(this);
    }

    void receivedReleaseRP() throws IOException {
        log.info("{} >> A-RELEASE-RP", (Object)this.name);
        this.state.receivedReleaseRP(this);
    }

    void receivedAbort(AAbort aa) {
        log.info("{}: >> {}", (Object)this.name, (Object)aa);
        this.exception = aa;
        this.setState(State.STA1);
        this.ae.removeFromPool(this);
    }

    void onDimseRQ(int pcid, DicomObject cmd, PDVInputStream data, String tsuid) throws IOException {
        this.incPerforming();
        this.ae.perform(this, pcid, cmd, data, tsuid);
    }

    private synchronized void incPerforming() {
        ++this.performing;
    }

    private synchronized void decPerforming() {
        --this.performing;
        this.notifyAll();
    }

    void sendPDataTF() throws IOException {
        try {
            this.state.sendPDataTF(this);
        }
        catch (IOException e) {
            this.closeSocket();
            throw e;
        }
    }

    void writePDataTF() throws IOException {
        this.encoder.writePDataTF();
    }

    void sendAssociateRQ(AAssociateRQ rq) throws IOException {
        try {
            this.state.sendAssociateRQ(this, rq);
        }
        catch (IOException e) {
            this.closeSocket();
            throw e;
        }
    }

    void sendReleaseRQ() {
        try {
            this.state.sendReleaseRQ(this);
        }
        catch (IOException e) {
            this.closeSocket();
        }
    }

    void abort(AAbort aa) {
        if (this.ae != null) {
            this.ae.removeFromPool(this);
        }
        this.state.abort(this, aa);
    }

    void writeAbort(AAbort aa) {
        this.exception = aa;
        this.setState(State.STA13);
        try {
            this.encoder.write(aa);
        }
        catch (IOException e) {
            log.debug("Failed to write " + aa, (Throwable)e);
        }
        this.closeSocket();
    }

    void unexpectedPDU(String name) throws AAbort {
        log.warn("received unexpected " + name + " in state: " + this.state);
        throw new AAbort(2, 2);
    }

    void illegalStateForSending(String name) throws IOException {
        log.warn("unable to send " + name + " in state: " + this.state);
        this.checkException();
        throw new AAbort();
    }

    void writeAssociationRQ(AAssociateRQ rq) throws IOException {
        this.associateRQ = rq;
        this.name = rq.getCalledAET() + '(' + this.serialNo + ")";
        this.setState(State.STA5);
        this.encoder.write(rq);
    }

    void onAAssociateRQ(AAssociateRQ rq) throws IOException {
        this.associateRQ = rq;
        this.name = rq.getCallingAET() + '(' + this.serialNo + ")";
        this.stopARTIM();
        this.setState(State.STA3);
        try {
            if ((rq.getProtocolVersion() & 1) == 0) {
                throw new AAssociateRJ(1, 2, 2);
            }
            if (!rq.getApplicationContext().equals("1.2.840.10008.3.1.1.1")) {
                throw new AAssociateRJ(1, 1, 2);
            }
            NetworkApplicationEntity ae = this.connector.getDevice().getNetworkApplicationEntity(rq.getCalledAET());
            if (ae == null) {
                throw new AAssociateRJ(1, 1, 7);
            }
            if (!this.connector.checkConnectionCountWithinLimit()) {
                throw new AAssociateRJ(2, 3, 1);
            }
            this.setApplicationEntity(ae);
            this.associateAC = ae.negotiate(this, rq);
            this.processAC();
            this.maxOpsInvoked = this.associateAC.getMaxOpsPerformed();
            this.maxPDULength = this.minZeroAsMax(rq.getMaxPDULength(), ae.getMaxPDULengthSend());
            this.setState(State.STA6);
            this.encoder.write(this.associateAC);
            this.updateIdleTimeout();
            this.reaper.register(this);
            ae.addToPool(this);
            ae.associationAccepted(this);
        }
        catch (AAssociateRJ e) {
            this.setState(State.STA13);
            this.encoder.write(e);
        }
    }

    void onAssociateAC(AAssociateAC ac) throws IOException {
        this.associateAC = ac;
        this.stopARTIM();
        this.processAC();
        this.maxOpsInvoked = this.associateAC.getMaxOpsInvoked();
        this.maxPDULength = this.minZeroAsMax(this.associateAC.getMaxPDULength(), this.ae.getMaxPDULengthSend());
        this.setState(State.STA6);
        this.updateIdleTimeout();
        this.reaper.register(this);
    }

    private int minZeroAsMax(int i1, int i2) {
        return i1 == 0 ? i2 : (i2 == 0 ? i1 : Math.min(i1, i2));
    }

    private void updateIdleTimeout() {
        this.idleTimeout = System.currentTimeMillis() + (long)this.ae.getIdleTimeout();
    }

    void onAssociateRJ(AAssociateRJ rj) throws IOException {
        this.stopARTIM();
        this.exception = rj;
        this.setState(State.STA1);
    }

    void writeReleaseRQ() throws IOException {
        this.setState(State.STA7);
        this.encoder.writeAReleaseRQ();
    }

    void onReleaseRP() throws IOException {
        this.stopARTIM();
        this.setState(State.STA1);
    }

    void onCollisionReleaseRP() throws IOException {
        this.stopARTIM();
        log.info("{} << A-RELEASE-RP", (Object)this.name);
        this.setState(State.STA13);
        this.encoder.writeAReleaseRP();
    }

    void onReleaseRQ() throws IOException {
        this.setState(State.STA8);
        if (this.ae != null) {
            this.ae.removeFromPool(this);
        }
        this.waitForPerformingOps();
        this.setState(State.STA13);
        this.encoder.writeAReleaseRP();
    }

    private synchronized void waitForPerformingOps() {
        while (this.performing > 0 && this.isReadyForDataReceive()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void onCollisionReleaseRQ() throws IOException {
        if (this.requestor) {
            this.setState(State.STA11);
            this.encoder.writeAReleaseRP();
        } else {
            this.setState(State.STA10);
        }
    }

    void checkIdle(final long now) {
        if (this.performing > 0) {
            return;
        }
        if (this.rspHandlerForMsgId.isEmpty()) {
            if (now > this.idleTimeout) {
                try {
                    this.release(false);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.rspHandlerForMsgId.accept(new IntHashtable.Visitor(){

                public boolean visit(int key, Object value) {
                    DimseRSPHandler rspHandler = (DimseRSPHandler)value;
                    if (now < rspHandler.getTimeout()) {
                        return true;
                    }
                    Association.this.abort();
                    return false;
                }
            });
        }
    }

    public NetworkConnection getConnector() {
        return this.connector;
    }

    public int getSerialNo() {
        return this.serialNo;
    }
}

