/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.directoryresource;

import com.mirth.connect.model.LibraryProperties;
import com.mirth.connect.plugins.LibraryPlugin;
import com.mirth.connect.plugins.directoryresource.DirectoryResourceProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryResourcePlugin
implements LibraryPlugin {
    private static final int MAX_FILES = 1000;
    private Logger logger = LogManager.getLogger(this.getClass());

    public String getPluginPointName() {
        return "Directory Resource";
    }

    public void start() {
    }

    public void stop() {
    }

    public List<URL> getLibraries(LibraryProperties properties, boolean startup) throws Exception {
        DirectoryResourceProperties props = (DirectoryResourceProperties)properties;
        ArrayList<URL> libraries = new ArrayList<URL>();
        File directory = new File(props.getDirectory());
        if (directory.exists() && directory.isDirectory()) {
            for (File file : FileUtils.listFiles((File)directory, (IOFileFilter)new NotFileFilter((IOFileFilter)new WildcardFileFilter(".*")), (IOFileFilter)(props.isDirectoryRecursion() ? FileFilterUtils.trueFileFilter() : null))) {
                if (!file.isFile()) continue;
                try {
                    libraries.add(file.toURI().toURL());
                    if (libraries.size() < 1000) continue;
                    this.logger.error("Directory resource " + properties.getName() + " has reached the maximum amount of files allowed (1000). Additional files will not be loaded.");
                    break;
                }
                catch (MalformedURLException e) {
                    this.logger.warn("Unable to load library: " + file.getName(), (Throwable)e);
                }
            }
        } else {
            this.logger.warn("Directory \"" + props.getDirectory() + "\" does not exist or is not a directory.");
        }
        return libraries;
    }

    public void update(LibraryProperties properties, boolean startup) throws Exception {
    }

    public void remove(LibraryProperties properties) throws Exception {
    }
}

