/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.jdbc;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.model.DriverInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class DatabaseDriversDialog
extends MirthDialog {
    private List<DriverInfo> currentDrivers;
    private boolean saved;
    private MirthTable driversTable;
    private JScrollPane driversScrollPane;
    private JPanel buttonPanel;
    private JButton addButton;
    private JButton removeButton;
    private JSeparator separator;
    private JButton saveButton;
    private JButton closeButton;

    public DatabaseDriversDialog(Window owner, List<DriverInfo> currentDrivers) {
        super(owner, "Database Drivers", true);
        currentDrivers = currentDrivers == null ? new ArrayList<DriverInfo>() : new ArrayList<DriverInfo>(currentDrivers);
        if (currentDrivers.size() > 0) {
            if (StringUtils.equals((CharSequence)currentDrivers.get(0).getName(), (CharSequence)"Please Select One")) {
                currentDrivers.remove(0);
            }
            if (StringUtils.equals((CharSequence)currentDrivers.get(currentDrivers.size() - 1).getName(), (CharSequence)"Custom")) {
                currentDrivers.remove(currentDrivers.size() - 1);
            }
        }
        this.currentDrivers = currentDrivers;
        this.initComponents();
        this.initToolTips();
        this.initLayout();
        this.setDrivers(currentDrivers);
        this.saveButton.setEnabled(false);
        final String workingId = PlatformUI.MIRTH_FRAME.startWorking("Retrieving database drivers...");
        SwingWorker<List<DriverInfo>, Void> worker = new SwingWorker<List<DriverInfo>, Void>(){

            @Override
            protected List<DriverInfo> doInBackground() throws Exception {
                return PlatformUI.MIRTH_FRAME.mirthClient.getDatabaseDrivers();
            }

            @Override
            protected void done() {
                try {
                    DatabaseDriversDialog.this.setDrivers((List)this.get());
                    DatabaseDriversDialog.this.saveButton.setEnabled(true);
                    PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                }
                catch (Exception e) {
                    PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                    PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)DatabaseDriversDialog.this), (Throwable)e);
                }
            }
        };
        worker.execute();
        this.setPreferredSize(new Dimension(950, 216));
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public boolean wasSaved() {
        return this.saved;
    }

    public List<DriverInfo> getDrivers() {
        ArrayList<DriverInfo> drivers = new ArrayList<DriverInfo>();
        for (int row = 0; row < this.driversTable.getModel().getRowCount(); ++row) {
            String name = StringUtils.trim((String)((String)this.driversTable.getModel().getValueAt(row, 0)));
            String className = StringUtils.trim((String)((String)this.driversTable.getModel().getValueAt(row, 1)));
            String template = StringUtils.trim((String)((String)this.driversTable.getModel().getValueAt(row, 2)));
            String selectLimit = StringUtils.trim((String)((String)this.driversTable.getModel().getValueAt(row, 3)));
            ArrayList<String> alternativeClassNames = new ArrayList<String>(Arrays.asList(StringUtils.split((String)StringUtils.trim((String)((String)this.driversTable.getModel().getValueAt(row, 4))), (char)',')));
            drivers.add(new DriverInfo(name, className, template, selectLimit, alternativeClassNames));
        }
        return drivers;
    }

    private void setDrivers(List<DriverInfo> drivers) {
        if (drivers == null) {
            drivers = new ArrayList<DriverInfo>();
        }
        Object[][] data = new Object[drivers.size()][5];
        for (int i = 0; i < drivers.size(); ++i) {
            DriverInfo info = drivers.get(i);
            data[i][0] = StringUtils.trim((String)StringUtils.defaultString((String)info.getName()));
            data[i][1] = StringUtils.trim((String)StringUtils.defaultString((String)info.getClassName()));
            data[i][2] = StringUtils.trim((String)StringUtils.defaultString((String)info.getTemplate()));
            data[i][3] = StringUtils.trim((String)StringUtils.defaultString((String)info.getSelectLimit()));
            String alternativeClassNamesStr = "";
            List alternativeClassNames = info.getAlternativeClassNames();
            if (CollectionUtils.isNotEmpty((Collection)alternativeClassNames)) {
                alternativeClassNamesStr = StringUtils.join((Iterable)alternativeClassNames, (char)',');
            }
            data[i][4] = alternativeClassNamesStr;
        }
        ((RefreshTableModel)this.driversTable.getModel()).refreshDataVector(data);
    }

    private boolean checkDrivers(List<DriverInfo> drivers) {
        Object errors = "";
        if (CollectionUtils.isEmpty(drivers)) {
            errors = (String)errors + "You must have at least one driver entry.";
        } else {
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < drivers.size(); ++i) {
                DriverInfo driver = drivers.get(i);
                if (StringUtils.isBlank((CharSequence)driver.getName())) {
                    errors = (String)errors + "Row " + (i + 1) + ": Name cannot be blank.\n";
                }
                if (!names.add(driver.getName())) {
                    errors = (String)errors + "Row " + (i + 1) + ": Name must be unique.\n";
                }
                if (StringUtils.isBlank((CharSequence)driver.getClassName())) {
                    errors = (String)errors + "Row " + (i + 1) + ": Driver Class cannot be blank.\n";
                }
                if (!StringUtils.isBlank((CharSequence)driver.getTemplate())) continue;
                errors = (String)errors + "Row " + (i + 1) + ": JDBC URL Template cannot be blank.\n";
            }
        }
        if (((String)errors).isEmpty()) {
            return true;
        }
        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)this), (String)errors);
        return false;
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        this.driversTable = new MirthTable();
        this.driversTable.setModel((TableModel)new RefreshTableModel(new Object[]{"Name", "Driver Class", "JDBC URL Template", "Select with Limit Query", "Legacy Driver Classes"}, 0));
        this.driversTable.setDragEnabled(false);
        this.driversTable.setRowSelectionAllowed(true);
        this.driversTable.setSelectionMode(0);
        this.driversTable.setRowHeight(20);
        this.driversTable.setFocusable(true);
        this.driversTable.setOpaque(true);
        this.driversTable.getTableHeader().setReorderingAllowed(false);
        this.driversTable.setEditable(true);
        this.driversTable.setSortable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.driversTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.driversTable.getSelectionModel().addListSelectionListener(evt -> this.removeButton.setEnabled(this.getSelectedRow() >= 0));
        this.driversTable.getColumnExt(0).setPreferredWidth(101);
        this.driversTable.getColumnExt(1).setPreferredWidth(162);
        this.driversTable.getColumnExt(2).setPreferredWidth(269);
        this.driversTable.getColumnExt(3).setPreferredWidth(200);
        this.driversTable.getColumnExt(4).setPreferredWidth(137);
        this.driversScrollPane = new JScrollPane((Component)this.driversTable);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBackground(this.getBackground());
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(evt -> this.addDriver());
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(evt -> this.removeDriver());
        this.removeButton.setEnabled(this.getSelectedRow() >= 0);
        this.separator = new JSeparator();
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(evt -> this.save());
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(evt -> this.close());
        this.getRootPane().registerKeyboardAction(evt -> this.close(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void initToolTips() {
        this.driversTable.getColumnExt(0).setToolTipText("<html>The name of the driver entry. This will appear in the<br/>drop-down menu for the Database Reader/Writer connectors.</html>");
        this.driversTable.getColumnExt(1).setToolTipText("<html>The fully-qualified Java class name for the JDBC driver.</html>");
        this.driversTable.getColumnExt(2).setToolTipText("<html>The template for the JDBC connection URL that can be<br/>auto-populated from the Database Reader/Writer settings.</html>");
        this.driversTable.getColumnExt(3).setToolTipText("<html>A select query (with limit 1) that can be used to<br/>retrieve column metadata. If empty the driver-specific<br/>generic query will be used, which could be slow.</html>");
        this.driversTable.getColumnExt(4).setToolTipText("<html>A comma-separated list of alternate or legacy JDBC driver class names.<br/>Any Database Reader/Writer connector using one of these driver classes<br/>will have the corresponding entry selected in the Driver drop-down menu.<br/>The driver will be updated to the primary value upon next channel save.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill"));
        this.add(this.driversScrollPane, "grow, push");
        this.buttonPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        this.buttonPanel.add((Component)this.addButton, "sg");
        this.buttonPanel.add((Component)this.removeButton, "newline, sg");
        this.add(this.buttonPanel, "top");
        this.add(this.separator, "newline, sx, growx");
        this.add(this.saveButton, "newline, sx, right, split 2");
        this.add(this.closeButton);
    }

    private void addDriver() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0) {
            ((RefreshTableModel)this.driversTable.getModel()).insertRow(selectedRow + 1, new Object[]{"", "", "", "", ""});
            this.driversTable.getSelectionModel().setSelectionInterval(selectedRow + 1, selectedRow + 1);
            this.driversTable.scrollRowToVisible(selectedRow + 1);
        } else {
            ((RefreshTableModel)this.driversTable.getModel()).addRow(new Object[]{"", "", "", "", ""});
            this.driversTable.getSelectionModel().setSelectionInterval(this.driversTable.getRowCount() - 1, this.driversTable.getRowCount() - 1);
            this.driversTable.scrollRowToVisible(this.driversTable.getRowCount() - 1);
        }
    }

    private void removeDriver() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0) {
            ((RefreshTableModel)this.driversTable.getModel()).removeRow(selectedRow);
            if (selectedRow < this.driversTable.getRowCount()) {
                this.driversTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            } else if (this.driversTable.getRowCount() > 0) {
                this.driversTable.getSelectionModel().setSelectionInterval(this.driversTable.getRowCount() - 1, this.driversTable.getRowCount() - 1);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private void save() {
        final List<DriverInfo> drivers = this.getDrivers();
        if (this.checkDrivers(drivers)) {
            final String workingId = PlatformUI.MIRTH_FRAME.startWorking("Updating database drivers...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    PlatformUI.MIRTH_FRAME.mirthClient.setDatabaseDrivers(drivers);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                        DatabaseDriversDialog.this.saved = true;
                        DatabaseDriversDialog.this.dispose();
                    }
                    catch (Exception e) {
                        PlatformUI.MIRTH_FRAME.stopWorking(workingId);
                        PlatformUI.MIRTH_FRAME.alertThrowable((Component)((Object)DatabaseDriversDialog.this), (Throwable)e);
                        DatabaseDriversDialog.this.saveButton.setEnabled(true);
                    }
                }
            };
            this.saveButton.setEnabled(false);
            worker.execute();
        }
    }

    private void close() {
        if (Objects.equals(this.currentDrivers, this.getDrivers()) || PlatformUI.MIRTH_FRAME.alertOkCancel((Component)((Object)this), "<html>The driver information has changed.<br/>Are you sure you want to close without saving?</html>")) {
            this.dispose();
        }
    }

    private int getSelectedRow() {
        if (this.driversTable.isEditing()) {
            return this.driversTable.getEditingRow();
        }
        return this.driversTable.getSelectedRow();
    }
}

