/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.tool.dcmrcv;

import java.io.IOException;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.PDVInputStream;
import org.dcm4che2.net.service.StorageService;
import org.dcm4che2.tool.dcmrcv.DcmRcv;

class StorageSCP
extends StorageService {
    private final DcmRcv dcmrcv;

    public StorageSCP(DcmRcv dcmrcv, String[] sopClasses) {
        super(sopClasses);
        this.dcmrcv = dcmrcv;
    }

    public void cstore(final Association as, final int pcid, DicomObject rq, PDVInputStream dataStream, String tsuid) throws DicomServiceException, IOException {
        final DicomObject rsp = CommandUtils.mkRSP((DicomObject)rq, (int)0);
        this.onCStoreRQ(as, pcid, rq, dataStream, tsuid, rsp);
        if (this.dcmrcv.getDimseRspDelay() > 0) {
            this.dcmrcv.executor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(StorageSCP.this.dcmrcv.getDimseRspDelay());
                        as.writeDimseRSP(pcid, rsp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            as.writeDimseRSP(pcid, rsp);
        }
        this.onCStoreRSP(as, pcid, rq, dataStream, tsuid, rsp);
    }

    protected void onCStoreRQ(Association as, int pcid, DicomObject rq, PDVInputStream dataStream, String tsuid, DicomObject rsp) throws IOException, DicomServiceException {
        if (this.dcmrcv.isStoreFile()) {
            this.dcmrcv.onCStoreRQ(as, pcid, rq, dataStream, tsuid, rsp);
        } else {
            super.onCStoreRQ(as, pcid, rq, dataStream, tsuid, rsp);
        }
    }
}

