/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.messagetrends.server.maintenance;

import com.mirth.connect.plugins.messagetrends.server.core.MessageTrendsBuffer;
import com.mirth.connect.plugins.messagetrends.server.maintenance.QueuedBackfillHelper;
import com.mirth.connect.plugins.messagetrends.server.maintenance.RollKey;
import com.mirth.connect.plugins.messagetrends.server.service.MessageTrendsService;
import com.mirth.connect.plugins.messagetrends.shared.model.MessageStatisticsTimeseries;
import com.mirth.connect.server.userutil.ChannelUtil;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class MinuteFlushRunner {
    private static final Logger logger = LogManager.getLogger(MinuteFlushRunner.class);
    private static final int FIXED_RATE_SECONDS = 60;
    private final MessageTrendsService service;
    private final MessageTrendsBuffer buffer = MessageTrendsBuffer.getInstance();
    private final QueuedBackfillHelper queuedBackfillHelper;
    private final Clock clock;
    private final String serverId;
    private Date lastFlushedTs = null;

    MinuteFlushRunner(MessageTrendsService messageTrendsService, Clock clock, String string3) {
        this.service = messageTrendsService;
        this.clock = clock == null ? Clock.systemUTC() : clock;
        this.serverId = string3;
        this.queuedBackfillHelper = new QueuedBackfillHelper((string, string2) -> MinuteFlushRunner.getQueuedCount(string, string2));
    }

    int getFixedRateSeconds() {
        return 60;
    }

    long initialDelaySecondsToNextMinuteBoundary() {
        Instant instant = this.clock.instant();
        Instant instant2 = instant.truncatedTo(ChronoUnit.MINUTES).plus(1L, ChronoUnit.MINUTES);
        return Math.max(0L, Duration.between(instant, instant2).getSeconds());
    }

    void runOnce() {
        try {
            Instant instant = this.clock.instant().truncatedTo(ChronoUnit.MINUTES).minus(1L, ChronoUnit.MINUTES);
            Date date = Date.from(instant);
            if (this.lastFlushedTs != null && date.equals(this.lastFlushedTs)) {
                return;
            }
            List<MessageStatisticsTimeseries> list = this.buffer.snapshotAndReset(date, 1, this.serverId);
            LinkedHashMap<RollKey, MessageStatisticsTimeseries> linkedHashMap = new LinkedHashMap<RollKey, MessageStatisticsTimeseries>();
            for (MessageStatisticsTimeseries messageStatisticsTimeseries : list) {
                String string;
                String string2;
                String string3 = messageStatisticsTimeseries.getServerId();
                RollKey rollKey = new RollKey(string3, string2 = messageStatisticsTimeseries.getChannelId(), string = messageStatisticsTimeseries.getConnectorId(), date, 1);
                MessageStatisticsTimeseries messageStatisticsTimeseries2 = (MessageStatisticsTimeseries)linkedHashMap.get(rollKey);
                if (messageStatisticsTimeseries2 == null) {
                    messageStatisticsTimeseries2 = new MessageStatisticsTimeseries();
                    messageStatisticsTimeseries2.setServerId(string3);
                    messageStatisticsTimeseries2.setChannelId(string2);
                    messageStatisticsTimeseries2.setConnectorId(string);
                    messageStatisticsTimeseries2.setTs(date);
                    messageStatisticsTimeseries2.setBucketSizeMinutes(Integer.valueOf(1));
                    messageStatisticsTimeseries2.setReceived(Integer.valueOf(0));
                    messageStatisticsTimeseries2.setFiltered(Integer.valueOf(0));
                    messageStatisticsTimeseries2.setQueued(Integer.valueOf(0));
                    messageStatisticsTimeseries2.setSent(Integer.valueOf(0));
                    messageStatisticsTimeseries2.setError(Integer.valueOf(0));
                    linkedHashMap.put(rollKey, messageStatisticsTimeseries2);
                }
                messageStatisticsTimeseries2.setReceived(Integer.valueOf(MinuteFlushRunner.nz(messageStatisticsTimeseries2.getReceived()) + MinuteFlushRunner.nz(messageStatisticsTimeseries.getReceived())));
                messageStatisticsTimeseries2.setFiltered(Integer.valueOf(MinuteFlushRunner.nz(messageStatisticsTimeseries2.getFiltered()) + MinuteFlushRunner.nz(messageStatisticsTimeseries.getFiltered())));
                messageStatisticsTimeseries2.setSent(Integer.valueOf(MinuteFlushRunner.nz(messageStatisticsTimeseries2.getSent()) + MinuteFlushRunner.nz(messageStatisticsTimeseries.getSent())));
                messageStatisticsTimeseries2.setError(Integer.valueOf(MinuteFlushRunner.nz(messageStatisticsTimeseries2.getError()) + MinuteFlushRunner.nz(messageStatisticsTimeseries.getError())));
            }
            for (MessageStatisticsTimeseries messageStatisticsTimeseries : linkedHashMap.values()) {
                long l = 0L;
                try {
                    l = MinuteFlushRunner.getQueuedCount(messageStatisticsTimeseries.getChannelId(), messageStatisticsTimeseries.getConnectorId());
                }
                catch (Exception exception) {
                    logger.warn("Failed to read queued snapshot for channelId={} connectorId={}", (Object)messageStatisticsTimeseries.getChannelId(), (Object)messageStatisticsTimeseries.getConnectorId(), (Object)exception);
                }
                int n = l < 0L ? 0 : (l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l);
                messageStatisticsTimeseries.setQueued(Integer.valueOf(n));
            }
            this.queuedBackfillHelper.backfillMinute(date, linkedHashMap);
            ArrayList arrayList = new ArrayList(linkedHashMap.values());
            int n = 0;
            if (!arrayList.isEmpty()) {
                n = this.service.replaceRollupWindow(date, 1, arrayList);
            }
            this.queuedBackfillHelper.updateAfterFlush(arrayList);
            this.lastFlushedTs = date;
            logger.debug("MinuteFlushRunner: flushed {} rows for {}", (Object)n, (Object)date);
        }
        catch (Throwable throwable) {
            logger.warn("MinuteFlushRunner runOnce failed", throwable);
        }
    }

    private static long getQueuedCount(String string, String string2) {
        return ChannelUtil.getQueuedCount((String)string, (Number)MinuteFlushRunner.toConnectorNumber(string2));
    }

    private static Number toConnectorNumber(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static int nz(Integer n) {
        return n == null ? 0 : n;
    }
}

