/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.channel;

import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.migration.Migratable;
import com.mirth.connect.donkey.util.purge.Purgable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DestinationConnectorProperties
implements Serializable,
Migratable,
Purgable {
    private boolean queueEnabled;
    private boolean sendFirst;
    private int retryIntervalMillis;
    private boolean regenerateTemplate;
    private int retryCount;
    private boolean rotate;
    private boolean includeFilterTransformer;
    private int threadCount;
    private String threadAssignmentVariable;
    private boolean validateResponse;
    private Map<String, String> resourceIds;
    private int queueBufferSize;
    private boolean reattachAttachments;
    private Set<ConnectorPluginProperties> pluginProperties;

    public DestinationConnectorProperties() {
        this(false);
    }

    public DestinationConnectorProperties(boolean validateResponse) {
        this.queueEnabled = false;
        this.sendFirst = false;
        this.retryIntervalMillis = 10000;
        this.regenerateTemplate = false;
        this.retryCount = 0;
        this.rotate = false;
        this.includeFilterTransformer = false;
        this.threadCount = 1;
        this.threadAssignmentVariable = "";
        this.validateResponse = validateResponse;
        this.resourceIds = new LinkedHashMap<String, String>();
        this.resourceIds.put("Default Resource", "[Default Resource]");
        this.queueBufferSize = 0;
        this.reattachAttachments = true;
    }

    public DestinationConnectorProperties(DestinationConnectorProperties props) {
        this.queueEnabled = props.isQueueEnabled();
        this.sendFirst = props.isSendFirst();
        this.retryIntervalMillis = props.getRetryIntervalMillis();
        this.regenerateTemplate = props.isRegenerateTemplate();
        this.retryCount = props.getRetryCount();
        this.rotate = props.isRotate();
        this.includeFilterTransformer = props.isIncludeFilterTransformer();
        this.threadCount = props.getThreadCount();
        this.threadAssignmentVariable = props.getThreadAssignmentVariable();
        this.validateResponse = props.isValidateResponse();
        this.resourceIds = new LinkedHashMap<String, String>(props.getResourceIds());
        this.queueBufferSize = props.getQueueBufferSize();
        this.reattachAttachments = props.isReattachAttachments();
        if (props.getPluginProperties() != null) {
            this.pluginProperties = new HashSet<ConnectorPluginProperties>();
            for (ConnectorPluginProperties cpp : props.getPluginProperties()) {
                this.pluginProperties.add(cpp.clone());
            }
        }
    }

    public boolean isQueueEnabled() {
        return this.queueEnabled;
    }

    public void setQueueEnabled(boolean enabled) {
        this.queueEnabled = enabled;
    }

    public boolean isSendFirst() {
        return this.sendFirst;
    }

    public void setSendFirst(boolean sendFirst) {
        this.sendFirst = sendFirst;
    }

    public int getRetryIntervalMillis() {
        return this.retryIntervalMillis;
    }

    public void setRetryIntervalMillis(int retryIntervalMillis) {
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public boolean isRegenerateTemplate() {
        return this.regenerateTemplate;
    }

    public void setRegenerateTemplate(boolean regenerateTemplate) {
        this.regenerateTemplate = regenerateTemplate;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean isRotate() {
        return this.rotate;
    }

    public void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    public boolean isIncludeFilterTransformer() {
        return this.includeFilterTransformer;
    }

    public void setIncludeFilterTransformer(boolean includeFilterTransformer) {
        this.includeFilterTransformer = includeFilterTransformer;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public String getThreadAssignmentVariable() {
        return this.threadAssignmentVariable;
    }

    public void setThreadAssignmentVariable(String threadAssignmentVariable) {
        this.threadAssignmentVariable = threadAssignmentVariable;
    }

    public boolean isValidateResponse() {
        return this.validateResponse;
    }

    public void setValidateResponse(boolean validateResponse) {
        this.validateResponse = validateResponse;
    }

    public Map<String, String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Map<String, String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public int getQueueBufferSize() {
        return this.queueBufferSize;
    }

    public void setQueueBufferSize(int queueBufferSize) {
        this.queueBufferSize = queueBufferSize;
    }

    public boolean isReattachAttachments() {
        return this.reattachAttachments;
    }

    public void setReattachAttachments(boolean reattachAttachments) {
        this.reattachAttachments = reattachAttachments;
    }

    public Set<ConnectorPluginProperties> getPluginProperties() {
        return this.pluginProperties;
    }

    public void setPluginProperties(Set<ConnectorPluginProperties> pluginProperties) {
        this.pluginProperties = pluginProperties;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @Override
    public void migrate3_0_1(DonkeyElement element) {
    }

    @Override
    public void migrate3_0_2(DonkeyElement element) {
    }

    @Override
    public void migrate3_1_0(DonkeyElement element) {
        element.addChildElementIfNotExists("validateResponse", "false");
    }

    @Override
    public void migrate3_2_0(DonkeyElement element) {
        DonkeyElement resourceIdsElement = element.addChildElement("resourceIds");
        resourceIdsElement.setAttribute("class", "linked-hash-set");
        resourceIdsElement.addChildElement("string", "Default Resource");
    }

    @Override
    public void migrate3_3_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_4_0(DonkeyElement element) {
        DonkeyElement resourceIdsElement = element.getChildElement("resourceIds");
        List<DonkeyElement> resourceIdsList = resourceIdsElement.getChildElements();
        resourceIdsElement.removeChildren();
        resourceIdsElement.setAttribute("class", "linked-hash-map");
        for (DonkeyElement resourceId : resourceIdsList) {
            DonkeyElement entry = resourceIdsElement.addChildElement("entry");
            String resourceIdText = resourceId.getTextContent();
            entry.addChildElement("string", resourceIdText);
            if (resourceIdText.equals("Default Resource")) {
                entry.addChildElement("string", "[Default Resource]");
                continue;
            }
            entry.addChildElement("string");
        }
    }

    @Override
    public void migrate3_5_0(DonkeyElement element) {
        element.addChildElementIfNotExists("reattachAttachments", "true");
    }

    @Override
    public void migrate3_6_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_7_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_9_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_11_0(DonkeyElement element) {
    }

    @Override
    public void migrate3_11_1(DonkeyElement element) {
    }

    @Override
    public void migrate3_12_0(DonkeyElement element) {
    }

    @Override
    public Map<String, Object> getPurgedProperties() {
        HashMap<String, Object> purgedProperties = new HashMap<String, Object>();
        purgedProperties.put("queueEnabled", this.queueEnabled);
        purgedProperties.put("sendFirst", this.sendFirst);
        purgedProperties.put("retryIntervalMillis", this.retryIntervalMillis);
        purgedProperties.put("regenerateTemplate", this.regenerateTemplate);
        purgedProperties.put("retryCount", this.retryCount);
        purgedProperties.put("rotate", this.rotate);
        purgedProperties.put("includeFilterTransformer", this.includeFilterTransformer);
        purgedProperties.put("threadCount", this.threadCount);
        purgedProperties.put("validateResponse", this.validateResponse);
        purgedProperties.put("resourceIdsCount", this.resourceIds.size());
        purgedProperties.put("queueBufferSize", this.queueBufferSize);
        purgedProperties.put("reattachAttachments", this.reattachAttachments);
        HashSet<Map<String, Object>> purgedPluginProperties = new HashSet<Map<String, Object>>();
        if (this.pluginProperties != null) {
            for (ConnectorPluginProperties cpp : this.pluginProperties) {
                purgedPluginProperties.add(cpp.getPurgedProperties());
            }
        }
        purgedProperties.put("pluginProperties", purgedPluginProperties);
        return purgedProperties;
    }
}

