/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.model.message;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.WordUtils;

public enum ContentType {
    RAW(1),
    PROCESSED_RAW(2),
    TRANSFORMED(3),
    ENCODED(4),
    SENT(5),
    RESPONSE(6),
    RESPONSE_TRANSFORMED(7),
    PROCESSED_RESPONSE(8),
    CONNECTOR_MAP(9),
    CHANNEL_MAP(10),
    RESPONSE_MAP(11),
    PROCESSING_ERROR(12),
    POSTPROCESSOR_ERROR(13),
    RESPONSE_ERROR(14),
    SOURCE_MAP(15);

    private static int PROCESSING_ERROR_CODE;
    private static int POSTPROCESSOR_ERROR_CODE;
    private static int RESPONSE_ERROR_CODE;
    private int contentType;

    private ContentType(int contentType) {
        this.contentType = contentType;
    }

    public int getContentTypeCode() {
        return this.contentType;
    }

    public String toString() {
        return WordUtils.capitalize((String)super.toString().replace('_', ' ').toLowerCase());
    }

    public static ContentType fromCode(int contentType) {
        if (contentType == RAW.getContentTypeCode()) {
            return RAW;
        }
        if (contentType == PROCESSED_RAW.getContentTypeCode()) {
            return PROCESSED_RAW;
        }
        if (contentType == TRANSFORMED.getContentTypeCode()) {
            return TRANSFORMED;
        }
        if (contentType == ENCODED.getContentTypeCode()) {
            return ENCODED;
        }
        if (contentType == SENT.getContentTypeCode()) {
            return SENT;
        }
        if (contentType == RESPONSE.getContentTypeCode()) {
            return RESPONSE;
        }
        if (contentType == RESPONSE_TRANSFORMED.getContentTypeCode()) {
            return RESPONSE_TRANSFORMED;
        }
        if (contentType == PROCESSED_RESPONSE.getContentTypeCode()) {
            return PROCESSED_RESPONSE;
        }
        if (contentType == CONNECTOR_MAP.getContentTypeCode()) {
            return CONNECTOR_MAP;
        }
        if (contentType == CHANNEL_MAP.getContentTypeCode()) {
            return CHANNEL_MAP;
        }
        if (contentType == RESPONSE_MAP.getContentTypeCode()) {
            return RESPONSE_MAP;
        }
        if (contentType == PROCESSING_ERROR.getContentTypeCode()) {
            return PROCESSING_ERROR;
        }
        if (contentType == POSTPROCESSOR_ERROR.getContentTypeCode()) {
            return POSTPROCESSOR_ERROR;
        }
        if (contentType == RESPONSE_ERROR.getContentTypeCode()) {
            return RESPONSE_ERROR;
        }
        if (contentType == SOURCE_MAP.getContentTypeCode()) {
            return SOURCE_MAP;
        }
        return null;
    }

    public static ContentType[] getMessageTypes() {
        return new ContentType[]{RAW, PROCESSED_RAW, TRANSFORMED, ENCODED, SENT, RESPONSE, RESPONSE_TRANSFORMED, PROCESSED_RESPONSE};
    }

    public static ContentType[] getMapTypes() {
        return new ContentType[]{CONNECTOR_MAP, CHANNEL_MAP, RESPONSE_MAP, SOURCE_MAP};
    }

    public static ContentType[] getErrorTypes() {
        return new ContentType[]{PROCESSING_ERROR, POSTPROCESSOR_ERROR, RESPONSE_ERROR};
    }

    public int getErrorCode() {
        if (this.contentType == PROCESSING_ERROR.getContentTypeCode()) {
            return PROCESSING_ERROR_CODE;
        }
        if (this.contentType == POSTPROCESSOR_ERROR.getContentTypeCode()) {
            return POSTPROCESSOR_ERROR_CODE;
        }
        if (this.contentType == RESPONSE_ERROR.getContentTypeCode()) {
            return RESPONSE_ERROR_CODE;
        }
        return 0;
    }

    public static ContentType[] getDisplayValues() {
        return (ContentType[])ArrayUtils.addAll((Object[])((ContentType[])ArrayUtils.addAll((Object[])ContentType.getMessageTypes(), (Object[])ContentType.getMapTypes())), (Object[])ContentType.getErrorTypes());
    }

    static {
        PROCESSING_ERROR_CODE = 1;
        POSTPROCESSOR_ERROR_CODE = 2;
        RESPONSE_ERROR_CODE = 4;
    }
}

