/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util;

import com.mirth.connect.donkey.model.channel.CronProperty;
import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesAdvanced;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.CronScheduleBuilder;
import org.quartz.DailyTimeIntervalScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TimeOfDay;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.DailyCalendar;
import org.quartz.impl.calendar.MonthlyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;

public class TriggerFactory {
    private PollConnectorProperties pollConnectorProperties;
    private PollConnectorPropertiesAdvanced advancedProperties;
    private String id;
    private JobDetail job;
    private Trigger dailyIntervalTrigger;
    private BaseCalendar baseCalendar;
    private BaseCalendar finalTriggerCalendar;

    public TriggerFactory(PollConnectorProperties pollConnectorProperties, String id) {
        this(null, pollConnectorProperties, id);
    }

    public TriggerFactory(JobDetail job, PollConnectorProperties pollConnectorProperties, String id) {
        this.id = id;
        this.job = job;
        this.pollConnectorProperties = pollConnectorProperties;
        this.advancedProperties = pollConnectorProperties.getPollConnectorPropertiesAdvanced();
        this.baseCalendar = new BaseCalendar();
        if (this.advancedProperties.isWeekly()) {
            this.baseCalendar = new WeeklyCalendar();
            ((WeeklyCalendar)this.baseCalendar).setDaysExcluded(this.advancedProperties.getInactiveDays());
        } else {
            boolean[] days = new boolean[32];
            Arrays.fill(days, true);
            days[this.advancedProperties.getDayOfMonth() - 1] = false;
            this.baseCalendar = new MonthlyCalendar();
            ((MonthlyCalendar)this.baseCalendar).setDaysExcluded(days);
        }
        this.finalTriggerCalendar = this.baseCalendar;
    }

    public Trigger createDailyInterval() {
        boolean invertTime = true;
        boolean allDay = this.advancedProperties.isAllDay();
        int startingHour = allDay ? 0 : this.advancedProperties.getStartingHour();
        int startingMinute = allDay ? 0 : this.advancedProperties.getStartingMinute();
        int endingHour = allDay ? 23 : this.advancedProperties.getEndingHour();
        int endingMinute = allDay ? 59 : this.advancedProperties.getEndingMinute();
        java.util.Calendar startTime = java.util.Calendar.getInstance();
        startTime.set(11, startingHour);
        startTime.set(12, startingMinute);
        startTime.set(13, 0);
        startTime.set(14, 0);
        if (this.advancedProperties.getStartingHour() > endingHour) {
            endingHour = startingHour;
            endingMinute = startingMinute;
            startingHour = this.advancedProperties.getEndingHour();
            startingMinute = this.advancedProperties.getEndingMinute();
            invertTime = false;
            startTime.set(11, 0);
            startTime.set(12, 0);
        }
        this.finalTriggerCalendar = new DailyCalendar((Calendar)this.baseCalendar, startingHour, startingMinute, 0, 0, endingHour, endingMinute, 0, 0);
        ((DailyCalendar)this.finalTriggerCalendar).setInvertTimeRange(invertTime);
        SimpleScheduleBuilder schedule = SimpleScheduleBuilder.simpleSchedule();
        schedule.withIntervalInMilliseconds((long)this.pollConnectorProperties.getPollingFrequency());
        schedule.withMisfireHandlingInstructionNextWithExistingCount().withRepeatCount(-1);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.forJob(this.job).withIdentity("PollingJobTrigger", this.id);
        triggerBuilder.withDescription("Daily interval trigger");
        triggerBuilder.withSchedule((ScheduleBuilder)schedule);
        this.dailyIntervalTrigger = triggerBuilder.modifiedByCalendar("Calendar").startAt(startTime.getTime()).build();
        return this.dailyIntervalTrigger;
    }

    public Trigger createTimeTrigger() {
        DailyTimeIntervalScheduleBuilder dailySchedule = DailyTimeIntervalScheduleBuilder.dailyTimeIntervalSchedule();
        dailySchedule.withInterval(24, DateBuilder.IntervalUnit.HOUR);
        dailySchedule.withMisfireHandlingInstructionDoNothing().withRepeatCount(-1);
        dailySchedule.startingDailyAt(new TimeOfDay(this.pollConnectorProperties.getPollingHour(), this.pollConnectorProperties.getPollingMinute()));
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.forJob(this.job).withIdentity("PollingJobTrigger", this.id);
        triggerBuilder.withDescription("Daily time trigger");
        triggerBuilder.withSchedule((ScheduleBuilder)dailySchedule);
        this.dailyIntervalTrigger = triggerBuilder.modifiedByCalendar("Calendar").build();
        return this.dailyIntervalTrigger;
    }

    public List<Trigger> createCronTriggers() {
        ArrayList<Trigger> triggerList = new ArrayList<Trigger>();
        for (CronProperty property : this.pollConnectorProperties.getCronJobs()) {
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
            triggerBuilder.forJob(this.job).withIdentity("CronTrigger#" + triggerList.size(), this.id);
            triggerBuilder.withDescription(property.getDescription());
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)property.getExpression()).withMisfireHandlingInstructionDoNothing());
            triggerList.add(triggerBuilder.build());
        }
        return triggerList;
    }

    public BaseCalendar getCalendar() {
        return this.finalTriggerCalendar;
    }
}

