/*
 * Decompiled with CFR 0.152.
 */
package javax.wsdl.extensions;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.UnknownExtensionDeserializer;
import javax.wsdl.extensions.UnknownExtensionSerializer;
import javax.xml.namespace.QName;

public class ExtensionRegistry
implements Serializable {
    public static final long serialVersionUID = 1L;
    protected Map serializerReg = new Hashtable();
    protected Map deserializerReg = new Hashtable();
    protected Map extensionTypeReg = new Hashtable();
    protected ExtensionSerializer defaultSer = null;
    protected ExtensionDeserializer defaultDeser = null;
    protected Map extensionAttributeTypeReg = new Hashtable();

    public ExtensionRegistry() {
        this.setDefaultSerializer(new UnknownExtensionSerializer());
        this.setDefaultDeserializer(new UnknownExtensionDeserializer());
    }

    public void setDefaultSerializer(ExtensionSerializer extensionSerializer) {
        this.defaultSer = extensionSerializer;
    }

    public ExtensionSerializer getDefaultSerializer() {
        return this.defaultSer;
    }

    public void setDefaultDeserializer(ExtensionDeserializer extensionDeserializer) {
        this.defaultDeser = extensionDeserializer;
    }

    public ExtensionDeserializer getDefaultDeserializer() {
        return this.defaultDeser;
    }

    public void registerSerializer(Class clazz, QName qName, ExtensionSerializer extensionSerializer) {
        Hashtable<QName, ExtensionSerializer> hashtable = (Hashtable<QName, ExtensionSerializer>)this.serializerReg.get(clazz);
        if (hashtable == null) {
            hashtable = new Hashtable<QName, ExtensionSerializer>();
            this.serializerReg.put(clazz, hashtable);
        }
        hashtable.put(qName, extensionSerializer);
    }

    public void registerDeserializer(Class clazz, QName qName, ExtensionDeserializer extensionDeserializer) {
        Hashtable<QName, ExtensionDeserializer> hashtable = (Hashtable<QName, ExtensionDeserializer>)this.deserializerReg.get(clazz);
        if (hashtable == null) {
            hashtable = new Hashtable<QName, ExtensionDeserializer>();
            this.deserializerReg.put(clazz, hashtable);
        }
        hashtable.put(qName, extensionDeserializer);
    }

    public ExtensionSerializer querySerializer(Class clazz, QName qName) throws WSDLException {
        Map map = (Map)this.serializerReg.get(clazz);
        ExtensionSerializer extensionSerializer = null;
        if (map != null) {
            extensionSerializer = (ExtensionSerializer)map.get(qName);
        }
        if (extensionSerializer == null) {
            extensionSerializer = this.defaultSer;
        }
        if (extensionSerializer == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionSerializer found to serialize a '" + qName + "' element in the context of a '" + clazz.getName() + "'.");
        }
        return extensionSerializer;
    }

    public ExtensionDeserializer queryDeserializer(Class clazz, QName qName) throws WSDLException {
        Map map = (Map)this.deserializerReg.get(clazz);
        ExtensionDeserializer extensionDeserializer = null;
        if (map != null) {
            extensionDeserializer = (ExtensionDeserializer)map.get(qName);
        }
        if (extensionDeserializer == null) {
            extensionDeserializer = this.defaultDeser;
        }
        if (extensionDeserializer == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionDeserializer found to deserialize a '" + qName + "' element in the context of a '" + clazz.getName() + "'.");
        }
        return extensionDeserializer;
    }

    public Set getAllowableExtensions(Class clazz) {
        Map map = (Map)this.deserializerReg.get(clazz);
        return map != null ? map.keySet() : null;
    }

    public void mapExtensionTypes(Class clazz, QName qName, Class clazz2) {
        Hashtable<QName, Class> hashtable = (Hashtable<QName, Class>)this.extensionTypeReg.get(clazz);
        if (hashtable == null) {
            hashtable = new Hashtable<QName, Class>();
            this.extensionTypeReg.put(clazz, hashtable);
        }
        hashtable.put(qName, clazz2);
    }

    public ExtensibilityElement createExtension(Class clazz, QName qName) throws WSDLException {
        Map map = (Map)this.extensionTypeReg.get(clazz);
        Class clazz2 = null;
        if (map != null) {
            clazz2 = (Class)map.get(qName);
        }
        if (clazz2 == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "No Java extensionType found to represent a '" + qName + "' element in the context of a '" + clazz.getName() + "'.");
        }
        if (!ExtensibilityElement.class.isAssignableFrom(clazz2)) {
            throw new WSDLException("CONFIGURATION_ERROR", "The Java extensionType '" + clazz2.getName() + "' does " + "not implement the ExtensibilityElement " + "interface.");
        }
        try {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)clazz2.newInstance();
            if (extensibilityElement.getElementType() == null) {
                extensibilityElement.setElementType(qName);
            }
            return extensibilityElement;
        }
        catch (Exception exception) {
            throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating Java extensionType '" + clazz2.getName() + "'.", exception);
        }
    }

    public void registerExtensionAttributeType(Class clazz, QName qName, int n) {
        Hashtable<QName, Integer> hashtable = (Hashtable<QName, Integer>)this.extensionAttributeTypeReg.get(clazz);
        if (hashtable == null) {
            hashtable = new Hashtable<QName, Integer>();
            this.extensionAttributeTypeReg.put(clazz, hashtable);
        }
        hashtable.put(qName, new Integer(n));
    }

    public int queryExtensionAttributeType(Class clazz, QName qName) {
        Map map = (Map)this.extensionAttributeTypeReg.get(clazz);
        Integer n = null;
        if (map != null) {
            n = (Integer)map.get(qName);
        }
        if (n != null) {
            return n;
        }
        return -1;
    }
}

