/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.dashboardstatus;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.plugins.dashboardstatus.ConnectionLogItem;
import com.mirth.connect.plugins.dashboardstatus.DashboardConnectorStatusMonitor;
import com.mirth.connect.plugins.dashboardstatus.DashboardConnectorStatusServletInterface;
import com.mirth.connect.server.api.CheckAuthorizedChannelId;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ControllerFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;

public class DashboardConnectorStatusServlet
extends MirthServlet
implements DashboardConnectorStatusServletInterface {
    private static final DashboardConnectorStatusMonitor monitor = (DashboardConnectorStatusMonitor)ControllerFactory.getFactory().createExtensionController().getServicePlugins().get("Dashboard Connector Status Service");

    public DashboardConnectorStatusServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, "Dashboard Connector Status Service");
    }

    public Map<String, Object[]> getConnectorStateMap(String serverId) {
        return monitor.getConnectorListener().getConnectorStateMap(serverId);
    }

    public Map<String, String> getChannelStates() {
        Map connectorStates = this.redactChannelIds(monitor.getConnectorListener().getConnectorStateMap(""));
        HashMap<String, String> channelStates = new HashMap<String, String>();
        for (Map.Entry entry : connectorStates.entrySet()) {
            String channelId;
            if (!StringUtils.contains((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"_0") || this.isChannelRedacted(channelId = StringUtils.remove((String)((String)entry.getKey()), (String)"_0"))) continue;
            channelStates.put(channelId, (String)((Object[])entry.getValue())[1]);
        }
        return channelStates;
    }

    @CheckAuthorizedChannelId
    public String getChannelState(String channelId) {
        Object[] stateArray = monitor.getConnectorListener().getConnectorStateMap("").get(channelId + "_0");
        if (stateArray == null) {
            throw new MirthApiException(Response.Status.NOT_FOUND);
        }
        return (String)stateArray[1];
    }

    public LinkedList<ConnectionLogItem> getAllChannelLogs(String serverId, int fetchSize, Long lastLogId) {
        return monitor.getConnectorListener().getChannelLog(serverId, null, fetchSize, lastLogId);
    }

    public LinkedList<ConnectionLogItem> getChannelLog(String serverId, String channelId, int fetchSize, Long lastLogId) {
        return monitor.getConnectorListener().getChannelLog(serverId, channelId, fetchSize, lastLogId);
    }
}

