/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.js;

import com.mirth.connect.connectors.js.JavaScriptDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthJavascriptTransformerException;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.userutil.Response;
import com.mirth.connect.userutil.Status;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class JavaScriptDispatcher
extends DestinationConnector {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Logger scriptLogger = LogManager.getLogger((String)"js-connector");
    private EventController eventController = this.getEventController();
    private ScriptController scriptController = this.getScriptController();
    private ContextFactoryController contextFactoryController = this.getContextFactoryController();
    private CompiledScriptCache compiledScriptCache = this.getCompiledScriptCache();
    private JavaScriptDispatcherProperties connectorProperties;
    private String scriptId;
    List<String> contextFactoryIdList = new ArrayList<String>();
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();
    private boolean debug = false;
    private MirthMain debugger;
    private boolean ignoreBreakpoints = false;

    protected EventController getEventController() {
        return ControllerFactory.getFactory().createEventController();
    }

    protected ScriptController getScriptController() {
        return ControllerFactory.getFactory().createScriptController();
    }

    protected ChannelController getChannelController() {
        return ControllerFactory.getFactory().createChannelController();
    }

    protected ContextFactoryController getContextFactoryController() {
        return ControllerFactory.getFactory().createContextFactoryController();
    }

    protected CompiledScriptCache getCompiledScriptCache() {
        return CompiledScriptCache.getInstance();
    }

    public void onDeploy() throws ConnectorTaskException {
        this.onDeploy(null);
    }

    public void onDebugDeploy(DebugOptions debugOptions) throws ConnectorTaskException {
        this.onDeploy(debugOptions);
    }

    public void onDeploy(DebugOptions debugOptions) throws ConnectorTaskException {
        this.connectorProperties = (JavaScriptDispatcherProperties)this.getConnectorProperties();
        this.debug = debugOptions != null && debugOptions.isDestinationConnectorScripts();
        Channel channelModel = new Channel();
        channelModel = this.getChannelController().getChannelById(this.getChannelId());
        this.scriptId = ScriptController.getScriptId((String)("JavaScript_Writer_" + this.getMetaDataId()), (String)this.getChannelId());
        try {
            MirthContextFactory contextFactory = null;
            HashMap<String, MirthContextFactory> contextFactories = new HashMap<String, MirthContextFactory>();
            if (this.debug) {
                contextFactory = this.contextFactoryController.getDebugContextFactory(this.getResourceIds(), this.getChannelId(), this.scriptId);
                this.contextFactoryIdList.add(contextFactory.getId());
                contextFactory.setContextType(ContextType.DESTINATION_DISPATCHER);
                contextFactory.setScriptText(this.connectorProperties.getScript());
                contextFactory.setDebugType(Boolean.valueOf(true));
                contextFactories.put(this.scriptId, contextFactory);
                this.debugger = this.getDebugger(contextFactory);
            } else {
                contextFactory = this.contextFactoryController.getContextFactory(this.getResourceIds());
                contextFactory.setContextType(ContextType.DESTINATION_DISPATCHER);
                this.contextFactoryIdList.add(contextFactory.getId());
                contextFactory.setScriptText(this.connectorProperties.getScript());
                contextFactories.put(this.scriptId, contextFactory);
            }
            this.scriptController.compileChannelScripts(contextFactories, channelModel);
        }
        catch (Exception e) {
            throw new ConnectorTaskException("Error compiling/adding script.", (Throwable)e);
        }
        this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
    }

    protected MirthMain getDebugger(MirthContextFactory contextFactory) {
        return MirthMain.mirthMainEmbedded((ContextFactory)contextFactory, (Object)this.scopeProvider, (String)(this.getChannel().getName() + "-" + this.getChannelId()), (String)this.scriptId);
    }

    protected void compileAndAddScript(MirthContextFactory contextFactory, String scriptId) throws Exception {
        JavaScriptUtil.compileAndAddScript((String)this.getChannelId(), (MirthContextFactory)contextFactory, (String)scriptId, (String)this.connectorProperties.getScript(), (ContextType)ContextType.DESTINATION_DISPATCHER, null, null);
    }

    public void onUndeploy() throws ConnectorTaskException {
        if (this.scriptId != null) {
            JavaScriptUtil.removeScriptFromCache((String)this.scriptId);
            if (this.debug && this.debugger != null) {
                this.contextFactoryController.removeDebugContextFactory(this.getResourceIds(), this.getChannelId(), this.scriptId);
                this.debugger.dispose();
                this.debugger = null;
            }
        }
    }

    public void onStart() throws ConnectorTaskException {
        this.ignoreBreakpoints = false;
        if (this.debug && this.debugger != null) {
            this.debugger.enableDebugging();
        }
    }

    public void onStop() throws ConnectorTaskException {
        if (this.debug && this.debugger != null) {
            this.debugger.finishScriptExecution();
        }
    }

    public void onHalt() throws ConnectorTaskException {
    }

    public void stopDebugging() throws ConnectorTaskException {
        this.ignoreBreakpoints = true;
        if (this.debug && this.debugger != null) {
            this.debugger.finishScriptExecution();
        }
    }

    public void replaceConnectorProperties(ConnectorProperties connectorProperties, ConnectorMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.mirth.connect.donkey.model.message.Response send(ConnectorProperties connectorProperties, ConnectorMessage message) throws InterruptedException {
        JavaScriptDispatcherProperties javaScriptDispatcherProperties = (JavaScriptDispatcherProperties)connectorProperties;
        try {
            MirthContextFactory contextFactory;
            MirthContextFactory mirthContextFactory = contextFactory = this.debug ? this.contextFactoryController.getDebugContextFactory(this.getResourceIds(), this.getChannelId(), this.scriptId) : this.contextFactoryController.getContextFactory(this.getResourceIds());
            if (!this.contextFactoryIdList.contains(contextFactory.getId())) {
                JavaScriptDispatcher javaScriptDispatcher = this;
                synchronized (javaScriptDispatcher) {
                    MirthContextFactory mirthContextFactory2 = contextFactory = this.debug ? this.contextFactoryController.getDebugContextFactory(this.getResourceIds(), this.getChannelId(), this.scriptId) : this.contextFactoryController.getContextFactory(this.getResourceIds());
                    if (!this.contextFactoryIdList.contains(contextFactory.getId())) {
                        JavaScriptUtil.recompileGeneratedScript((MirthContextFactory)contextFactory, (String)this.scriptId);
                        this.contextFactoryIdList.add(contextFactory.getId());
                    }
                }
            }
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.SENDING));
            com.mirth.connect.donkey.model.message.Response response = (com.mirth.connect.donkey.model.message.Response)JavaScriptUtil.execute((JavaScriptTask)new JavaScriptDispatcherTask(contextFactory, message));
            response.setValidate(javaScriptDispatcherProperties.getDestinationConnectorProperties().isValidateResponse());
            com.mirth.connect.donkey.model.message.Response response2 = response;
            return response2;
        }
        catch (Exception e) {
            this.logger.error("Error executing script (" + connectorProperties.getName() + " \"" + this.getDestinationName() + "\" on channel " + this.getChannelId() + ").", (Throwable)e);
            this.eventController.dispatchEvent((Event)new ErrorEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), Long.valueOf(message.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, this.getDestinationName(), connectorProperties.getName(), "Error executing script", (Throwable)e));
            com.mirth.connect.donkey.model.message.Response response = new com.mirth.connect.donkey.model.message.Response(com.mirth.connect.donkey.model.message.Status.ERROR, null, ErrorMessageBuilder.buildErrorResponse((String)"Error executing script", (Throwable)e), ErrorMessageBuilder.buildErrorMessage((String)connectorProperties.getName(), (String)"Error executing script", (Throwable)e));
            return response;
        }
        finally {
            this.eventController.dispatchEvent((Event)new ConnectionStatusEvent(this.getChannelId(), Integer.valueOf(this.getMetaDataId()), this.getDestinationName(), ConnectionStatusEventType.IDLE));
        }
    }

    private class JavaScriptDispatcherTask
    extends JavaScriptTask<com.mirth.connect.donkey.model.message.Response> {
        private ConnectorMessage message;

        public JavaScriptDispatcherTask(MirthContextFactory contextFactory, ConnectorMessage message) {
            super(contextFactory, (DestinationConnector)JavaScriptDispatcher.this);
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public com.mirth.connect.donkey.model.message.Response doCall() throws Exception {
            String responseData = null;
            String responseError = null;
            String responseStatusMessage = "JavaScript evaluation successful.";
            com.mirth.connect.donkey.model.message.Status responseStatus = com.mirth.connect.donkey.model.message.Status.SENT;
            Script compiledScript = JavaScriptDispatcher.this.compiledScriptCache.getCompiledScript(JavaScriptDispatcher.this.scriptId);
            if (compiledScript == null) {
                responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)"Script not found in cache", null);
                responseError = ErrorMessageBuilder.buildErrorMessage((String)JavaScriptDispatcher.this.connectorProperties.getName(), (String)"Script not found in cache", null);
                responseStatus = com.mirth.connect.donkey.model.message.Status.ERROR;
                JavaScriptDispatcher.this.logger.error("Script not found in cache (" + JavaScriptDispatcher.this.connectorProperties.getName() + " \"" + JavaScriptDispatcher.this.getDestinationName() + "\" on channel " + JavaScriptDispatcher.this.getChannelId() + ").");
                JavaScriptDispatcher.this.eventController.dispatchEvent((Event)new ErrorEvent(JavaScriptDispatcher.this.getChannelId(), Integer.valueOf(JavaScriptDispatcher.this.getMetaDataId()), Long.valueOf(this.message.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, JavaScriptDispatcher.this.getDestinationName(), JavaScriptDispatcher.this.connectorProperties.getName(), "Script not found in cache", null));
            } else {
                try {
                    Object result;
                    Scriptable scope = JavaScriptScopeUtil.getMessageDispatcherScope((ContextFactory)this.getContextFactory(), (Object)JavaScriptDispatcher.this.scriptLogger, (String)JavaScriptDispatcher.this.getChannelId(), (ImmutableConnectorMessage)new ImmutableConnectorMessage(this.message, true, JavaScriptDispatcher.this.getDestinationIdMap()));
                    if (JavaScriptDispatcher.this.debug) {
                        JavaScriptDispatcher.this.scopeProvider.setScope(scope);
                        if (JavaScriptDispatcher.this.debugger != null && !JavaScriptDispatcher.this.ignoreBreakpoints) {
                            JavaScriptDispatcher.this.debugger.doBreak();
                            if (!JavaScriptDispatcher.this.debugger.isVisible()) {
                                JavaScriptDispatcher.this.debugger.setVisible(true);
                            }
                        }
                    }
                    if ((result = this.executeScript(compiledScript, scope)) != null && !(result instanceof Undefined)) {
                        if (result instanceof NativeJavaObject) {
                            Object object = ((NativeJavaObject)result).unwrap();
                            if (object instanceof Response) {
                                com.mirth.connect.donkey.model.message.Response response = JavaScriptUtil.convertToDonkeyResponse((Object)object);
                                return response;
                            }
                            if (object instanceof Status) {
                                responseStatus = JavaScriptUtil.convertToDonkeyStatus((Status)((Status)object));
                            } else {
                                responseData = object.toString();
                            }
                        } else {
                            if (result instanceof Response) {
                                com.mirth.connect.donkey.model.message.Response object = JavaScriptUtil.convertToDonkeyResponse((Object)result);
                                return object;
                            }
                            if (result instanceof Status) {
                                responseStatus = JavaScriptUtil.convertToDonkeyStatus((Status)((Status)result));
                            } else {
                                responseData = (String)Context.jsToJava((Object)result, String.class);
                            }
                        }
                    }
                }
                catch (Throwable t22) {
                    MirthJavascriptTransformerException t22;
                    responseStatusMessage = ErrorMessageBuilder.buildErrorResponse((String)("Error evaluating " + JavaScriptDispatcher.this.getConnectorProperties().getName()), (Throwable)t22);
                    if (t22 instanceof RhinoException) {
                        try {
                            String script = CompiledScriptCache.getInstance().getSourceScript(JavaScriptDispatcher.this.scriptId);
                            int linenumber = ((RhinoException)t22).lineNumber();
                            String errorReport = JavaScriptUtil.getSourceCode((String)script, (int)linenumber, (int)0);
                            t22 = new MirthJavascriptTransformerException((RhinoException)t22, JavaScriptDispatcher.this.getChannelId(), JavaScriptDispatcher.this.getDestinationName(), 0, JavaScriptDispatcher.this.getConnectorProperties().getName(), errorReport);
                        }
                        catch (Exception ee) {
                            t22 = new MirthJavascriptTransformerException((RhinoException)t22, JavaScriptDispatcher.this.getChannelId(), JavaScriptDispatcher.this.getDestinationName(), 0, JavaScriptDispatcher.this.getConnectorProperties().getName(), null);
                        }
                    }
                    responseError = ErrorMessageBuilder.buildErrorMessage((String)JavaScriptDispatcher.this.connectorProperties.getName(), (String)("Error evaluating " + JavaScriptDispatcher.this.getConnectorProperties().getName()), (Throwable)t22);
                    responseStatus = com.mirth.connect.donkey.model.message.Status.ERROR;
                    JavaScriptDispatcher.this.logger.error("Error evaluating " + JavaScriptDispatcher.this.getConnectorProperties().getName() + " (" + JavaScriptDispatcher.this.connectorProperties.getName() + " \"" + JavaScriptDispatcher.this.getDestinationName() + "\" on channel " + JavaScriptDispatcher.this.getChannelId() + ").", (Throwable)t22);
                    JavaScriptDispatcher.this.eventController.dispatchEvent((Event)new ErrorEvent(JavaScriptDispatcher.this.getChannelId(), Integer.valueOf(JavaScriptDispatcher.this.getMetaDataId()), Long.valueOf(this.message.getMessageId()), ErrorEventType.DESTINATION_CONNECTOR, JavaScriptDispatcher.this.getDestinationName(), JavaScriptDispatcher.this.connectorProperties.getName(), "Error evaluating " + JavaScriptDispatcher.this.getConnectorProperties().getName(), (Throwable)t22));
                }
                finally {
                    Context.exit();
                }
            }
            return new com.mirth.connect.donkey.model.message.Response(responseStatus, responseData, responseStatusMessage, responseError);
        }
    }
}

