/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Random;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class Anonymizer {
    private String[] femaleFirstNames = new String[]{"Arwen", "Anna", "Amy", "Betty", "Christine", "Deirdre", "Emma", "Eowyn", "Elspeth", "Felicity", "Gertrude", "Helga", "Ingrid", "Juliet", "Karin", "Kegan", "Laura", "Lisbet", "Maria", "Nadia", "Ophelia", "Patience", "Questa", "Ruth", "Shannon", "Tanya", "Ursula", "Viora", "Wilma", "Xena", "Yelena", "Zoie", "Enisa", "Annette", "Gunhild"};
    private String[] maleFirstNames = new String[]{"Aaron", "Andrew", "Bill", "Bj\u00f6rn", "Callum", "Darragh", "Don", "Erik", "Frank", "Frodo", "George", "Harley", "Igor", "Jeremiah", "Joe", "John", "Kalevi", "Larry", "Mikko", "Marc", "Mohannad", "Mohammed", "Niko", "Olin", "Peter", "Per", "Paul", "Quinn", "Rafe", "Rob", "Sebastian", "Scott", "Sean", "Thor", "Ulf", "Vilhelm", "William", "Xavier", "Yngve", "Zerah", "Gunter", "Bo"};
    private String[] lastNames = new String[]{"Smith", "Johnson", "Williams", "Wallace", "Wiik", "Cowan", "Hussain", "Boccanfuso", "Mohan", "Dennison", "Morley", "Lipton", "Dobbs", "Bernard", "Lowe", "Brown", "Ristovik", "Tran", "Allen", "Young", "White", "Miller", "Davis", "Wright", "Hill", "Underhill", "Green", "Richardson", "Coleman", "Simmons", "Alexander", "Russell", "Baggins", "Undomiel", "Took", "Zeilinger", "Yang"};
    private long salt;

    public Anonymizer() {
        this(new Random().nextLong());
    }

    public Anonymizer(long salt) {
        if (salt == 0L) {
            salt = new Random().nextLong();
        } else if (salt == 1L) {
            salt = System.nanoTime() % 86400000000000L;
        }
        this.salt = salt;
    }

    public static String SHA1(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] sha1hash = new byte[40];
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
            sha1hash = md.digest();
            return Anonymizer.encodeHex(sha1hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String encodeHex(byte[] data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int b = data[i] & 0xFF;
            if (b < 16) {
                ret.append("0");
            }
            ret.append(Integer.toHexString(b));
        }
        return ret.toString();
    }

    public static byte[] decodeHex(String hex) {
        byte[] ret = new byte[hex.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return ret;
    }

    public static long decodeLong(String hex, int posn) {
        byte[] data = Anonymizer.decodeHex(hex);
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret = ret << 8 | (long)data[posn++ % data.length] & 0xFFL;
        }
        ret = Math.abs(ret);
        return ret;
    }

    public static String updateId(DicomObject ds, int tag, long deident) {
        String orig = ds.getString(tag);
        if (orig == null) {
            orig = Integer.toHexString(tag);
        }
        String v = Anonymizer.SHA1(orig + deident);
        v = v.substring(0, 14).replace('+', '_');
        ds.putString(tag, null, v);
        return v;
    }

    public static String updateUID(DicomObject ds, int tag, long deident) {
        String orig = ds.getString(tag);
        String v = Anonymizer.SHA1(orig + deident);
        String uid = "2.25." + Anonymizer.decodeLong(v, 0) + "." + Anonymizer.decodeLong(v, 8) + "." + Anonymizer.decodeLong(v, 16);
        ds.putString(tag, null, uid);
        return v;
    }

    public void anonymize(DicomObject ds) {
        String newPid = Anonymizer.updateId(ds, 0x100020, this.salt);
        ds.putString(0x100021, null, "Anon");
        long lastId = Anonymizer.decodeLong(newPid, 0);
        long firstId = Anonymizer.decodeLong(newPid, 1);
        String last = this.lastNames[(int)(lastId % (long)this.lastNames.length)];
        String sex = ds.getString(0x100040);
        boolean isFemale = "F".equalsIgnoreCase(sex);
        if ("O".equalsIgnoreCase(sex) || sex == null) {
            isFemale = (firstId & 0x100L) != 0L;
        }
        String first = isFemale ? this.femaleFirstNames[(int)(firstId % (long)this.femaleFirstNames.length)] : this.maleFirstNames[(int)(firstId % (long)this.maleFirstNames.length)];
        ds.putString(0x100010, VR.PN, last + "^" + first + "^anonymous");
        Calendar cal = Calendar.getInstance();
        int duration = 1 + (int)(Anonymizer.decodeLong(newPid, 1) % 35600L);
        cal.add(6, -duration);
        ds.putDate(0x100030, VR.DA, cal.getTime());
        String newStudyUID = Anonymizer.updateUID(ds, 0x20000D, this.salt);
        cal.add(6, (int)(Anonymizer.decodeLong(newStudyUID, 0) % (long)duration));
        ds.putDate(524320, VR.DA, cal.getTime());
        ds.remove(0x101000);
        ds.remove(0x101002);
        Anonymizer.updateUID(ds, 0x20000E, this.salt);
        Anonymizer.updateUID(ds, 524312, this.salt);
        if (ds.contains(131075)) {
            Anonymizer.updateUID(ds, 131075, this.salt);
        }
        Anonymizer.updateId(ds, 524368, this.salt);
        Anonymizer.updateId(ds, 0x200010, this.salt);
    }
}

