/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.http;

import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import com.mirth.connect.plugins.CodeTemplatePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpListenerCodeTemplatePlugin
extends CodeTemplatePlugin {
    public HttpListenerCodeTemplatePlugin(String name) {
        super(name);
    }

    public Map<String, List<CodeTemplate>> getReferenceItems() {
        HashMap<String, List<CodeTemplate>> referenceItems = new HashMap<String, List<CodeTemplate>>();
        ArrayList<CodeTemplate> httpListenerFunctionsList = new ArrayList<CodeTemplate>();
        httpListenerFunctionsList.add(new CodeTemplate("Get HTTP Request Method", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "sourceMap.get('method')", "Retrieves the method (e.g. GET, POST) from an incoming HTTP request."));
        httpListenerFunctionsList.add(new CodeTemplate("Get HTTP Request Context Path", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "sourceMap.get('contextPath')", "Retrieves the context path from an incoming HTTP request."));
        httpListenerFunctionsList.add(new CodeTemplate("Get HTTP Request Header", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "sourceMap.get('headers').getHeader('Header-Name')", "Retrieves a header value from an incoming HTTP request."));
        httpListenerFunctionsList.add(new CodeTemplate("Get HTTP Request Parameter", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getConnectorContextSet(), "sourceMap.get('parameters').getParameter('parameterName')", "Retrieves a query/form parameter from an incoming HTTP request. If multiple values exist for the parameter, an array will be returned."));
        httpListenerFunctionsList.add(new CodeTemplate("Convert HTTP Payload to XML", CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE, CodeTemplateContextSet.getGlobalContextSet(), "HTTPUtil.httpBodyToXml(httpBody, contentType)", "Serializes an HTTP request body into XML. Multipart requests will also automatically be parsed into separate XML nodes. The body may be passed in as a string or input stream."));
        referenceItems.put("HTTP Listener Functions", httpListenerFunctionsList);
        return referenceItems;
    }

    public String getPluginPointName() {
        return this.pluginName + " Code Template Plugin";
    }

    public void start() {
    }

    public void stop() {
    }

    public void reset() {
    }
}

