/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.scriptfilestep;

import com.mirth.connect.model.Step;
import com.mirth.connect.util.ScriptBuilderException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ExternalScriptStep
extends Step {
    public static final String PLUGIN_POINT = "External Script";
    private String scriptPath;

    public ExternalScriptStep() {
        this.scriptPath = "";
    }

    public ExternalScriptStep(ExternalScriptStep props) {
        super((Step)props);
        this.scriptPath = props.getScriptPath();
    }

    public String getScript(boolean loadFiles) throws ScriptBuilderException {
        StringBuilder script = new StringBuilder();
        if (loadFiles) {
            try {
                script.append("\n" + FileUtils.readFileToString((File)new File(this.scriptPath)) + "\n");
            }
            catch (IOException e) {
                throw new ScriptBuilderException("Could not add script file.", (Throwable)e);
            }
        } else {
            script.append("// External script will be loaded on deploy\n");
            script.append("// Path: ").append(this.scriptPath).append('\n');
        }
        return script.toString();
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getType() {
        return PLUGIN_POINT;
    }

    public Step clone() {
        return new ExternalScriptStep(this);
    }
}

