/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans2;

import jcifs.Configuration;
import jcifs.internal.smb1.trans.SmbComTransaction;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public class Trans2FindFirst2
extends SmbComTransaction {
    static final int FLAGS_CLOSE_AFTER_THIS_REQUEST = 1;
    static final int FLAGS_CLOSE_IF_END_REACHED = 2;
    static final int FLAGS_RETURN_RESUME_KEYS = 4;
    static final int FLAGS_RESUME_FROM_PREVIOUS_END = 8;
    static final int FLAGS_FIND_WITH_BACKUP_INTENT = 16;
    private int searchAttributes;
    private int tflags;
    private int informationLevel;
    private int searchStorageType = 0;
    private int maxItems;
    private String wildcard;
    static final int SMB_INFO_STANDARD = 1;
    static final int SMB_INFO_QUERY_EA_SIZE = 2;
    static final int SMB_INFO_QUERY_EAS_FROM_LIST = 3;
    static final int SMB_FIND_FILE_DIRECTORY_INFO = 257;
    static final int SMB_FIND_FILE_FULL_DIRECTORY_INFO = 258;
    static final int SMB_FILE_NAMES_INFO = 259;
    static final int SMB_FILE_BOTH_DIRECTORY_INFO = 260;

    public Trans2FindFirst2(Configuration config, String filename, String wildcard, int searchAttributes, int batchCount, int batchSize) {
        super(config, (byte)50, (byte)1);
        this.path = filename.equals("\\") ? filename : (filename.charAt(filename.length() - 1) != '\\' ? filename + "\\" : filename);
        this.wildcard = wildcard;
        this.searchAttributes = searchAttributes & 0x37;
        this.tflags = 0;
        this.informationLevel = 260;
        this.totalDataCount = 0;
        this.maxParameterCount = 10;
        this.maxItems = batchCount;
        this.maxDataCount = batchSize;
        this.maxSetupCount = 0;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex++] = this.getSubCommand();
        dst[dstIndex++] = 0;
        return 2;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.searchAttributes, dst, dstIndex);
        SMBUtil.writeInt2(this.maxItems, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.tflags, dst, dstIndex += 2);
        SMBUtil.writeInt2(this.informationLevel, dst, dstIndex += 2);
        SMBUtil.writeInt4(this.searchStorageType, dst, dstIndex += 2);
        dstIndex += 4;
        dstIndex += this.writeString(this.path + this.wildcard, dst, dstIndex);
        return dstIndex - start;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("Trans2FindFirst2[" + super.toString() + ",searchAttributes=0x" + Hexdump.toHexString(this.searchAttributes, 2) + ",searchCount=" + this.maxItems + ",flags=0x" + Hexdump.toHexString(this.tflags, 2) + ",informationLevel=0x" + Hexdump.toHexString(this.informationLevel, 3) + ",searchStorageType=" + this.searchStorageType + ",filename=" + this.path + "]");
    }
}

