/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.connectors.tcp;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.connectors.tcp.TcpConnectorServletInterface;
import com.mirth.connect.connectors.tcp.TcpDispatcherProperties;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.util.ConnectorUtil;
import com.mirth.connect.server.util.TemplateValueReplacer;
import com.mirth.connect.util.ConnectionTestResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.math.NumberUtils;

public class TcpConnectorServlet
extends MirthServlet
implements TcpConnectorServletInterface {
    protected static final TemplateValueReplacer replacer = new TemplateValueReplacer();

    public TcpConnectorServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, "HTTP Connector Service");
    }

    public ConnectionTestResponse testConnection(String channelId, String channelName, TcpDispatcherProperties properties) {
        try {
            String host = replacer.replaceValues(properties.getRemoteAddress(), channelId, channelName);
            int port = NumberUtils.toInt((String)replacer.replaceValues(properties.getRemotePort(), channelId, channelName));
            int timeout = NumberUtils.toInt((String)replacer.replaceValues(properties.getResponseTimeout(), channelId, channelName));
            if (!properties.isOverrideLocalBinding()) {
                return ConnectorUtil.testConnection((String)host, (int)port, (int)timeout);
            }
            String localAddr = replacer.replaceValues(properties.getLocalAddress(), channelId, channelName);
            int localPort = NumberUtils.toInt((String)replacer.replaceValues(properties.getLocalPort(), channelId, channelName));
            return ConnectorUtil.testConnection((String)host, (int)port, (int)timeout, (String)localAddr, (int)localPort);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }
}

